/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.banner.BannerConfig;
import io.quarkus.builder.Version;
import io.quarkus.deployment.IsTest;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ConsoleFormatterBannerBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.runtime.BannerRecorder;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.util.ClassPathUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

public class BannerProcessor {
    private static final Logger logger = Logger.getLogger(BannerProcessor.class);

    @BuildStep(onlyIfNot={IsTest.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public ConsoleFormatterBannerBuildItem recordBanner(BannerRecorder recorder, BannerConfig config) {
        String bannerText = this.readBannerFile(config);
        return new ConsoleFormatterBannerBuildItem((RuntimeValue<Optional<Supplier<String>>>)recorder.provideBannerSupplier(bannerText));
    }

    @BuildStep
    HotDeploymentWatchedFileBuildItem watchBannerChanges(BannerConfig config) {
        return new HotDeploymentWatchedFileBuildItem(config.path);
    }

    private String readBannerFile(BannerConfig config) {
        try {
            Map.Entry<URL, Boolean> entry = this.getBanner(config);
            URL bannerResourceURL = entry.getKey();
            if (bannerResourceURL == null) {
                logger.warn((Object)"Could not locate banner file");
                return "";
            }
            return (String)ClassPathUtils.readStream((URL)bannerResourceURL, is -> {
                try {
                    byte[] content = FileUtil.readFileContents(is);
                    String bannerTitle = new String(content, StandardCharsets.UTF_8);
                    int width = 0;
                    try (Scanner scanner = new Scanner(bannerTitle);){
                        while (scanner.hasNextLine()) {
                            width = Math.max(width, scanner.nextLine().length());
                        }
                    }
                    String tagline = "\n";
                    Boolean isDefaultBanner = (Boolean)entry.getValue();
                    if (!isDefaultBanner.booleanValue()) {
                        tagline = String.format("\n%" + width + "s\n", "Powered by Quarkus " + Version.getVersion());
                    }
                    return bannerTitle + tagline;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (IOException e) {
            logger.warn((Object)"Unable to read banner file");
            return "";
        }
    }

    private Map.Entry<URL, Boolean> getBanner(BannerConfig config) throws IOException {
        Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(config.path);
        URL defaultBanner = null;
        URL firstNonDefaultBanner = null;
        while (resources.hasMoreElements() && firstNonDefaultBanner == null) {
            URL url = resources.nextElement();
            if (defaultBanner == null && this.isQuarkusCoreBanner(url)) {
                defaultBanner = url;
                continue;
            }
            firstNonDefaultBanner = url;
        }
        if (firstNonDefaultBanner == null) {
            return new AbstractMap.SimpleEntry<Object, Boolean>(defaultBanner, true);
        }
        return new AbstractMap.SimpleEntry<Object, Boolean>(firstNonDefaultBanner, false);
    }

    protected boolean isQuarkusCoreBanner(URL url) {
        if (!"jar".equals(url.getProtocol())) {
            return false;
        }
        String thisClassName = this.getClass().getName();
        try {
            return (Boolean)ClassPathUtils.processAsPath((URL)url, p -> {
                Path resolved = p.resolve("/" + thisClassName.replace('.', '/') + ".class");
                return Files.exists(resolved, new LinkOption[0]);
            });
        }
        catch (UncheckedIOException ex) {
            return false;
        }
    }
}

