/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.util;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.http.entity.ContentType;
import org.keycloak.client.admin.cli.util.Headers;
import org.keycloak.client.admin.cli.util.IoUtil;

public class HeadersBody {
    private Headers headers;
    private InputStream body;

    public HeadersBody(Headers headers) {
        this.headers = headers;
    }

    public HeadersBody(Headers headers, InputStream body) {
        this.headers = headers;
        this.body = body;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public InputStream getBody() {
        return this.body;
    }

    public String readBodyString() {
        byte[] buffer = this.readBodyBytes();
        return new String(buffer, this.getContentCharset());
    }

    public byte[] readBodyBytes() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IoUtil.copyStream(this.getBody(), os);
        return os.toByteArray();
    }

    public Charset getContentCharset() {
        return this.headers.getContentType().map(ContentType::getCharset).orElseGet(() -> Charset.forName("iso-8859-1"));
    }
}

