/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.commands;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.console.command.CommandException;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.keycloak.client.admin.cli.commands.AbstractAuthOptionsCmd;
import org.keycloak.client.admin.cli.config.ConfigData;
import org.keycloak.client.admin.cli.operations.ClientOperations;
import org.keycloak.client.admin.cli.operations.GroupOperations;
import org.keycloak.client.admin.cli.operations.LocalSearch;
import org.keycloak.client.admin.cli.operations.RoleOperations;
import org.keycloak.client.admin.cli.operations.UserOperations;
import org.keycloak.client.admin.cli.util.AuthUtil;
import org.keycloak.client.admin.cli.util.ConfigUtil;
import org.keycloak.client.admin.cli.util.OsUtil;

@CommandDefinition(name="add-roles", description="[ARGUMENTS]")
public class AddRolesCmd
extends AbstractAuthOptionsCmd {
    @Option(name="uusername", description="Target user's 'username'")
    String uusername;
    @Option(name="uid", description="Target user's 'id'")
    String uid;
    @Option(name="gname", description="Target group's 'name'")
    String gname;
    @Option(name="gpath", description="Target group's 'path'")
    String gpath;
    @Option(name="gid", description="Target group's 'id'")
    String gid;
    @Option(name="rname", description="Composite role's 'name'")
    String rname;
    @Option(name="rid", description="Composite role's 'id'")
    String rid;
    @Option(name="cclientid", description="Target client's 'clientId'")
    String cclientid;
    @Option(name="cid", description="Target client's 'id'")
    String cid;

    public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        LinkedList<String> roleNames = new LinkedList<String>();
        LinkedList<String> roleIds = new LinkedList<String>();
        try {
            Set<ObjectNode> rolesToAdd;
            List<ObjectNode> roles;
            String adminRoot;
            if (this.printHelp()) {
                CommandResult commandResult = this.help ? CommandResult.SUCCESS : CommandResult.FAILURE;
                return commandResult;
            }
            this.processGlobalOptions();
            Iterator<String> it = this.args.iterator();
            block14: while (it.hasNext()) {
                String option;
                switch (option = (String)it.next()) {
                    case "--rolename": {
                        this.optionRequiresValueCheck(it, option);
                        roleNames.add(it.next());
                        continue block14;
                    }
                    case "--roleid": {
                        this.optionRequiresValueCheck(it, option);
                        roleIds.add(it.next());
                        continue block14;
                    }
                }
                throw new IllegalArgumentException("Invalid option: " + option);
            }
            if (this.uid != null && this.uusername != null) {
                throw new IllegalArgumentException("Incompatible options: --uid and --uusername are mutually exclusive");
            }
            if (this.gid != null && this.gname != null || this.gid != null && this.gpath != null || this.gname != null && this.gpath != null) {
                throw new IllegalArgumentException("Incompatible options: --gid, --gname and --gpath are mutually exclusive");
            }
            if (roleNames.isEmpty() && roleIds.isEmpty()) {
                throw new IllegalArgumentException("No role to add specified. Use --rolename or --roleid to specify roles to add");
            }
            if (this.cid != null && this.cclientid != null) {
                throw new IllegalArgumentException("Incompatible options: --cid and --cclientid are mutually exclusive");
            }
            if (this.rid != null && this.rname != null) {
                throw new IllegalArgumentException("Incompatible options: --rid and --rname are mutually exclusive");
            }
            if (this.isUserSpecified() && this.isGroupSpecified()) {
                throw new IllegalArgumentException("Incompatible options: --uusername / --uid can't be used at the same time as --gname / --gid / --gpath");
            }
            if (this.isUserSpecified() && this.isCompositeRoleSpecified()) {
                throw new IllegalArgumentException("Incompatible options: --uusername / --uid can't be used at the same time as --rname / --rid");
            }
            if (this.isGroupSpecified() && this.isCompositeRoleSpecified()) {
                throw new IllegalArgumentException("Incompatible options: --rname / --rid can't be used at the same time as --gname / --gid / --gpath");
            }
            if (!(this.isUserSpecified() || this.isGroupSpecified() || this.isCompositeRoleSpecified())) {
                throw new IllegalArgumentException("No user nor group nor composite role specified. Use --uusername / --uid to specify user or --gname / --gid / --gpath to specify group or --rname / --rid to specify a composite role");
            }
            ConfigData config = ConfigUtil.loadConfig();
            config = this.copyWithServerInfo(config);
            this.setupTruststore(config, commandInvocation);
            String auth = null;
            config = this.ensureAuthInfo(config, commandInvocation);
            config = this.copyWithServerInfo(config);
            if (ConfigUtil.credentialsAvailable(config)) {
                auth = AuthUtil.ensureToken(config);
            }
            auth = auth != null ? "Bearer " + auth : null;
            String server = config.getServerUrl();
            String realm = this.getTargetRealm(config);
            String string = adminRoot = this.adminRestRoot != null ? this.adminRestRoot : this.composeAdminRoot(server);
            if (this.isUserSpecified()) {
                if (this.uid == null) {
                    this.uid = UserOperations.getIdFromUsername(adminRoot, realm, auth, this.uusername);
                }
                if (this.isClientSpecified()) {
                    if (this.cid == null) {
                        this.cid = ClientOperations.getIdFromClientId(adminRoot, realm, auth, this.cclientid);
                    }
                    roles = RoleOperations.getClientRoles(adminRoot, realm, this.cid, auth);
                    Set<ObjectNode> rolesToAdd2 = this.getRoleRepresentations(roleNames, roleIds, new LocalSearch(roles));
                    UserOperations.addClientRoles(adminRoot, realm, auth, this.uid, this.cid, new ArrayList<ObjectNode>(rolesToAdd2));
                } else {
                    rolesToAdd = this.getRoleRepresentations(roleNames, roleIds, new LocalSearch(RoleOperations.getRealmRolesAsNodes(adminRoot, realm, auth)));
                    UserOperations.addRealmRoles(adminRoot, realm, auth, this.uid, new ArrayList<ObjectNode>(rolesToAdd));
                }
            } else if (this.isGroupSpecified()) {
                if (this.gname != null) {
                    this.gid = GroupOperations.getIdFromName(adminRoot, realm, auth, this.gname);
                } else if (this.gpath != null) {
                    this.gid = GroupOperations.getIdFromPath(adminRoot, realm, auth, this.gpath);
                }
                if (this.isClientSpecified()) {
                    if (this.cid == null) {
                        this.cid = ClientOperations.getIdFromClientId(adminRoot, realm, auth, this.cclientid);
                    }
                    roles = RoleOperations.getClientRoles(adminRoot, realm, this.cid, auth);
                    Set<ObjectNode> rolesToAdd3 = this.getRoleRepresentations(roleNames, roleIds, new LocalSearch(roles));
                    GroupOperations.addClientRoles(adminRoot, realm, auth, this.gid, this.cid, new ArrayList<ObjectNode>(rolesToAdd3));
                } else {
                    rolesToAdd = this.getRoleRepresentations(roleNames, roleIds, new LocalSearch(RoleOperations.getRealmRolesAsNodes(adminRoot, realm, auth)));
                    GroupOperations.addRealmRoles(adminRoot, realm, auth, this.gid, new ArrayList<ObjectNode>(rolesToAdd));
                }
            } else if (this.isCompositeRoleSpecified()) {
                if (this.rid == null) {
                    this.rid = RoleOperations.getIdFromRoleName(adminRoot, realm, auth, this.rname);
                }
                if (this.isClientSpecified()) {
                    if (this.cid == null) {
                        this.cid = ClientOperations.getIdFromClientId(adminRoot, realm, auth, this.cclientid);
                    }
                    roles = RoleOperations.getClientRoles(adminRoot, realm, this.cid, auth);
                    Set<ObjectNode> rolesToAdd4 = this.getRoleRepresentations(roleNames, roleIds, new LocalSearch(roles));
                    RoleOperations.addClientRoles(adminRoot, realm, auth, this.rid, new ArrayList<ObjectNode>(rolesToAdd4));
                } else {
                    rolesToAdd = this.getRoleRepresentations(roleNames, roleIds, new LocalSearch(RoleOperations.getRealmRolesAsNodes(adminRoot, realm, auth)));
                    RoleOperations.addRealmRoles(adminRoot, realm, auth, this.rid, new ArrayList<ObjectNode>(rolesToAdd));
                }
            } else {
                throw new IllegalArgumentException("No user nor group, nor composite role specified. Use --uusername / --uid to specify user or --gname / --gid / --gpath to specify group or --rname / --rid to specify a composite role");
            }
            CommandResult commandResult = CommandResult.SUCCESS;
            return commandResult;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + this.suggestHelp(), e);
        }
        finally {
            commandInvocation.stop();
        }
    }

    private Set<ObjectNode> getRoleRepresentations(List<String> roleNames, List<String> roleIds, LocalSearch roleSearch) {
        ObjectNode r;
        HashSet<ObjectNode> rolesToAdd = new HashSet<ObjectNode>();
        for (String name : roleNames) {
            r = roleSearch.exactMatchOne(name, "name");
            if (r == null) {
                throw new RuntimeException("Role not found for name: " + name);
            }
            rolesToAdd.add(r);
        }
        for (String id : roleIds) {
            r = roleSearch.exactMatchOne(id, "id");
            if (r == null) {
                throw new RuntimeException("Role not found for id: " + id);
            }
            rolesToAdd.add(r);
        }
        return rolesToAdd;
    }

    private void optionRequiresValueCheck(Iterator<String> it, String option) {
        if (!it.hasNext()) {
            throw new IllegalArgumentException("Option " + option + " requires a value");
        }
    }

    private boolean isClientSpecified() {
        return this.cid != null || this.cclientid != null;
    }

    private boolean isGroupSpecified() {
        return this.gid != null || this.gname != null || this.gpath != null;
    }

    private boolean isUserSpecified() {
        return this.uid != null || this.uusername != null;
    }

    private boolean isCompositeRoleSpecified() {
        return this.rid != null || this.rname != null;
    }

    @Override
    protected boolean nothingToDo() {
        return this.noOptions() && this.uusername == null && this.uid == null && this.cclientid == null && (this.args == null || this.args.size() == 0);
    }

    protected String suggestHelp() {
        return OsUtil.EOL + "Try '" + OsUtil.CMD + " help add-roles' for more information";
    }

    @Override
    protected String help() {
        return AddRolesCmd.usage();
    }

    public static String usage() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Usage: " + OsUtil.CMD + " add-roles (--uusername USERNAME | --uid ID) [--cclientid CLIENT_ID | --cid ID] (--rolename NAME | --roleid ID)+ [ARGUMENTS]");
        out.println("       " + OsUtil.CMD + " add-roles (--gname NAME | --gpath PATH | --gid ID) [--cclientid CLIENT_ID | --cid ID] (--rolename NAME | --roleid ID)+ [ARGUMENTS]");
        out.println("       " + OsUtil.CMD + " add-roles (--rname ROLE_NAME | --rid ROLE_ID) [--cclientid CLIENT_ID | --cid ID] (--rolename NAME | --roleid ID)+ [ARGUMENTS]");
        out.println();
        out.println("Command to add realm or client roles to a user, a group or a composite role.");
        out.println();
        out.println("Use `" + OsUtil.CMD + " config credentials` to establish an authenticated session, or use CREDENTIALS OPTIONS");
        out.println("to perform one time authentication.");
        out.println();
        out.println("If client is specified using --cclientid or --cid then roles to add are client roles, otherwise they are realm roles.");
        out.println("Either a user, or a group needs to be specified. If user is specified using --uusername or --uid then roles are added");
        out.println("to a specific user. If group is specified using --gname, --gpath or --gid then roles are added to a specific group.");
        out.println("If composite role is specified using --rname or --rid then roles are added to a specific composite role.");
        out.println("One or more roles have to be specified using --rolename or --roleid so that they are added to a group, a user or a composite role.");
        out.println();
        out.println("Arguments:");
        out.println();
        out.println("  Global options:");
        out.println("    -x                    Print full stack trace when exiting with error");
        out.println("    --config              Path to the config file (" + ConfigUtil.DEFAULT_CONFIG_FILE_STRING + " by default)");
        out.println("    --no-config           Don't use config file - no authentication info is loaded or saved");
        out.println("    --token               Token to use to invoke on Keycloak.  Other credential may be ignored if this flag is set.");
        out.println("    --truststore PATH     Path to a truststore containing trusted certificates");
        out.println("    --trustpass PASSWORD  Truststore password (prompted for if not specified and --truststore is used)");
        out.println("    CREDENTIALS OPTIONS   Same set of options as accepted by '" + OsUtil.CMD + " config credentials' in order to establish");
        out.println("                          an authenticated sessions. In combination with --no-config option this allows transient");
        out.println("                          (on-the-fly) authentication to be performed which leaves no tokens in config file.");
        out.println();
        out.println("  Command specific options:");
        out.println("    --uusername           User's 'username'. If more than one user exists with the same username");
        out.println("                          you'll have to use --uid to specify the target user");
        out.println("    --uid                 User's 'id' attribute");
        out.println("    --gname               Group's 'name'. If more than one group exists with the same name you'll have");
        out.println("                          to use --gid, or --gpath to specify the target group");
        out.println("    --gpath               Group's 'path' attribute");
        out.println("    --gid                 Group's 'id' attribute");
        out.println("    --rname               Composite role's 'name' attribute");
        out.println("    --rid                 Composite role's 'id' attribute");
        out.println("    --cclientid           Client's 'clientId' attribute");
        out.println("    --cid                 Client's 'id' attribute");
        out.println("    --rolename            Role's 'name' attribute");
        out.println("    --roleid              Role's 'id' attribute");
        out.println("    -a, --admin-root URL      URL of Admin REST endpoint root if not default - e.g. http://localhost:8080/admin");
        out.println("    -r, --target-realm REALM  Target realm to issue requests against if not the one authenticated against");
        out.println();
        out.println("Examples:");
        out.println();
        out.println("Add 'offline_access' realm role to a user:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " add-roles -r demorealm --uusername testuser --rolename offline_access");
        out.println();
        out.println("Add 'realm-management' client roles 'view-users', 'view-clients' and 'view-realm' to a user:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " add-roles -r demorealm --uusername testuser --cclientid realm-management --rolename view-users --rolename view-clients --rolename view-realm");
        out.println();
        out.println("Add 'uma_authorization' realm role to a group:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " add-roles -r demorealm --gname PowerUsers --rolename uma_authorization");
        out.println();
        out.println("Add 'realm-management' client roles 'realm-admin' to a group:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " add-roles -r demorealm --gname PowerUsers --cclientid realm-management --rolename realm-admin");
        out.println();
        out.println();
        out.println("Use '" + OsUtil.CMD + " help' for general information and a list of commands");
        return sb.toString();
    }
}

