/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtp.header_extensions;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.extensions.unsigned.UnsignedKt;
import org.jitsi.rtp.rtp.header_extensions.HeaderExtensionParser;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0016J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lorg/jitsi/rtp/rtp/header_extensions/OneByteHeaderExtensionParser;", "Lorg/jitsi/rtp/rtp/header_extensions/HeaderExtensionParser;", "()V", "extHeaderSizeBytes", "", "getExtHeaderSizeBytes", "()I", "headerExtensionLabel", "getHeaderExtensionLabel", "minimumExtSizeBytes", "getMinimumExtSizeBytes", "getDataLengthBytes", "buf", "", "offset", "getId", "isMatchingType", "", "profileField", "writeIdAndLength", "", "id", "dataLength", "rtp"})
public final class OneByteHeaderExtensionParser
extends HeaderExtensionParser {
    @NotNull
    public static final OneByteHeaderExtensionParser INSTANCE = new OneByteHeaderExtensionParser();
    private static final int headerExtensionLabel = 48862;
    private static final int extHeaderSizeBytes = 1;
    private static final int minimumExtSizeBytes = 2;

    private OneByteHeaderExtensionParser() {
    }

    @Override
    public int getHeaderExtensionLabel() {
        return headerExtensionLabel;
    }

    @Override
    public int getExtHeaderSizeBytes() {
        return extHeaderSizeBytes;
    }

    @Override
    public int getMinimumExtSizeBytes() {
        return minimumExtSizeBytes;
    }

    @Override
    public boolean isMatchingType(int profileField) {
        return profileField == this.getHeaderExtensionLabel();
    }

    @Override
    public int getId(@NotNull byte[] buf, int offset) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        return buf[offset] >>> 4 & 0xF;
    }

    @Override
    public void writeIdAndLength(int id, int dataLength, @NotNull byte[] buf, int offset) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        if (!(1 <= id ? id < 15 : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(1 <= dataLength ? dataLength < 17 : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        buf[offset] = (byte)((byte)((id & 0xF) << 4) | (byte)(dataLength - 1 & 0xF));
    }

    @Override
    public int getDataLengthBytes(@NotNull byte[] buf, int offset) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        return UnsignedKt.toPositiveInt((byte)(buf[offset] & 0xF)) + 1;
    }
}

