/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtcp;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.extensions.bytearray.ByteArrayExtensionsKt;
import org.jitsi.rtp.util.FieldParsersKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jitsi/rtp/rtcp/RtcpHeader;", "", "()V", "Companion", "rtp"})
public final class RtcpHeader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int SIZE_BYTES = 8;
    public static final int VERSION_OFFSET = 0;
    public static final int PADDING_OFFSET = 0;
    public static final int REPORT_COUNT_OFFSET = 0;
    public static final int PACKET_TYPE_OFFSET = 1;
    public static final int LENGTH_OFFSET = 2;
    public static final int SENDER_SSRC_OFFSET = 4;

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004J\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004J\u0016\u0010\u0010\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004J\u0016\u0010\u0013\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004J\u001e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004J\u001e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004J\u001e\u0010\u001e\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0012J\u001e\u0010 \u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jitsi/rtp/rtcp/RtcpHeader$Companion;", "", "()V", "LENGTH_OFFSET", "", "PACKET_TYPE_OFFSET", "PADDING_OFFSET", "REPORT_COUNT_OFFSET", "SENDER_SSRC_OFFSET", "SIZE_BYTES", "VERSION_OFFSET", "getLength", "buf", "", "headerStartOffset", "getPacketType", "getReportCount", "getSenderSsrc", "", "getVersion", "hasPadding", "", "setLength", "", "length", "setPacketType", "packetType", "setPadding", "setReportCount", "reportCount", "setSenderSsrc", "senderSsrc", "setVersion", "version", "rtp"})
    public static final class Companion {
        private Companion() {
        }

        public final int getVersion(@NotNull byte[] buf, int headerStartOffset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            return FieldParsersKt.getBitsAsInt(buf, headerStartOffset + 0, 0, 2);
        }

        public final void setVersion(@NotNull byte[] buf, int headerStartOffset, int version2) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            FieldParsersKt.putNumberAsBits(buf, headerStartOffset + 0, 0, 2, version2);
        }

        public final boolean hasPadding(@NotNull byte[] buf, int headerStartOffset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            return ByteArrayExtensionsKt.getBitAsBool(buf, headerStartOffset + 0, 2);
        }

        public final void setPadding(@NotNull byte[] buf, int headerStartOffset, boolean hasPadding) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            ByteArrayExtensionsKt.putBitAsBoolean(buf, headerStartOffset + 0, 2, hasPadding);
        }

        public final int getReportCount(@NotNull byte[] buf, int headerStartOffset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            return FieldParsersKt.getBitsAsInt(buf, headerStartOffset + 0, 3, 5);
        }

        public final void setReportCount(@NotNull byte[] buf, int headerStartOffset, int reportCount) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            FieldParsersKt.putNumberAsBits(buf, headerStartOffset + 0, 3, 5, reportCount);
        }

        public final int getPacketType(@NotNull byte[] buf, int headerStartOffset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            return FieldParsersKt.getByteAsInt(buf, headerStartOffset + 1);
        }

        public final void setPacketType(@NotNull byte[] buf, int headerStartOffset, int packetType) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            buf[headerStartOffset + 1] = (byte)packetType;
        }

        public final int getLength(@NotNull byte[] buf, int headerStartOffset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            return FieldParsersKt.getShortAsInt(buf, headerStartOffset + 2);
        }

        public final void setLength(@NotNull byte[] buf, int headerStartOffset, int length) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            ByteArrayExtensionsKt.putShort(buf, headerStartOffset + 2, (short)length);
        }

        public final long getSenderSsrc(@NotNull byte[] buf, int headerStartOffset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            return FieldParsersKt.getIntAsLong(buf, headerStartOffset + 4);
        }

        public final void setSenderSsrc(@NotNull byte[] buf, int headerStartOffset, long senderSsrc) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            ByteArrayExtensionsKt.putInt(buf, headerStartOffset + 4, (int)senderSsrc);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

