/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.FilterNode;
import org.jitsi.nlj.transform.node.PacketLossConfig;
import org.jitsi.nlj.util.NodeStatsBlockExtensionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\nH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0014J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jitsi/nlj/transform/node/PacketLossNode;", "Lorg/jitsi/nlj/transform/node/FilterNode;", "config", "Lorg/jitsi/nlj/transform/node/PacketLossConfig;", "(Lorg/jitsi/nlj/transform/node/PacketLossConfig;)V", "getConfig", "()Lorg/jitsi/nlj/transform/node/PacketLossConfig;", "currentBurstPacketsDropped", "", "inBurst", "", "packetsSeen", "random", "Lkotlin/random/Random;", "accept", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "acceptBurst", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "getNodeStatsToAggregate", "trace", "", "f", "Lkotlin/Function0;", "jitsi-media-transform"})
public final class PacketLossNode
extends FilterNode {
    @NotNull
    private final PacketLossConfig config;
    @NotNull
    private final Random random;
    private boolean inBurst;
    private int packetsSeen;
    private int currentBurstPacketsDropped;

    public PacketLossNode(@NotNull PacketLossConfig config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super("PacketLossNode(" + config + ")");
        this.config = config;
        this.random = RandomKt.Random(System.currentTimeMillis());
    }

    @NotNull
    public final PacketLossConfig getConfig() {
        return this.config;
    }

    @Override
    protected boolean accept(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        return this.acceptBurst() && this.random.nextDouble() >= this.config.getUniformRate();
    }

    private final boolean acceptBurst() {
        boolean bl;
        if (!this.config.getBurstEnabled()) {
            return true;
        }
        int n = this.packetsSeen;
        this.packetsSeen = n + 1;
        if (this.packetsSeen % this.config.getBurstInterval() == 0) {
            this.inBurst = true;
        }
        if (this.inBurst) {
            n = this.currentBurstPacketsDropped;
            this.currentBurstPacketsDropped = n + 1;
            if (this.currentBurstPacketsDropped == this.config.getBurstSize()) {
                this.inBurst = false;
                this.currentBurstPacketsDropped = 0;
            }
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d0 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        $this$getNodeStats_u24lambda_u2d0.addNumber("configured_uniform_rate", this.config.getUniformRate());
        $this$getNodeStats_u24lambda_u2d0.addNumber("configured_burst_size", this.config.getBurstSize());
        $this$getNodeStats_u24lambda_u2d0.addNumber("configured_burst_interval", this.config.getBurstInterval());
        NodeStatsBlockExtensionsKt.addRatio$default($this$getNodeStats_u24lambda_u2d0, "actual_drop_rate", "num_discarded_packets", "num_input_packets", null, 8, null);
        return nodeStatsBlock;
    }

    @Override
    @NotNull
    protected NodeStatsBlock getNodeStatsToAggregate() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStatsToAggregate_u24lambda_u2d1 = nodeStatsBlock = super.getNodeStatsToAggregate();
        boolean bl = false;
        NodeStatsBlockExtensionsKt.addRatio$default($this$getNodeStatsToAggregate_u24lambda_u2d1, "actual_drop_rate", "num_discarded_packets", "num_input_packets", null, 8, null);
        return nodeStatsBlock;
    }
}

