/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.attribute;

import java.util.Arrays;
import org.ice4j.StunException;
import org.ice4j.attribute.Attribute;

public class RealmAttribute
extends Attribute {
    public static final String NAME = "REALM";
    private byte[] realm = null;

    RealmAttribute() {
        super('\u0014');
    }

    @Override
    void decodeAttributeBody(byte[] attributeValue, char offset, char length) throws StunException {
        this.realm = new byte[length];
        System.arraycopy(attributeValue, offset, this.realm, 0, length);
    }

    @Override
    public byte[] encode() {
        char type2 = this.getAttributeType();
        byte[] binValue = new byte[4 + this.getDataLength() + this.getDataLength() % 4];
        binValue[0] = (byte)(type2 >> 8);
        binValue[1] = (byte)(type2 & 0xFF);
        binValue[2] = (byte)(this.getDataLength() >> 8);
        binValue[3] = (byte)(this.getDataLength() & 0xFF);
        System.arraycopy(this.realm, 0, binValue, 4, this.getDataLength());
        return binValue;
    }

    @Override
    public char getDataLength() {
        return (char)this.realm.length;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public byte[] getRealm() {
        return this.realm == null ? null : (byte[])this.realm.clone();
    }

    public void setRealm(byte[] realm) {
        if (realm == null) {
            this.realm = null;
            return;
        }
        this.realm = new byte[realm.length];
        System.arraycopy(realm, 0, this.realm, 0, realm.length);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RealmAttribute)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        RealmAttribute att = (RealmAttribute)obj;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && Arrays.equals(att.realm, this.realm);
    }
}

