/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.ObjectTree;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class Disposer {
    private static final ObjectTree ourTree = new ObjectTree();
    private static boolean ourDebugMode;
    private static final Map<String, Disposable> ourKeyDisposables;

    public static boolean isDebugDisposerOn() {
        return "on".equals(System.getProperty("idea.disposer.debug"));
    }

    private Disposer() {
    }

    @Contract(pure=true, value="->new")
    @NotNull
    public static Disposable newDisposable() {
        return new Disposable(){

            @Override
            public void dispose() {
            }

            public String toString() {
                return "newDisposable";
            }
        };
    }

    @Contract(pure=true, value="_->new")
    @NotNull
    public static Disposable newDisposable(final @NotNull @NonNls String debugName) {
        if (debugName == null) {
            Disposer.$$$reportNull$$$0(0);
        }
        return new Disposable(){

            @Override
            public void dispose() {
            }

            public String toString() {
                return debugName;
            }
        };
    }

    @Contract(pure=true, value="->new")
    @NotNull
    public static CheckedDisposable newCheckedDisposable() {
        return new CheckedDisposableImpl();
    }

    @Contract(pure=true, value="_ -> new")
    @NotNull
    public static CheckedDisposable newCheckedDisposable(@NotNull String debugName) {
        if (debugName == null) {
            Disposer.$$$reportNull$$$0(1);
        }
        return new NamedCheckedDisposable(debugName);
    }

    @Contract(pure=true, value="_->new")
    @NotNull
    public static Disposable newDisposable(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            Disposer.$$$reportNull$$$0(2);
        }
        Disposable disposable = Disposer.newDisposable();
        Disposer.register(parentDisposable, disposable);
        Disposable disposable2 = disposable;
        if (disposable2 == null) {
            Disposer.$$$reportNull$$$0(3);
        }
        return disposable2;
    }

    @Contract(pure=true, value="_,_->new")
    @NotNull
    public static Disposable newDisposable(@NotNull Disposable parentDisposable, @NotNull String debugName) {
        if (parentDisposable == null) {
            Disposer.$$$reportNull$$$0(4);
        }
        if (debugName == null) {
            Disposer.$$$reportNull$$$0(5);
        }
        Disposable result2 = Disposer.newDisposable(debugName);
        Disposer.register(parentDisposable, result2);
        Disposable disposable = result2;
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(6);
        }
        return disposable;
    }

    @Contract(pure=true, value="_->new")
    @NotNull
    public static CheckedDisposable newCheckedDisposable(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            Disposer.$$$reportNull$$$0(7);
        }
        CheckedDisposable disposable = Disposer.newCheckedDisposable();
        Disposer.register(parentDisposable, disposable);
        CheckedDisposable checkedDisposable = disposable;
        if (checkedDisposable == null) {
            Disposer.$$$reportNull$$$0(8);
        }
        return checkedDisposable;
    }

    @Contract(pure=true, value="_,_->new")
    @NotNull
    public static CheckedDisposable newCheckedDisposable(@NotNull Disposable parentDisposable, @NotNull String debugName) {
        if (parentDisposable == null) {
            Disposer.$$$reportNull$$$0(9);
        }
        if (debugName == null) {
            Disposer.$$$reportNull$$$0(10);
        }
        CheckedDisposable disposable = Disposer.newCheckedDisposable(debugName);
        Disposer.register(parentDisposable, disposable);
        CheckedDisposable checkedDisposable = disposable;
        if (checkedDisposable == null) {
            Disposer.$$$reportNull$$$0(11);
        }
        return checkedDisposable;
    }

    public static void register(@NotNull Disposable parent, @NotNull Disposable child) throws IncorrectOperationException {
        if (parent == null) {
            Disposer.$$$reportNull$$$0(12);
        }
        if (child == null) {
            Disposer.$$$reportNull$$$0(13);
        }
        ourTree.register(parent, child);
    }

    public static boolean tryRegister(@NotNull Disposable parent, @NotNull Disposable child) {
        if (parent == null) {
            Disposer.$$$reportNull$$$0(14);
        }
        if (child == null) {
            Disposer.$$$reportNull$$$0(15);
        }
        return ourTree.tryRegister(parent, child);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static void register(@NotNull Disposable parent, @NotNull Disposable child, @NonNls @NotNull String key) {
        if (parent == null) {
            Disposer.$$$reportNull$$$0(16);
        }
        if (child == null) {
            Disposer.$$$reportNull$$$0(17);
        }
        if (key == null) {
            Disposer.$$$reportNull$$$0(18);
        }
        Disposer.register(parent, child);
        Disposable v = Disposer.get(key);
        if (v != null) {
            throw new IllegalArgumentException("Key " + key + " already registered: " + v);
        }
        ourKeyDisposables.put(key, child);
        Disposer.register(child, new KeyDisposable(key));
    }

    @Deprecated
    public static boolean isDisposed(@NotNull Disposable disposable) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(19);
        }
        return ourTree.isDisposed(disposable);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static Disposable get(@NotNull String key) {
        if (key == null) {
            Disposer.$$$reportNull$$$0(20);
        }
        String message = "this method is deprecated and going to be removed soon. Store and use your own Disposable instead";
        Logger.getInstance(Disposer.class).error(message);
        return ourKeyDisposables.get(key);
    }

    public static void dispose(@NotNull Disposable disposable) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(21);
        }
        Disposer.dispose(disposable, true);
    }

    @ApiStatus.Internal
    public static void disposeChildren(@NotNull Disposable disposable, @NotNull Predicate<? super Disposable> predicate) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(22);
        }
        if (predicate == null) {
            Disposer.$$$reportNull$$$0(23);
        }
        ourTree.executeAllChildren(disposable, predicate);
    }

    public static void dispose(@NotNull Disposable disposable, boolean processUnregistered) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(24);
        }
        ourTree.executeAll(disposable, processUnregistered);
    }

    @ApiStatus.Internal
    @VisibleForTesting
    @NotNull
    public static ObjectTree getTree() {
        ObjectTree objectTree = ourTree;
        if (objectTree == null) {
            Disposer.$$$reportNull$$$0(25);
        }
        return objectTree;
    }

    @ApiStatus.Internal
    public static void assertIsEmpty() {
        Disposer.assertIsEmpty(false);
    }

    @ApiStatus.Internal
    public static void assertIsEmpty(boolean throwError) {
        if (ourDebugMode) {
            ourTree.assertIsEmpty(throwError);
        }
    }

    public static boolean setDebugMode(boolean debugMode) {
        if (debugMode) {
            debugMode = !"off".equals(System.getProperty("idea.disposer.debug"));
        }
        boolean oldValue = ourDebugMode;
        ourDebugMode = debugMode;
        return oldValue;
    }

    public static boolean isDebugMode() {
        return ourDebugMode;
    }

    public static Throwable getDisposalTrace(@NotNull Disposable disposable) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(26);
        }
        return Disposer.getTree().getDisposalTrace(disposable);
    }

    @TestOnly
    @Nullable
    public static Throwable getRegistrationTrace(@NotNull Disposable disposable) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(27);
        }
        return Disposer.getTree().getRegistrationTrace(disposable);
    }

    @ApiStatus.Internal
    public static void clearDisposalTraces() {
        ourTree.clearDisposedObjectTraces();
    }

    static {
        ourKeyDisposables = ContainerUtil.createConcurrentWeakMap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 25: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/Disposer";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/Disposer";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "newDisposable";
                break;
            }
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "newCheckedDisposable";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newDisposable";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "newCheckedDisposable";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 25: {
                break;
            }
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tryRegister";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isDisposed";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 21: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "disposeChildren";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getDisposalTrace";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getRegistrationTrace";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 25: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static class CheckedDisposableImpl
    implements CheckedDisposable {
        volatile boolean isDisposed;

        CheckedDisposableImpl() {
        }

        @Override
        public boolean isDisposed() {
            return this.isDisposed;
        }

        @Override
        public void dispose() {
            this.isDisposed = true;
        }

        public String toString() {
            return "CheckedDisposableImpl{isDisposed=" + this.isDisposed + "} " + super.toString();
        }
    }

    private static final class NamedCheckedDisposable
    extends CheckedDisposableImpl {
        @NotNull
        private final String debugName;

        NamedCheckedDisposable(@NotNull String debugName) {
            if (debugName == null) {
                NamedCheckedDisposable.$$$reportNull$$$0(0);
            }
            this.debugName = debugName;
        }

        @Override
        public String toString() {
            return this.debugName + "{isDisposed=" + this.isDisposed + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/openapi/util/Disposer$NamedCheckedDisposable", "<init>"));
        }
    }

    private static final class KeyDisposable
    implements Disposable {
        @NotNull
        private final String myKey;

        KeyDisposable(@NotNull String key) {
            if (key == null) {
                KeyDisposable.$$$reportNull$$$0(0);
            }
            this.myKey = key;
        }

        @Override
        public void dispose() {
            ourKeyDisposables.remove(this.myKey);
        }

        public String toString() {
            return "KeyDisposable (" + this.myKey + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/Disposer$KeyDisposable", "<init>"));
        }
    }
}

