/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.diagnostic.ImplementationConflictException;
import com.intellij.lang.MetaLanguage;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtilRt;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import kotlinx.collections.immutable.PersistentMap;
import kotlinx.collections.immutable.PersistentSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class Language
extends UserDataHolderBase {
    public static final Language[] EMPTY_ARRAY = new Language[0];
    private static final Object staticLock = new Object();
    private static volatile PersistentMap<Class<? extends Language>, Language> registeredLanguages = ExtensionsKt.persistentHashMapOf();
    private static volatile PersistentMap<String, PersistentList<Language>> registeredMimeTypes = ExtensionsKt.persistentHashMapOf();
    private static volatile PersistentMap<String, Language> registeredIds = ExtensionsKt.persistentHashMapOf();
    private final Language myBaseLanguage;
    private final String myID;
    private final String[] myMimeTypes;
    private final Object instanceLock;
    private volatile PersistentList<Language> dialects;
    private volatile PersistentSet<@NotNull Language> transitiveDialects;
    public static final Language ANY = new Language(""){

        @Override
        public String toString() {
            return "Language: ANY";
        }

        @Override
        @Nullable
        public LanguageFileType getAssociatedFileType() {
            return null;
        }
    };

    protected Language(@NonNls @NotNull String ID2) {
        if (ID2 == null) {
            Language.$$$reportNull$$$0(0);
        }
        this(ID2, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    protected Language(@NonNls @NotNull String ID2, String ... mimeTypes) {
        if (ID2 == null) {
            Language.$$$reportNull$$$0(1);
        }
        if (mimeTypes == null) {
            Language.$$$reportNull$$$0(2);
        }
        this((Language)null, ID2, mimeTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Language(@Nullable Language baseLanguage, @NonNls @NotNull String ID2, String ... mimeTypes) {
        if (ID2 == null) {
            Language.$$$reportNull$$$0(3);
        }
        if (mimeTypes == null) {
            Language.$$$reportNull$$$0(4);
        }
        this.instanceLock = new Object();
        this.dialects = ExtensionsKt.persistentListOf();
        this.transitiveDialects = ExtensionsKt.persistentHashSetOf();
        if (baseLanguage instanceof MetaLanguage) {
            throw new ImplementationConflictException("MetaLanguage cannot be a base language.\nThis language: '" + ID2 + "'\nBase language: '" + baseLanguage.getID() + "'", null, this, baseLanguage);
        }
        this.myBaseLanguage = baseLanguage;
        this.myID = ID2;
        this.myMimeTypes = mimeTypes.length == 0 ? ArrayUtilRt.EMPTY_STRING_ARRAY : mimeTypes;
        Class<?> langClass = this.getClass();
        Object object = staticLock;
        synchronized (object) {
            Language existing = (Language)registeredLanguages.get(langClass);
            if (existing != null) {
                throw new ImplementationConflictException("Language of '" + langClass + "' is already registered: " + existing, null, existing, this);
            }
            existing = (Language)registeredIds.get(ID2);
            if (existing != null) {
                throw new ImplementationConflictException("Language with ID '" + ID2 + "' is already registered: " + existing.getClass(), null, existing, this);
            }
            registeredLanguages = registeredLanguages.put(langClass, this);
            registeredIds = registeredIds.put(ID2, this);
            for (String mimeType : mimeTypes) {
                if (Strings.isEmpty(mimeType)) continue;
                PersistentList list = (PersistentList)registeredMimeTypes.get(mimeType);
                registeredMimeTypes = registeredMimeTypes.put(mimeType, list == null ? ExtensionsKt.persistentListOf(this) : list.add(this));
            }
        }
        if (baseLanguage != null) {
            object = baseLanguage.instanceLock;
            synchronized (object) {
                baseLanguage.dialects = baseLanguage.dialects.add(this);
            }
            while (baseLanguage != null) {
                object = baseLanguage.instanceLock;
                synchronized (object) {
                    baseLanguage.transitiveDialects = baseLanguage.transitiveDialects.add(this);
                }
                baseLanguage = baseLanguage.getBaseLanguage();
            }
        }
    }

    public static @Unmodifiable @NotNull Collection<Language> getRegisteredLanguages() {
        Collection<Language> collection = registeredLanguages.values();
        if (collection == null) {
            Language.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @ApiStatus.Internal
    public static void unregisterAllLanguagesIn(@NotNull ClassLoader classLoader, @NotNull PluginDescriptor pluginDescriptor) {
        if (classLoader == null) {
            Language.$$$reportNull$$$0(6);
        }
        if (pluginDescriptor == null) {
            Language.$$$reportNull$$$0(7);
        }
        for (Map.Entry e : registeredLanguages.entrySet()) {
            Class clazz = (Class)e.getKey();
            Language language = (Language)e.getValue();
            if (clazz.getClassLoader() != classLoader) continue;
            language.unregisterLanguage(pluginDescriptor);
        }
        IElementType.unregisterElementTypes(classLoader, pluginDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void unregisterLanguage(@NotNull PluginDescriptor pluginDescriptor) {
        ReferenceProvidersRegistry referenceProvidersRegistry;
        if (pluginDescriptor == null) {
            Language.$$$reportNull$$$0(8);
        }
        IElementType.unregisterElementTypes(this, pluginDescriptor);
        Application application = ApplicationManager.getApplication();
        ReferenceProvidersRegistry referenceProvidersRegistry2 = referenceProvidersRegistry = application == null ? null : (ReferenceProvidersRegistry)application.getServiceIfCreated(ReferenceProvidersRegistry.class);
        if (referenceProvidersRegistry != null) {
            referenceProvidersRegistry.unloadProvidersFor(this);
        }
        Object object = staticLock;
        synchronized (object) {
            registeredLanguages = registeredLanguages.remove(this.getClass());
            registeredIds = registeredIds.remove(this.getID());
            for (String mimeType : this.getMimeTypes()) {
                registeredMimeTypes.remove(mimeType);
            }
        }
        Language baseLanguage = this.getBaseLanguage();
        if (baseLanguage != null) {
            baseLanguage.unregisterDialect(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void unregisterDialect(@NotNull Language language) {
        if (language == null) {
            Language.$$$reportNull$$$0(9);
        }
        Object object = this.instanceLock;
        synchronized (object) {
            this.dialects = this.dialects.remove(language);
        }
        for (Language baseLanguage = this; baseLanguage != null; baseLanguage = baseLanguage.getBaseLanguage()) {
            Object object2 = baseLanguage.instanceLock;
            synchronized (object2) {
                baseLanguage.transitiveDialects = baseLanguage.transitiveDialects.remove(language);
                continue;
            }
        }
    }

    public static <T extends Language> T findInstance(@NotNull Class<T> klass) {
        if (klass == null) {
            Language.$$$reportNull$$$0(10);
        }
        return (T)((Language)registeredLanguages.get(klass));
    }

    public static @Unmodifiable @NotNull Collection<Language> findInstancesByMimeType(@Nullable String mimeType) {
        List result2 = mimeType == null ? null : (List)registeredMimeTypes.get(mimeType);
        List list = result2 == null ? Collections.emptyList() : result2;
        if (list == null) {
            Language.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    public String toString() {
        return "Language: " + this.myID;
    }

    public String @NotNull [] getMimeTypes() {
        if (this.myMimeTypes == null) {
            Language.$$$reportNull$$$0(12);
        }
        return this.myMimeTypes;
    }

    @NotNull
    @NlsSafe
    public String getID() {
        String string2 = this.myID;
        if (string2 == null) {
            Language.$$$reportNull$$$0(13);
        }
        return string2;
    }

    @Nullable
    public LanguageFileType getAssociatedFileType() {
        return FileTypeRegistry.getInstance().findFileTypeByLanguage(this);
    }

    @ApiStatus.Internal
    @Nullable
    public LanguageFileType findMyFileType(FileType @NotNull [] types) {
        LanguageFileType languageFileType;
        if (types == null) {
            Language.$$$reportNull$$$0(14);
        }
        for (FileType fileType : types) {
            if (!(fileType instanceof LanguageFileType) || (languageFileType = (LanguageFileType)fileType).getLanguage() != this || languageFileType.isSecondary()) continue;
            return languageFileType;
        }
        for (FileType fileType : types) {
            if (!(fileType instanceof LanguageFileType) || !this.isKindOf((languageFileType = (LanguageFileType)fileType).getLanguage()) || languageFileType.isSecondary()) continue;
            return languageFileType;
        }
        return null;
    }

    @Nullable
    public Language getBaseLanguage() {
        return this.myBaseLanguage;
    }

    @NotNull
    @NlsSafe
    public String getDisplayName() {
        String string2 = this.getID();
        if (string2 == null) {
            Language.$$$reportNull$$$0(15);
        }
        return string2;
    }

    public final boolean is(Language another) {
        return this == another;
    }

    public boolean isCaseSensitive() {
        return this.myBaseLanguage != null && this.myBaseLanguage.isCaseSensitive();
    }

    @Contract(pure=true)
    public final boolean isKindOf(Language another) {
        for (Language l = this; l != null; l = l.getBaseLanguage()) {
            if (!l.is(another)) continue;
            return true;
        }
        return false;
    }

    public final boolean isKindOf(@NotNull @NonNls String anotherLanguageId) {
        if (anotherLanguageId == null) {
            Language.$$$reportNull$$$0(16);
        }
        for (Language l = this; l != null; l = l.getBaseLanguage()) {
            if (!l.getID().equals(anotherLanguageId)) continue;
            return true;
        }
        return false;
    }

    public @Unmodifiable @NotNull List<Language> getDialects() {
        PersistentList<Language> persistentList = this.dialects;
        if (persistentList == null) {
            Language.$$$reportNull$$$0(17);
        }
        return persistentList;
    }

    @Nullable
    public static Language findLanguageByID(@NonNls String id) {
        return id == null ? null : (Language)registeredIds.get(id);
    }

    protected Language(@NotNull String ID2, boolean register) {
        if (ID2 == null) {
            Language.$$$reportNull$$$0(18);
        }
        this.instanceLock = new Object();
        this.dialects = ExtensionsKt.persistentListOf();
        this.transitiveDialects = ExtensionsKt.persistentHashSetOf();
        Language language = Language.findLanguageByID(ID2);
        if (language != null) {
            throw new IllegalArgumentException("Language with ID=" + ID2 + " already registered: " + language + "; " + language.getClass());
        }
        this.myID = ID2;
        this.myBaseLanguage = null;
        this.myMimeTypes = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    protected void registerDialect(@NotNull Language dialect) {
        if (dialect == null) {
            Language.$$$reportNull$$$0(19);
        }
        Object object = this.instanceLock;
        synchronized (object) {
            this.dialects = this.dialects.add(dialect);
        }
        for (Language baseLanguage = this; baseLanguage != null; baseLanguage = baseLanguage.getBaseLanguage()) {
            Object object2 = baseLanguage.instanceLock;
            synchronized (object2) {
                baseLanguage.transitiveDialects = baseLanguage.transitiveDialects.add(dialect);
                continue;
            }
        }
    }

    @NotNull
    public @Unmodifiable @NotNull Collection<@NotNull Language> getTransitiveDialects() {
        PersistentSet<Language> persistentSet = this.transitiveDialects;
        if (persistentSet == null) {
            Language.$$$reportNull$$$0(20);
        }
        return persistentSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 20: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ID";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mimeTypes";
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/Language";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anotherLanguageId";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/Language";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredLanguages";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findInstancesByMimeType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMimeTypes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialects";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransitiveDialects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 20: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "unregisterAllLanguagesIn";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "unregisterLanguage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "unregisterDialect";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findInstance";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findMyFileType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isKindOf";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "registerDialect";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 20: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

