/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import java.io.File;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;

public class MavenProjectProblem
implements Serializable {
    private final boolean myRecoverable;
    private final String myPath;
    private final String myDescription;
    private final ProblemType myType;
    @Nullable
    private final MavenArtifact myMavenArtifact;

    public static MavenProjectProblem createStructureProblem(String path, String description, boolean recoverable) {
        return MavenProjectProblem.createProblem(path, description, ProblemType.STRUCTURE, recoverable);
    }

    public static MavenProjectProblem createStructureProblem(String path, String description) {
        return MavenProjectProblem.createProblem(path, description, ProblemType.STRUCTURE, false);
    }

    public static MavenProjectProblem createSyntaxProblem(String path, ProblemType type) {
        return MavenProjectProblem.createProblem(path, MessageFormat.format("''{0}'' has syntax errors", new File(path).getName()), type, false);
    }

    public static MavenProjectProblem createProblem(String path, String description, ProblemType type, boolean recoverable) {
        return new MavenProjectProblem(path, description, type, recoverable);
    }

    public static MavenProjectProblem createRepositoryProblem(String path, String description, boolean recoverable, MavenArtifact mavenArtifact) {
        return new MavenProjectProblem(path, description, ProblemType.REPOSITORY, recoverable, mavenArtifact);
    }

    public static MavenProjectProblem createUnresolvedArtifactProblem(String path, String description, boolean recoverable, MavenArtifact mavenArtifact) {
        return new MavenProjectProblem(path, description, ProblemType.DEPENDENCY, recoverable, mavenArtifact);
    }

    public static Collection<MavenProjectProblem> createProblemsList() {
        return MavenProjectProblem.createProblemsList(Collections.emptySet());
    }

    public static Collection<MavenProjectProblem> createProblemsList(Collection<? extends MavenProjectProblem> copyThis) {
        return new LinkedHashSet<MavenProjectProblem>(copyThis);
    }

    public MavenProjectProblem(String path, String description, ProblemType type, boolean recoverable) {
        this(path, description, type, recoverable, null);
    }

    public MavenProjectProblem(String path, String description, ProblemType type, boolean recoverable, MavenArtifact mavenArtifact) {
        this.myPath = path;
        this.myDescription = description;
        this.myType = type;
        this.myRecoverable = recoverable;
        this.myMavenArtifact = mavenArtifact;
    }

    public String getPath() {
        return this.myPath;
    }

    public boolean isRecoverable() {
        return this.myRecoverable;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    public ProblemType getType() {
        return this.myType;
    }

    @Nullable
    public MavenArtifact getMavenArtifact() {
        return this.myMavenArtifact;
    }

    public String toString() {
        return (Object)((Object)this.myType) + ":" + this.myDescription + ":" + this.myPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenProjectProblem that = (MavenProjectProblem)o;
        if (!Objects.equals(this.myDescription, that.myDescription)) {
            return false;
        }
        if (this.myType != that.myType) {
            return false;
        }
        return Objects.equals(this.myPath, that.myPath);
    }

    public int hashCode() {
        int result = this.myPath != null ? this.myPath.hashCode() : 0;
        result = 31 * result + (this.myDescription != null ? this.myDescription.hashCode() : 0);
        result = 31 * result + (this.myType != null ? this.myType.hashCode() : 0);
        return result;
    }

    public static enum ProblemType {
        SYNTAX,
        STRUCTURE,
        DEPENDENCY,
        PARENT,
        SETTINGS_OR_PROFILES,
        REPOSITORY;

    }
}

