/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main;

import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.main.CancellationManager;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.collectors.BytecodeSourceMapper;
import org.jetbrains.java.decompiler.main.collectors.CounterContainer;
import org.jetbrains.java.decompiler.main.collectors.ImportCollector;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.renamer.PoolInterceptor;
import org.jetbrains.java.decompiler.struct.StructContext;

public class DecompilerContext {
    public static final String CURRENT_CLASS = "CURRENT_CLASS";
    public static final String CURRENT_CLASS_WRAPPER = "CURRENT_CLASS_WRAPPER";
    public static final String CURRENT_CLASS_NODE = "CURRENT_CLASS_NODE";
    public static final String CURRENT_METHOD_WRAPPER = "CURRENT_METHOD_WRAPPER";
    @NotNull
    private final Map<String, Object> properties;
    @NotNull
    private final IFernflowerLogger logger;
    @NotNull
    private final StructContext structContext;
    @NotNull
    private final ClassesProcessor classProcessor;
    @Nullable
    private final PoolInterceptor poolInterceptor;
    @NotNull
    private final CancellationManager cancellationManager;
    private ImportCollector importCollector;
    private VarProcessor varProcessor;
    private CounterContainer counterContainer;
    private BytecodeSourceMapper bytecodeSourceMapper;
    private static final ThreadLocal<DecompilerContext> currentContext = new ThreadLocal();

    public DecompilerContext(@NotNull Map<String, Object> properties, @NotNull IFernflowerLogger logger, @NotNull StructContext structContext, @NotNull ClassesProcessor classProcessor, @Nullable PoolInterceptor interceptor) {
        if (properties == null) {
            DecompilerContext.$$$reportNull$$$0(0);
        }
        if (logger == null) {
            DecompilerContext.$$$reportNull$$$0(1);
        }
        if (structContext == null) {
            DecompilerContext.$$$reportNull$$$0(2);
        }
        if (classProcessor == null) {
            DecompilerContext.$$$reportNull$$$0(3);
        }
        this(properties, logger, structContext, classProcessor, interceptor, null);
    }

    public DecompilerContext(@NotNull Map<String, Object> properties, @NotNull IFernflowerLogger logger, @NotNull StructContext structContext, @NotNull ClassesProcessor classProcessor, @Nullable PoolInterceptor interceptor, @Nullable CancellationManager cancellationManager) {
        if (properties == null) {
            DecompilerContext.$$$reportNull$$$0(4);
        }
        if (logger == null) {
            DecompilerContext.$$$reportNull$$$0(5);
        }
        if (structContext == null) {
            DecompilerContext.$$$reportNull$$$0(6);
        }
        if (classProcessor == null) {
            DecompilerContext.$$$reportNull$$$0(7);
        }
        Objects.requireNonNull(properties);
        Objects.requireNonNull(logger);
        Objects.requireNonNull(structContext);
        Objects.requireNonNull(classProcessor);
        if (cancellationManager == null) {
            Object object = properties.get("mpm");
            object = object == null ? "0" : object;
            cancellationManager = CancellationManager.getSimpleWithTimeout(Integer.parseInt(object.toString()));
        }
        this.properties = properties;
        this.logger = logger;
        this.structContext = structContext;
        this.classProcessor = classProcessor;
        this.poolInterceptor = interceptor;
        this.counterContainer = new CounterContainer();
        this.cancellationManager = cancellationManager;
    }

    public static DecompilerContext getCurrentContext() {
        return currentContext.get();
    }

    public static void setCurrentContext(DecompilerContext context) {
        currentContext.set(context);
    }

    public static void setProperty(String key, Object value) {
        DecompilerContext.getCurrentContext().properties.put(key, value);
    }

    public static void startClass(ImportCollector importCollector) {
        DecompilerContext context = DecompilerContext.getCurrentContext();
        context.importCollector = importCollector;
        context.counterContainer = new CounterContainer();
        context.bytecodeSourceMapper = new BytecodeSourceMapper();
    }

    public static void startMethod(VarProcessor varProcessor) {
        DecompilerContext context = DecompilerContext.getCurrentContext();
        context.varProcessor = varProcessor;
        context.counterContainer = new CounterContainer();
    }

    public static Object getProperty(String key) {
        return DecompilerContext.getCurrentContext().properties.get(key);
    }

    public static boolean getOption(String key) {
        return "1".equals(DecompilerContext.getProperty(key));
    }

    public static String getNewLineSeparator() {
        return DecompilerContext.getOption("nls") ? "\n" : "\r\n";
    }

    public static IFernflowerLogger getLogger() {
        return DecompilerContext.getCurrentContext().logger;
    }

    public static StructContext getStructContext() {
        return DecompilerContext.getCurrentContext().structContext;
    }

    public static ClassesProcessor getClassProcessor() {
        return DecompilerContext.getCurrentContext().classProcessor;
    }

    public static CancellationManager getCancellationManager() {
        return DecompilerContext.getCurrentContext().cancellationManager;
    }

    public static PoolInterceptor getPoolInterceptor() {
        return DecompilerContext.getCurrentContext().poolInterceptor;
    }

    public static ImportCollector getImportCollector() {
        return DecompilerContext.getCurrentContext().importCollector;
    }

    public static VarProcessor getVarProcessor() {
        return DecompilerContext.getCurrentContext().varProcessor;
    }

    public static CounterContainer getCounterContainer() {
        return DecompilerContext.getCurrentContext().counterContainer;
    }

    public static BytecodeSourceMapper getBytecodeSourceMapper() {
        return DecompilerContext.getCurrentContext().bytecodeSourceMapper;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "properties";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "logger";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[0] = "structContext";
                break;
            }
            case 3: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[0] = "classProcessor";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/java/decompiler/main/DecompilerContext";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

