/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.code.cfg;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.code.SimpleInstructionSequence;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.IGraphNode;

public class BasicBlock
implements IGraphNode {
    public final int id;
    private final InstructionSequence seq;
    private final List<Integer> originalOffsets = new ArrayList<Integer>();
    private final List<BasicBlock> predecessors = new ArrayList<BasicBlock>();
    private final List<BasicBlock> successors = new ArrayList<BasicBlock>();
    private final List<BasicBlock> predecessorExceptions = new ArrayList<BasicBlock>();
    private final List<BasicBlock> successorExceptions = new ArrayList<BasicBlock>();
    public int mark = 0;

    public BasicBlock(int id) {
        this(id, new SimpleInstructionSequence());
    }

    public BasicBlock(int id, InstructionSequence seq) {
        this.id = id;
        this.seq = seq;
    }

    public BasicBlock clone(int newId) {
        BasicBlock block = new BasicBlock(newId, this.seq.clone());
        block.originalOffsets.addAll(this.originalOffsets);
        return block;
    }

    public Instruction getInstruction(int index) {
        return this.seq.getInstr(index);
    }

    public Instruction getLastInstruction() {
        return this.seq.isEmpty() ? null : this.seq.getLastInstr();
    }

    public Integer getOriginalOffset(int index) {
        return index < this.originalOffsets.size() ? this.originalOffsets.get(index) : Integer.valueOf(-1);
    }

    public int size() {
        return this.seq.length();
    }

    public void addPredecessor(BasicBlock block) {
        this.predecessors.add(block);
    }

    public void removePredecessor(BasicBlock block) {
        while (this.predecessors.remove(block)) {
        }
    }

    public void addSuccessor(BasicBlock block) {
        this.successors.add(block);
        block.addPredecessor(this);
    }

    public void removeSuccessor(BasicBlock block) {
        while (this.successors.remove(block)) {
        }
        block.removePredecessor(this);
    }

    public void replaceSuccessor(BasicBlock oldBlock, BasicBlock newBlock) {
        int i;
        for (i = 0; i < this.successors.size(); ++i) {
            if (this.successors.get((int)i).id != oldBlock.id) continue;
            this.successors.set(i, newBlock);
            oldBlock.removePredecessor(this);
            newBlock.addPredecessor(this);
        }
        for (i = 0; i < this.successorExceptions.size(); ++i) {
            if (this.successorExceptions.get((int)i).id != oldBlock.id) continue;
            this.successorExceptions.set(i, newBlock);
            oldBlock.removePredecessorException(this);
            newBlock.addPredecessorException(this);
        }
    }

    public void addPredecessorException(BasicBlock block) {
        this.predecessorExceptions.add(block);
    }

    public void removePredecessorException(BasicBlock block) {
        while (this.predecessorExceptions.remove(block)) {
        }
    }

    public void addSuccessorException(BasicBlock block) {
        if (!this.successorExceptions.contains(block)) {
            this.successorExceptions.add(block);
            block.addPredecessorException(this);
        }
    }

    public void removeSuccessorException(BasicBlock block) {
        while (this.successorExceptions.remove(block)) {
        }
        block.removePredecessorException(this);
    }

    public boolean isSuccessor(BasicBlock block) {
        return this.successors.stream().anyMatch(successor -> successor.id == block.id);
    }

    public List<Integer> getOriginalOffsets() {
        return this.originalOffsets;
    }

    public InstructionSequence getSeq() {
        return this.seq;
    }

    public List<BasicBlock> getPredecessors() {
        return this.predecessors;
    }

    public List<BasicBlock> getSuccessors() {
        return this.successors;
    }

    public List<BasicBlock> getPredecessorExceptions() {
        return this.predecessorExceptions;
    }

    public List<BasicBlock> getSuccessorExceptions() {
        return this.successorExceptions;
    }

    @Override
    public List<? extends IGraphNode> getPredecessorNodes() {
        ArrayList<BasicBlock> lst = new ArrayList<BasicBlock>(this.predecessors);
        lst.addAll(this.predecessorExceptions);
        return lst;
    }

    public String toString() {
        return this.id + ":" + DecompilerContext.getNewLineSeparator() + this.seq.toString(0);
    }
}

