/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.actions.scheme;

import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.devkit.actions.scheme.EventsTestSchemeGroupConfiguration;
import com.intellij.internal.statistic.eventLog.events.scheme.GroupDescriptor;
import com.intellij.internal.statistic.eventLog.validator.storage.GroupValidationTestRule;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.jetbrains.fus.reporting.model.metadata.EventGroupRemoteDescriptors;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0006\u0010\u001c\u001a\u00020\u001dJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\b\u0010\u001f\u001a\u00020\u001bH\u0002J\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0006R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0010\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00070\u00070\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/internal/statistic/devkit/actions/scheme/EditEventsTestSchemePanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "testSchemeGroups", "", "Lcom/intellij/internal/statistic/eventLog/validator/storage/GroupValidationTestRule;", "productionGroups", "Lcom/jetbrains/fus/reporting/model/metadata/EventGroupRemoteDescriptors;", "generatedScheme", "Lcom/intellij/internal/statistic/eventLog/events/scheme/GroupDescriptor;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/jetbrains/fus/reporting/model/metadata/EventGroupRemoteDescriptors;Ljava/util/List;)V", "CONTENT_KEY", "", "EMPTY_KEY", "cardLayout", "Ljava/awt/CardLayout;", "detailsComponent", "groupConfiguration", "Lcom/intellij/internal/statistic/devkit/actions/scheme/EventsTestSchemeGroupConfiguration;", "groupsList", "Lcom/intellij/ui/components/JBList;", "groupsModel", "Lcom/intellij/ui/CollectionListModel;", "kotlin.jvm.PlatformType", "dispose", "", "getFocusedComponent", "Ljavax/swing/JComponent;", "getGroups", "updateDetails", "validateGroups", "Lcom/intellij/openapi/ui/ValidationInfo;", "intellij.platform.statistics.devkit"})
public final class EditEventsTestSchemePanel
extends JPanel
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final CollectionListModel<GroupValidationTestRule> groupsModel;
    @NotNull
    private final JBList<GroupValidationTestRule> groupsList;
    @NotNull
    private EventsTestSchemeGroupConfiguration groupConfiguration;
    @NotNull
    private final CardLayout cardLayout;
    @NotNull
    private final JPanel detailsComponent;
    @NotNull
    private final String EMPTY_KEY;
    @NotNull
    private final String CONTENT_KEY;

    public EditEventsTestSchemePanel(@NotNull Project project, @NotNull List<GroupValidationTestRule> testSchemeGroups, @NotNull EventGroupRemoteDescriptors productionGroups, @NotNull List<GroupDescriptor> generatedScheme) {
        JBSplitter jBSplitter;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(testSchemeGroups, (String)"testSchemeGroups");
        Intrinsics.checkNotNullParameter((Object)productionGroups, (String)"productionGroups");
        Intrinsics.checkNotNullParameter(generatedScheme, (String)"generatedScheme");
        this.project = project;
        this.groupsModel = new CollectionListModel(testSchemeGroups);
        this.groupsList = new JBList((ListModel)this.groupsModel);
        this.cardLayout = new CardLayout();
        this.detailsComponent = new JPanel(this.cardLayout);
        this.EMPTY_KEY = "empty";
        this.CONTENT_KEY = "content";
        GroupValidationTestRule initialGroup = new GroupValidationTestRule("", true, null, 4, null);
        this.groupConfiguration = new EventsTestSchemeGroupConfiguration(this.project, productionGroups, initialGroup, generatedScheme, (Function1<? super GroupValidationTestRule, Unit>)((Function1)new Function1<GroupValidationTestRule, Unit>(){

            public final void invoke(@NotNull GroupValidationTestRule group) {
                Intrinsics.checkNotNullParameter((Object)group, (String)"group");
                groupsModel.contentsChanged((Object)group);
            }
        }));
        JPanel jPanel = ToolbarDecorator.createDecorator((JList)((JList)this.groupsList)).setToolbarPosition(ActionToolbarPosition.TOP).setPanelBorder((Border)JBUI.Borders.empty()).setAddAction(arg_0 -> EditEventsTestSchemePanel._init_$lambda$0(this, arg_0)).setRemoveAction(arg_0 -> EditEventsTestSchemePanel._init_$lambda$1(this, arg_0)).disableUpDownActions().setMinimumSize(new Dimension(200, 300)).createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        JPanel groupListPanel = jPanel;
        this.setPreferredSize((Dimension)JBUI.size((int)700, (int)500));
        this.setLayout(new BorderLayout());
        JLabel emptyLabel = new JLabel(StatisticsBundle.message((String)"stats.select.group.to.view.or.edit.details", (Object[])new Object[0]), 0);
        emptyLabel.setForeground(NamedColorUtil.getInactiveTextColor());
        JPanel emptyPanel = new JPanel(new BorderLayout());
        emptyPanel.add(emptyLabel);
        this.detailsComponent.add(this.EMPTY_KEY, emptyPanel);
        this.detailsComponent.add(this.CONTENT_KEY, this.groupConfiguration.getPanel());
        JBSplitter $this$_init__u24lambda_u242 = jBSplitter = new JBSplitter(false, 0.3f);
        boolean bl = false;
        $this$_init__u24lambda_u242.setSplitterProportionKey("EditTestScheme.splitter");
        $this$_init__u24lambda_u242.setFirstComponent((JComponent)groupListPanel);
        $this$_init__u24lambda_u242.setSecondComponent((JComponent)this.detailsComponent);
        JBSplitter splitter = jBSplitter;
        this.add((Component)splitter, "Center");
        this.groupsList.setCellRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", arg_0 -> EditEventsTestSchemePanel._init_$lambda$3((Function1)2.INSTANCE, arg_0)));
        this.groupsList.addListSelectionListener(arg_0 -> EditEventsTestSchemePanel._init_$lambda$4(this, arg_0));
        if (!this.groupsModel.isEmpty()) {
            this.groupsList.setSelectedIndex(0);
        }
    }

    private final void updateDetails() {
        int selectedIndex = this.groupsList.getSelectedIndex();
        if (selectedIndex != -1) {
            this.groupConfiguration.updatePanel((GroupValidationTestRule)this.groupsModel.getElementAt(selectedIndex));
            this.cardLayout.show(this.detailsComponent, this.CONTENT_KEY);
        } else {
            this.cardLayout.show(this.detailsComponent, this.EMPTY_KEY);
        }
    }

    @NotNull
    public final JComponent getFocusedComponent() {
        return this.groupConfiguration.getFocusedComponent();
    }

    @NotNull
    public final List<GroupValidationTestRule> getGroups() {
        List list = this.groupsModel.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        return list;
    }

    @NotNull
    public final List<ValidationInfo> validateGroups() {
        for (GroupValidationTestRule group : this.groupsModel.getItems()) {
            Intrinsics.checkNotNull((Object)group);
            List<ValidationInfo> validationInfo = EventsTestSchemeGroupConfiguration.Companion.validateTestSchemeGroup(this.project, group, (JComponent)this.groupConfiguration.getGroupIdTextField());
            if (!(!((Collection)validationInfo).isEmpty())) continue;
            this.groupsList.setSelectedIndex(this.groupsModel.getElementIndex((Object)group));
            return validationInfo;
        }
        return CollectionsKt.emptyList();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.groupConfiguration);
    }

    private static final void _init_$lambda$0(EditEventsTestSchemePanel this$0, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        GroupValidationTestRule newGroup = new GroupValidationTestRule("", true, null, 4, null);
        this$0.groupsModel.add((Object)newGroup);
        this$0.groupsList.setSelectedIndex(this$0.groupsModel.getElementIndex((Object)newGroup));
        this$0.groupConfiguration.getGroupIdTextField().grabFocus();
    }

    private static final void _init_$lambda$1(EditEventsTestSchemePanel this$0, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.groupsModel.remove(this$0.groupsList.getSelectedIndex());
        if (!this$0.groupsModel.isEmpty()) {
            this$0.groupsList.setSelectedIndex(this$0.groupsModel.getSize() - 1);
        }
    }

    private static final String _init_$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final void _init_$lambda$4(EditEventsTestSchemePanel this$0, ListSelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updateDetails();
    }
}

