/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.actions;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.devkit.actions.ConfigureEventsSchemeFileActionKt;
import com.intellij.internal.statistic.devkit.actions.EventsSchemeConfigurationModel;
import com.intellij.internal.statistic.eventLog.validator.IntellijSensitiveDataValidator;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventLogMetadataSettingsPersistence;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventsSchemePathSettings;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.ComponentsKt;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bH\u0016J\u001c\u0010\r\u001a\u00020\u00062\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/ConfigureEventsSchemeFileAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "myRecorderId", "", "(Ljava/lang/String;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "event", "updateSchemeSettings", "recorderToSettings", "", "Lcom/intellij/internal/statistic/devkit/actions/EventsSchemeConfigurationModel$EventsSchemePathSettings;", "intellij.platform.statistics.devkit"})
public final class ConfigureEventsSchemeFileAction
extends DumbAwareAction {
    @NotNull
    private String myRecorderId;

    public ConfigureEventsSchemeFileAction(@NotNull String myRecorderId) {
        Intrinsics.checkNotNullParameter((Object)myRecorderId, (String)"myRecorderId");
        super(ActionsBundle.message((String)"action.ConfigureEventsSchemeFileAction.text", (Object[])new Object[0]), ActionsBundle.message((String)"action.ConfigureEventsSchemeFileAction.description", (Object[])new Object[0]), null);
        this.myRecorderId = myRecorderId;
    }

    public /* synthetic */ ConfigureEventsSchemeFileAction(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "FUS";
        }
        this(string);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        EventsSchemeConfigurationModel configurationModel = new EventsSchemeConfigurationModel().reset(this.myRecorderId);
        DialogWrapper dialog2 = ComponentsKt.dialog$default((String)"Configure Custom Events Scheme", (JComponent)((JComponent)configurationModel.getPanel()), (boolean)true, null, (boolean)false, (Project)project, null, null, null, null, (Function0)((Function0)new Function0<List<? extends ValidationInfo>>(configurationModel){
            final /* synthetic */ EventsSchemeConfigurationModel $configurationModel;
            {
                this.$configurationModel = $configurationModel;
                super(0);
            }

            @Nullable
            public final List<ValidationInfo> invoke() {
                return CollectionsKt.listOfNotNull((Object)this.$configurationModel.validate());
            }
        }), (int)984, null);
        if (!dialog2.showAndGet()) {
            return;
        }
        String string = StatisticsBundle.message((String)"stats.saving.events.scheme.configuration", (Object[])new Object[0]);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, this, configurationModel, string){
            final /* synthetic */ ConfigureEventsSchemeFileAction this$0;
            final /* synthetic */ EventsSchemeConfigurationModel $configurationModel;
            {
                this.this$0 = $receiver;
                this.$configurationModel = $configurationModel;
                super($project, $super_call_param$1, false);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ConfigureEventsSchemeFileAction.access$updateSchemeSettings(this.this$0, this.$configurationModel.getRecorderToSettings());
            }
        });
    }

    private final void updateSchemeSettings(Map<String, EventsSchemeConfigurationModel.EventsSchemePathSettings> recorderToSettings) {
        EventLogMetadataSettingsPersistence settingsPersistence = EventLogMetadataSettingsPersistence.getInstance();
        for (Map.Entry<String, EventsSchemeConfigurationModel.EventsSchemePathSettings> entry : recorderToSettings.entrySet()) {
            IntellijSensitiveDataValidator validator;
            String recorder = entry.getKey();
            EventsSchemeConfigurationModel.EventsSchemePathSettings settings2 = entry.getValue();
            String customPath = settings2.getCustomPath();
            if (settings2.getUseCustomPath() && customPath != null) {
                settingsPersistence.setPathSettings(recorder, new EventsSchemePathSettings(customPath, true));
            } else {
                EventsSchemePathSettings oldSettings = settingsPersistence.getPathSettings(recorder);
                if (oldSettings != null && oldSettings.isUseCustomPath()) {
                    settingsPersistence.setPathSettings(recorder, new EventsSchemePathSettings(oldSettings.getCustomPath(), false));
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)IntellijSensitiveDataValidator.getInstance((String)recorder), (String)"getInstance(...)");
            validator.update();
            validator.reload();
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.update(event);
        Presentation presentation = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        presentation2.setEnabled(StatisticsRecorderUtil.isTestModeEnabled((String)this.myRecorderId));
        EventsSchemePathSettings settings2 = EventLogMetadataSettingsPersistence.getInstance().getPathSettings(this.myRecorderId);
        presentation2.setIcon(settings2 != null && settings2.isUseCustomPath() ? (Icon)ConfigureEventsSchemeFileActionKt.access$getCustomPathConfiguredIcon$p() : AllIcons.General.Settings);
    }

    public ConfigureEventsSchemeFileAction() {
        this(null, 1, null);
    }

    public static final /* synthetic */ void access$updateSchemeSettings(ConfigureEventsSchemeFileAction $this, Map recorderToSettings) {
        $this.updateSchemeSettings(recorderToSettings);
    }
}

