/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.icons.converters;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.ui.icons.CachedImageIconKt;
import com.intellij.ui.icons.IconReplacer;
import com.intellij.ui.icons.IconUtilKt;
import com.intellij.ui.icons.ImageDescriptor;
import com.intellij.ui.icons.ImageDescriptorKt;
import com.intellij.ui.icons.LazyImageIcon;
import com.intellij.ui.icons.ReplaceableIcon;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import com.intellij.ui.scale.UserScaleContext;
import com.intellij.util.containers.FixedHashMap;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.MultiResolutionImageProvider;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.ide.model.IconSource;
import com.jetbrains.rd.ui.icons.converters.ProtocolCachedImageIcon;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0000\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0002$%B/\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0013\u001a\u00020\u0000H\u0016J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bJ\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\bH\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\bH\u0016J\u0012\u0010\u001b\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0017H\u0014J\b\u0010\u001d\u001a\u00020\bH\u0002J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0006H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00060\u0012R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/rd/ui/icons/converters/ProtocolCachedImageIcon;", "Lcom/intellij/ui/icons/LazyImageIcon;", "Lcom/intellij/ui/icons/ReplaceableIcon;", "cachedIcon", "Lcom/intellij/ui/icons/CachedImageIcon;", "originalPath", "", "isDarkOverridden", "", "sources", "", "Lcom/jetbrains/rd/ide/model/IconSource;", "(Lcom/intellij/ui/icons/CachedImageIcon;Ljava/lang/String;Ljava/lang/Boolean;Ljava/util/List;)V", "Ljava/lang/Boolean;", "loadedIcon", "Ljavax/swing/Icon;", "realIconWasDark", "scaledIconCache", "Lcom/jetbrains/rd/ui/icons/converters/ProtocolCachedImageIcon$MyScaledIconsCache;", "copy", "createImage", "Ljava/awt/Image;", "ctx", "Lcom/intellij/ui/scale/ScaleContext;", "isDark", "getDarkIcon", "getMenuBarIcon", "getRealIcon", "context", "isDarkIcon", "replaceBy", "replacer", "Lcom/intellij/ui/icons/IconReplacer;", "scale", "", "toString", "Companion", "MyScaledIconsCache", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nProtocolCachedImageIcon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolCachedImageIcon.kt\ncom/jetbrains/rd/ui/icons/converters/ProtocolCachedImageIcon\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,204:1\n1#2:205\n*E\n"})
public final class ProtocolCachedImageIcon
extends LazyImageIcon
implements ReplaceableIcon {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final CachedImageIcon cachedIcon;
    @NotNull
    private final String originalPath;
    @Nullable
    private final Boolean isDarkOverridden;
    @NotNull
    private final List<IconSource> sources;
    @NotNull
    private final MyScaledIconsCache scaledIconCache;
    @Nullable
    private volatile Icon loadedIcon;
    private boolean realIconWasDark;
    private static final int SCALED_ICONS_CACHE_LIMIT = 5;
    @NotNull
    private static final Companion.RD_EMPTY_ICON.1 RD_EMPTY_ICON;

    public ProtocolCachedImageIcon(@Nullable CachedImageIcon cachedIcon, @NotNull String originalPath, @Nullable Boolean isDarkOverridden, @NotNull List<IconSource> sources) {
        Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        this.cachedIcon = cachedIcon;
        this.originalPath = originalPath;
        this.isDarkOverridden = isDarkOverridden;
        this.sources = sources;
        if (URLUtil.containsScheme((String)this.originalPath)) {
            ProtocolCachedImageIcon.Companion.getLOG().error("Icon should have only a relative path: " + this.originalPath + ". Fix the path on the backend.");
        }
        if (StringsKt.contains$default((CharSequence)this.originalPath, (CharSequence)"!/", (boolean)false, (int)2, null)) {
            ProtocolCachedImageIcon.Companion.getLOG().error("Icon path should not point inside a jar file: " + this.originalPath + ". Fix the path on the backend.");
        }
        this.scaledIconCache = new MyScaledIconsCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Icon getRealIcon(@Nullable ScaleContext context) {
        Object realIcon = this.realIcon;
        Object object = this.lock;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"lock");
        Object object2 = object;
        synchronized (object2) {
            ImageIcon icon2;
            boolean isDark;
            block7: {
                block6: {
                    Icon loadedRealIcon;
                    boolean bl = false;
                    CachedImageIcon cachedImageIcon = this.cachedIcon;
                    Icon icon3 = loadedRealIcon = cachedImageIcon != null ? cachedImageIcon.getRealIcon() : null;
                    if (loadedRealIcon != null && !Intrinsics.areEqual((Object)loadedRealIcon, (Object)CachedImageIconKt.getEMPTY_ICON())) {
                        this.loadedIcon = loadedRealIcon;
                    }
                    if (this.loadedIcon == null) break block6;
                    Icon icon4 = loadedRealIcon;
                    Intrinsics.checkNotNull((Object)icon4);
                    Icon icon5 = icon4;
                    return icon5;
                }
                isDark = this.isDarkIcon();
                if (this.updateScaleContext((UserScaleContext)context) || this.realIconWasDark != isDark || realIcon == null || (icon2 = LazyImageIcon.unwrapIcon((Object)realIcon)) == null) break block7;
                Icon icon6 = icon2;
                return icon6;
            }
            icon2 = this.scaledIconCache.getOrScaleIcon(1.0f);
            boolean smallEnough = icon2.getIconWidth() < 50 && icon2.getIconHeight() < 50;
            this.realIcon = smallEnough ? icon2 : new SoftReference<ImageIcon>(icon2);
            this.realIconWasDark = isDark;
            Icon icon7 = icon2;
            return icon7;
        }
    }

    @NotNull
    public Icon scale(float scale) {
        if (this.cachedIcon != null && this.loadedIcon != null) {
            return (Icon)this.cachedIcon.scale(scale);
        }
        if (scale == 1.0f) {
            return (Icon)((Object)this);
        }
        return this.scaledIconCache.getOrScaleIcon(scale);
    }

    private final boolean isDarkIcon() {
        Boolean bl = this.isDarkOverridden;
        return bl != null ? bl : UIUtil.isUnderDarcula();
    }

    @NotNull
    public Icon getDarkIcon(boolean isDark) {
        CachedImageIcon cachedImageIcon = this.cachedIcon;
        return (Icon)((Object)new ProtocolCachedImageIcon((CachedImageIcon)(cachedImageIcon != null ? cachedImageIcon.getDarkIcon(isDark) : null), this.originalPath, isDark, this.sources));
    }

    @Nullable
    public final Image createImage(@NotNull ScaleContext ctx, boolean isDark) {
        Object object;
        block13: {
            Object object2;
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            object = this;
            try {
                Image image;
                block12: {
                    String string;
                    String string2;
                    ProtocolCachedImageIcon $this$createImage_u24lambda_u242 = object;
                    boolean bl = false;
                    int lastDotIndex = StringsKt.lastIndexOf$default((CharSequence)$this$createImage_u24lambda_u242.originalPath, (char)'.', (int)0, (boolean)false, (int)6, null);
                    if (lastDotIndex == -1) {
                        string2 = $this$createImage_u24lambda_u242.originalPath;
                    } else {
                        String string3 = $this$createImage_u24lambda_u242.originalPath.substring(0, lastDotIndex);
                        string2 = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    }
                    String rawPathWithoutExt = string2;
                    if (lastDotIndex == -1) {
                        string = "svg";
                    } else {
                        String string4 = $this$createImage_u24lambda_u242.originalPath.substring(lastDotIndex + 1);
                        string = string4;
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    }
                    String ext2 = string;
                    List descriptors = ImageDescriptorKt.getImageDescriptors((String)$this$createImage_u24lambda_u242.originalPath, (boolean)isDark, (ScaleContext)ctx);
                    for (ImageDescriptor descriptor : descriptors) {
                        try {
                            IconSource source;
                            Object v4;
                            Object object3;
                            Object object4;
                            block11: {
                                object4 = $this$createImage_u24lambda_u242.sources;
                                object3 = object4.iterator();
                                while (object3.hasNext()) {
                                    Object t = object3.next();
                                    IconSource it = (IconSource)t;
                                    boolean bl2 = false;
                                    if (!Intrinsics.areEqual((Object)it.getPath(), (Object)descriptor.pathTransform.invoke((Object)rawPathWithoutExt, (Object)ext2))) continue;
                                    v4 = t;
                                    break block11;
                                }
                                v4 = null;
                            }
                            if ((IconSource)v4 == null) continue;
                            byte[] byArray = source.getBody();
                            if (byArray == null) continue;
                            byte[] body = byArray;
                            object4 = new ByteArrayInputStream(body);
                            object3 = source.getPath();
                            float f = descriptor.scale;
                            boolean bl3 = descriptor.isSvg;
                            boolean bl4 = descriptor.isDark;
                            Image image2 = IconUtilKt.loadImageFromStream((InputStream)((InputStream)object4), (String)object3, (float)f, (boolean)bl4, (boolean)bl3);
                            image = ImageUtil.ensureHiDPI((Image)image2, (ScaleContext)ctx);
                            break block12;
                        }
                        catch (IOException iOException) {
                        }
                    }
                    ProtocolCachedImageIcon.Companion.getLOG().warn("Unable to create an image for icon " + $this$createImage_u24lambda_u242.originalPath);
                    image = null;
                }
                object2 = Result.constructor-impl(image);
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block13;
            Object e = object2 = throwable;
            boolean bl = false;
            Object object5 = e;
            if (object5 instanceof ProcessCanceledException ? true : object5 instanceof CancellationException) {
                throw e;
            }
            ProtocolCachedImageIcon.Companion.getLOG().error("Path " + this.originalPath + ". Exception " + (Throwable)e);
        }
        return (Image)(Result.isFailure-impl((Object)object) ? null : object);
    }

    @NotNull
    public Icon getMenuBarIcon(boolean isDark) {
        Icon icon2;
        if (this.cachedIcon != null && this.loadedIcon != null) {
            return this.cachedIcon.getMenuBarIcon(isDark);
        }
        boolean useMRI = SystemInfo.isMac;
        ScaleContext ctx = useMRI ? ScaleContext.Companion.create() : ScaleContext.Companion.createIdentity();
        ctx.setScale(ScaleType.USR_SCALE.of(1.0f));
        Image img = this.createImage(ctx, isDark);
        if (img != null && useMRI) {
            img = MultiResolutionImageProvider.convertFromJBImage((Image)img);
        }
        Image image = img;
        if (image != null) {
            Image it = image;
            boolean bl = false;
            icon2 = new ImageIcon(it);
        } else {
            icon2 = (Icon)((Object)RD_EMPTY_ICON);
        }
        return icon2;
    }

    @NotNull
    public ProtocolCachedImageIcon copy() {
        return new ProtocolCachedImageIcon(this.cachedIcon, this.originalPath, this.isDarkOverridden, this.sources);
    }

    @NotNull
    public Icon replaceBy(@NotNull IconReplacer replacer) {
        Intrinsics.checkNotNullParameter((Object)replacer, (String)"replacer");
        if (this.cachedIcon == null || this.loadedIcon == null) {
            return (Icon)((Object)this);
        }
        Icon replacedIcon = replacer.replaceIcon((Icon)this.cachedIcon);
        if (replacedIcon instanceof CachedImageIcon) {
            return (Icon)((Object)new ProtocolCachedImageIcon((CachedImageIcon)replacedIcon, this.originalPath, this.isDarkOverridden, this.sources));
        }
        ProtocolCachedImageIcon.Companion.getLOG().warn("replaced icon is not a cached image icon, returning original one");
        return (Icon)((Object)this);
    }

    @NotNull
    public String toString() {
        if (this.cachedIcon != null && this.loadedIcon != null) {
            return "ProtocolCachedImageIcon(cachedIcon=" + this.cachedIcon + ")";
        }
        return super.toString();
    }

    static {
        BufferedImage bufferedImage = ImageUtil.createImage((int)1, (int)1, (int)5);
        RD_EMPTY_ICON = new JBImageIcon(bufferedImage){
            {
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super((Image)$super_call_param$1);
            }

            @NotNull
            public String toString() {
                return "Empty icon " + super.toString();
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000!\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000*\u0001\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rd/ui/icons/converters/ProtocolCachedImageIcon$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "RD_EMPTY_ICON", "com/jetbrains/rd/ui/icons/converters/ProtocolCachedImageIcon$Companion$RD_EMPTY_ICON$1", "Lcom/jetbrains/rd/ui/icons/converters/ProtocolCachedImageIcon$Companion$RD_EMPTY_ICON$1;", "SCALED_ICONS_CACHE_LIMIT", "", "intellij.rd.ui"})
    @SourceDebugExtension(value={"SMAP\nProtocolCachedImageIcon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolCachedImageIcon.kt\ncom/jetbrains/rd/ui/icons/converters/ProtocolCachedImageIcon$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,204:1\n10#2:205\n*S KotlinDebug\n*F\n+ 1 ProtocolCachedImageIcon.kt\ncom/jetbrains/rd/ui/icons/converters/ProtocolCachedImageIcon$Companion\n*L\n193#1:205\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLOG() {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ProtocolCachedImageIcon.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fRf\u0010\u0003\u001aZ\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\b \u0006*\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u0007 \u0006*,\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\b \u0006*\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u0007\u0018\u00010\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rd/ui/icons/converters/ProtocolCachedImageIcon$MyScaledIconsCache;", "", "(Lcom/jetbrains/rd/ui/icons/converters/ProtocolCachedImageIcon;)V", "scaledIconCache", "", "Lcom/intellij/ui/scale/ScaleContext;", "kotlin.jvm.PlatformType", "Ljava/lang/ref/SoftReference;", "Lcom/intellij/util/ui/JBImageIcon;", "", "scaledIconCacheWasDark", "", "getOrScaleIcon", "Ljavax/swing/ImageIcon;", "scale", "", "intellij.rd.ui"})
    @SourceDebugExtension(value={"SMAP\nProtocolCachedImageIcon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolCachedImageIcon.kt\ncom/jetbrains/rd/ui/icons/converters/ProtocolCachedImageIcon$MyScaledIconsCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,204:1\n1#2:205\n*E\n"})
    private final class MyScaledIconsCache {
        private boolean scaledIconCacheWasDark;
        private final Map<ScaleContext, SoftReference<JBImageIcon>> scaledIconCache = Collections.synchronizedMap((Map)new FixedHashMap(5));

        @NotNull
        public final ImageIcon getOrScaleIcon(float scale) {
            JBImageIcon jBImageIcon;
            JBImageIcon cachedIcon;
            boolean isDark = ProtocolCachedImageIcon.this.isDarkIcon();
            if (this.scaledIconCacheWasDark != isDark) {
                this.scaledIconCache.clear();
            }
            this.scaledIconCacheWasDark = isDark;
            UserScaleContext userScaleContext = ProtocolCachedImageIcon.this.getScaleContext();
            Intrinsics.checkNotNullExpressionValue((Object)userScaleContext, (String)"getScaleContext(...)");
            ScaleContext ctx = (ScaleContext)userScaleContext;
            if (!(scale == 1.0f)) {
                ctx = (ScaleContext)ctx.copy();
                ctx.setScale(ScaleType.OBJ_SCALE.of(scale));
            }
            SoftReference<JBImageIcon> softReference = this.scaledIconCache.get(ctx);
            Object object = cachedIcon = softReference != null ? softReference.get() : null;
            if (cachedIcon != null) {
                return (ImageIcon)cachedIcon;
            }
            Image image = ProtocolCachedImageIcon.this.createImage(ctx, isDark);
            if (image != null) {
                Image it = image;
                boolean bl = false;
                jBImageIcon = new JBImageIcon(it);
            } else {
                jBImageIcon = RD_EMPTY_ICON;
            }
            JBImageIcon icon2 = jBImageIcon;
            ctx = (ScaleContext)ctx.copy();
            this.scaledIconCache.put(ctx, new SoftReference<JBImageIcon>(icon2));
            return (ImageIcon)icon2;
        }
    }
}

