/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.ide.model.uiautomation.BeAbstractButton;
import com.jetbrains.ide.model.uiautomation.BeButton;
import com.jetbrains.ide.model.uiautomation.BeButtonAction;
import com.jetbrains.ide.model.uiautomation.BeButtonStyle;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.ide.model.uiautomation.BeEmptyAction;
import com.jetbrains.ide.model.uiautomation.BeRichText;
import com.jetbrains.ide.model.uiautomation.BeUserAction;
import com.jetbrains.rd.ui.ComponentActionWrapper;
import com.jetbrains.rd.ui.bindable.ViewBinder;
import com.jetbrains.rd.ui.bindable.ViewRegistryKt;
import com.jetbrains.rd.ui.bindable.views.listControl.IActionOwner;
import com.jetbrains.rd.ui.bindable.views.listControl.IRendererOwner;
import com.jetbrains.rd.ui.bindable.views.listControl.ITreeGridRenderer;
import com.jetbrains.rd.ui.bindable.views.listControl.renderers.BeButtonRenderer;
import com.jetbrains.rd.ui.bindable.views.utils.BeComponentsKt;
import com.jetbrains.rd.ui.bindable.views.utils.BeTextSettingsUtilKt;
import com.jetbrains.rd.ui.bindable.views.utils.ButtonsUtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u00032\b\u0012\u0004\u0012\u00020\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\b\u001a\u00020\u0002H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/ButtonViewControl;", "Lcom/jetbrains/rd/ui/bindable/ViewBinder;", "Lcom/jetbrains/ide/model/uiautomation/BeButton;", "Lcom/jetbrains/rd/ui/bindable/views/listControl/IRendererOwner;", "Lcom/jetbrains/rd/ui/bindable/views/listControl/IActionOwner;", "()V", "bind", "Ljavax/swing/JComponent;", "viewModel", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "createDefaultButton", "widthFromContent", "", "createIconButton", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "createNoBorderButton", "getAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getRenderer", "Lcom/jetbrains/rd/ui/bindable/views/listControl/ITreeGridRenderer;", "tryGetRealAction", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nButtonViewControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ButtonViewControl.kt\ncom/jetbrains/rd/ui/bindable/views/ButtonViewControl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1855#2,2:123\n*S KotlinDebug\n*F\n+ 1 ButtonViewControl.kt\ncom/jetbrains/rd/ui/bindable/views/ButtonViewControl\n*L\n114#1:123,2\n*E\n"})
public final class ButtonViewControl
implements ViewBinder<BeButton>,
IRendererOwner<BeButton>,
IActionOwner<BeButton> {
    @Override
    @NotNull
    public AnAction getAction(@NotNull Lifetime lifetime, @NotNull BeButton viewModel) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)viewModel), (String)"viewModel");
        AnAction anAction = this.tryGetRealAction(viewModel);
        if (anAction == null) {
            anAction = (AnAction)new ComponentActionWrapper((Function0<? extends JComponent>)((Function0)new Function0<JComponent>(this, viewModel, lifetime){
                final /* synthetic */ ButtonViewControl this$0;
                final /* synthetic */ BeButton $viewModel;
                final /* synthetic */ Lifetime $lifetime;
                {
                    this.this$0 = $receiver;
                    this.$viewModel = $viewModel;
                    this.$lifetime = $lifetime;
                    super(0);
                }

                @NotNull
                public final JComponent invoke() {
                    return this.this$0.bind(this.$viewModel, this.$lifetime);
                }
            }));
        }
        return anAction;
    }

    @Override
    @NotNull
    public ITreeGridRenderer<BeButton> getRenderer(@NotNull BeButton viewModel) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewModel), (String)"viewModel");
        return new BeButtonRenderer();
    }

    @Override
    @NotNull
    public JComponent bind(@NotNull BeButton viewModel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewModel), (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        switch (WhenMappings.$EnumSwitchMapping$0[viewModel.getStyle().ordinal()]) {
            case 1: 
            case 2: {
                return this.createDefaultButton(viewModel, lifetime, false);
            }
            case 3: {
                return this.createDefaultButton(viewModel, lifetime, true);
            }
            case 4: 
            case 5: 
            case 6: {
                return (JComponent)this.createIconButton(viewModel, lifetime);
            }
            case 7: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        JComponent jButton = this.createNoBorderButton(viewModel, lifetime);
        jButton.setRequestFocusEnabled(true);
        return jButton;
    }

    private final AnAction tryGetRealAction(BeButton viewModel) {
        if (viewModel.getStyle() == BeButtonStyle.NO_BORDER) {
            return null;
        }
        if (BeTextSettingsUtilKt.getShouldBeWrappedIntoHtml(viewModel.getContent())) {
            return null;
        }
        if (viewModel.getContent() instanceof BeRichText) {
            return null;
        }
        BeButtonAction beButtonAction = viewModel.getAction();
        if (beButtonAction instanceof BeEmptyAction) {
            return null;
        }
        if (beButtonAction instanceof BeUserAction) {
            DumbAwareAction action3 = new DumbAwareAction(beButtonAction, viewModel){
                final /* synthetic */ BeButtonAction $beButtonAction;
                final /* synthetic */ BeButton $viewModel;
                {
                    this.$beButtonAction = $beButtonAction;
                    this.$viewModel = $viewModel;
                }

                @NotNull
                public ActionUpdateThread getActionUpdateThread() {
                    return ActionUpdateThread.EDT;
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    InterfacesKt.fire(this.$beButtonAction.getClick());
                }

                public boolean displayTextInToolbar() {
                    return this.$viewModel.getStyle() != BeButtonStyle.ICON && this.$viewModel.getStyle() != BeButtonStyle.HYBRID && this.$viewModel.getStyle() != BeButtonStyle.HYBRID_TEXT_ONLY;
                }

                public void update(@NotNull AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ButtonsUtilKt.updateActionEvent(this.$viewModel, e);
                }
            };
            return (AnAction)action3;
        }
        return null;
    }

    private final ActionButton createIconButton(BeButton viewModel, Lifetime lifetime) {
        ActionButton actionButton;
        AnAction actionObject = this.getAction(lifetime, viewModel);
        ActionButton $this$createIconButton_u24lambda_u240 = actionButton = new ActionButton(actionObject, actionObject.getTemplatePresentation().clone(), "toolbar", (Dimension)JBUI.size((int)24));
        boolean bl = false;
        ButtonsUtilKt.prepareActionWithUpdate((BeAbstractButton)viewModel, lifetime, (Function0<Unit>)((Function0)new Function0<Unit>($this$createIconButton_u24lambda_u240){
            final /* synthetic */ ActionButton $this_apply;
            {
                this.$this_apply = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$this_apply.update();
            }
        }));
        return actionButton;
    }

    private final JComponent createDefaultButton(BeButton viewModel, Lifetime lifetime, boolean widthFromContent) {
        JButton jButton;
        JButton $this$createDefaultButton_u24lambda_u242 = jButton = new JButton();
        boolean bl = false;
        BeButtonAction action3 = viewModel.getAction();
        if (action3 instanceof BeUserAction) {
            $this$createDefaultButton_u24lambda_u242.addActionListener(arg_0 -> ButtonViewControl.createDefaultButton$lambda$2$lambda$1(action3, arg_0));
        }
        BeTextSettingsUtilKt.initFromText($this$createDefaultButton_u24lambda_u242, lifetime, viewModel.getContent(), widthFromContent);
        BeComponentsKt.bindDefaultProperties(viewModel, lifetime, $this$createDefaultButton_u24lambda_u242);
        return jButton;
    }

    private final JComponent createNoBorderButton(BeButton viewModel, Lifetime lifetime) {
        JComponent jComponent;
        JComponent $this$createNoBorderButton_u24lambda_u244 = jComponent = ViewRegistryKt.getView((BeControl)viewModel.getContent(), lifetime);
        boolean bl = false;
        $this$createNoBorderButton_u24lambda_u244.setCursor(Cursor.getPredefinedCursor(12));
        JBIterable jBIterable = UIUtil.uiTraverser((Component)$this$createNoBorderButton_u24lambda_u244).traverse();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"traverse(...)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Component it = (Component)element$iv;
            boolean bl2 = false;
            if (it instanceof JPanel || !(it instanceof JComponent)) continue;
            ButtonsUtilKt.addMouseListener(viewModel, (JComponent)it);
        }
        return jComponent;
    }

    private static final void createDefaultButton$lambda$2$lambda$1(BeButtonAction $action, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$action), (String)"$action");
        InterfacesKt.fire($action.getClick());
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BeButtonStyle.values().length];
            try {
                nArray[BeButtonStyle.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeButtonStyle.ICON_TEXT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeButtonStyle.TEXT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeButtonStyle.ICON.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeButtonStyle.HYBRID_TEXT_ONLY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeButtonStyle.HYBRID.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeButtonStyle.NO_BORDER.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

