/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;
import org.assertj.swing.cell.JTableCellWriter;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.driver.AbstractJTableCellWriter;
import org.assertj.swing.driver.JTableCheckBoxEditorCellWriter;
import org.assertj.swing.driver.JTableComboBoxEditorCellWriter;
import org.assertj.swing.driver.JTableTextComponentEditorCellWriter;

public class BasicJTableCellWriter
extends AbstractJTableCellWriter {
    private final JTableCheckBoxEditorCellWriter checkBoxWriter;
    private final JTableComboBoxEditorCellWriter comboBoxWriter;
    private final JTableTextComponentEditorCellWriter textComponentWriter;

    public BasicJTableCellWriter(@Nonnull Robot robot) {
        super(robot);
        this.checkBoxWriter = new JTableCheckBoxEditorCellWriter(robot);
        this.comboBoxWriter = new JTableComboBoxEditorCellWriter(robot);
        this.textComponentWriter = new JTableTextComponentEditorCellWriter(robot);
    }

    @Override
    public void enterValue(@Nonnull JTable table, int row2, int column, @Nonnull String value) {
        this.cellWriterFor(table, row2, column).enterValue(table, row2, column, value);
    }

    @Override
    public void startCellEditing(@Nonnull JTable table, int row2, int column) {
        this.cellWriterFor(table, row2, column).startCellEditing(table, row2, column);
    }

    @Override
    public void stopCellEditing(@Nonnull JTable table, int row2, int column) {
        this.cellWriterFor(table, row2, column).stopCellEditing(table, row2, column);
    }

    @Override
    public void cancelCellEditing(@Nonnull JTable table, int row2, int column) {
        this.cellWriterFor(table, row2, column).cancelCellEditing(table, row2, column);
    }

    @Nonnull
    private JTableCellWriter cellWriterFor(@Nonnull JTable table, int row2, int column) {
        Component editor = this.editorForCell(table, row2, column);
        if (editor instanceof JCheckBox) {
            return this.checkBoxWriter;
        }
        if (editor instanceof JComboBox) {
            return this.comboBoxWriter;
        }
        if (editor instanceof JTextComponent) {
            return this.textComponentWriter;
        }
        throw BasicJTableCellWriter.cannotFindOrActivateEditor(row2, column);
    }
}

