/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.indentGuides;

import com.intellij.codeInsight.daemon.impl.IndentGuideRenderer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.rdclient.daemon.highlighters.indentGuides.FrontendIndentGuideClipBoundProvider;
import com.jetbrains.rdclient.daemon.highlighters.indentGuides.FrontendIndentGuideGraphicsClipBoundProvider;
import com.jetbrains.rdclient.daemon.highlighters.indentGuides.FrontendIndentGuideHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.indentGuides.FrontendIndentGuideRenderResultCollector;
import com.jetbrains.rdclient.document.DocumentExKt;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J(\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0014J \u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u0014\u0010\u001c\u001a\u00020\b*\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\bH\u0002J\f\u0010\u001e\u001a\u00020\u0004*\u00020\u001fH\u0002\u00a8\u0006 "}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/indentGuides/FrontendIndentGuideRenderer;", "Lcom/intellij/codeInsight/daemon/impl/IndentGuideRenderer;", "()V", "allCharactersAreWhiteSpace", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "startOffset", "", "endOffset", "doPaint", "", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "clipBoundProvider", "Lcom/jetbrains/rdclient/daemon/highlighters/indentGuides/FrontendIndentGuideClipBoundProvider;", "resultCollector", "Lcom/jetbrains/rdclient/daemon/highlighters/indentGuides/FrontendIndentGuideRenderResultCollector;", "doPaintInTest", "isSelected", "off", "indentColumn", "paint", "g", "Ljava/awt/Graphics;", "shouldRenderIndentGuide", "line", "logicalIndentLevel", "getLineLength", "Lcom/intellij/openapi/editor/Document;", "isWhiteSpaceToken", "Lcom/intellij/psi/tree/IElementType;", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendIndentGuideRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendIndentGuideRenderer.kt\ncom/jetbrains/rdclient/daemon/highlighters/indentGuides/FrontendIndentGuideRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n1549#2:120\n1620#2,3:121\n1726#2,3:124\n*S KotlinDebug\n*F\n+ 1 FrontendIndentGuideRenderer.kt\ncom/jetbrains/rdclient/daemon/highlighters/indentGuides/FrontendIndentGuideRenderer\n*L\n109#1:120\n109#1:121,3\n109#1:124,3\n*E\n"})
public final class FrontendIndentGuideRenderer
extends IndentGuideRenderer {
    protected boolean isSelected(@NotNull Editor editor2, int endOffset, int off, int indentColumn) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return IndentGuideRenderer.isCaretOnGuide((Editor)editor2, (int)endOffset, (int)off, (int)indentColumn);
    }

    public void paint(@NotNull Editor editor2, @NotNull RangeHighlighter highlighter2, @NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (!editor2.getSettings().isIndentGuidesShown()) {
            return;
        }
        if (FrontendIndentGuideHighlighterModelHandler.Companion.getIndentLevel(highlighter2) == null) {
            super.paint(editor2, highlighter2, g);
            return;
        }
        FrontendIndentGuideRenderResultCollector collector = (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> FrontendIndentGuideRenderer.paint$lambda$0(this, g, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5);
        this.doPaint(editor2, highlighter2, new FrontendIndentGuideGraphicsClipBoundProvider(g), collector);
    }

    private final void doPaint(Editor editor2, RangeHighlighter highlighter2, FrontendIndentGuideClipBoundProvider clipBoundProvider, FrontendIndentGuideRenderResultCollector resultCollector) {
        Integer n = FrontendIndentGuideHighlighterModelHandler.Companion.getIndentLevel(highlighter2);
        Intrinsics.checkNotNull((Object)n);
        int indentLevel = n;
        int startOffset = highlighter2.getStartOffset();
        Document document = highlighter2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document doc = document;
        if (startOffset >= doc.getTextLength()) {
            return;
        }
        int endOffset = highlighter2.getEndOffset();
        int startLine = doc.getLineNumber(startOffset);
        int endLine = doc.getLineNumber(endOffset);
        int off = editor2.logicalPositionToOffset(new LogicalPosition(startLine, 0)) + indentLevel;
        int visualIndentLevel = editor2.offsetToVisualPosition((int)off).column;
        int logicalIndentLevel = editor2.offsetToLogicalPosition((int)off).column;
        int startLogicalOffset = clipBoundProvider.getStartLogicalOffset(editor2);
        int endLogicalOffset = clipBoundProvider.getEndLogicalOffset(editor2);
        startLine = RangesKt.coerceAtLeast((int)startLine, (int)startLogicalOffset);
        endLine = RangesKt.coerceAtMost((int)endLine, (int)endLogicalOffset);
        Integer currentPartStartLine = startLine;
        int n2 = endLine;
        for (int currentLine = startLine; currentLine < n2; ++currentLine) {
            if (this.shouldRenderIndentGuide(editor2, currentLine, logicalIndentLevel)) {
                Integer n3 = currentPartStartLine;
                if (n3 == null) {
                    n3 = currentLine - 1;
                }
                currentPartStartLine = n3;
                continue;
            }
            if (currentPartStartLine == null) continue;
            FrontendIndentGuideRenderer.doPaint$paint(editor2, indentLevel, visualIndentLevel, resultCollector, off, endOffset, doc, currentPartStartLine, currentLine);
            currentPartStartLine = null;
        }
        if (currentPartStartLine == null) {
            return;
        }
        FrontendIndentGuideRenderer.doPaint$paint(editor2, indentLevel, visualIndentLevel, resultCollector, off, endOffset, doc, currentPartStartLine, endLine);
    }

    private final int getLineLength(Document $this$getLineLength, int line) {
        return $this$getLineLength.getLineEndOffset(line) - $this$getLineLength.getLineStartOffset(line);
    }

    private final boolean shouldRenderIndentGuide(Editor editor2, int line, int logicalIndentLevel) {
        int currentLineStartOffset = editor2.getDocument().getLineStartOffset(line);
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        int lineLength = this.getLineLength(document, line);
        LogicalPosition logicalPosition = editor2.offsetToLogicalPosition(editor2.getDocument().getLineEndOffset(line));
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"offsetToLogicalPosition(...)");
        LogicalPosition logicalLineEndCoords = logicalPosition;
        if (logicalLineEndCoords.column < logicalIndentLevel) {
            return true;
        }
        int indentGuideOffset = editor2.logicalPositionToOffset(new LogicalPosition(logicalLineEndCoords.line, logicalIndentLevel));
        if (editor2.getFoldingModel().isOffsetCollapsed(indentGuideOffset)) {
            return true;
        }
        IElementType tokenType = editor2.getHighlighter().createIterator(indentGuideOffset).getTokenType();
        Intrinsics.checkNotNull((Object)tokenType);
        if (this.isWhiteSpaceToken(tokenType)) {
            return true;
        }
        int lineEndOffset = currentLineStartOffset + lineLength;
        return this.allCharactersAreWhiteSpace(editor2, currentLineStartOffset, indentGuideOffset) || this.allCharactersAreWhiteSpace(editor2, indentGuideOffset, lineEndOffset);
    }

    private final boolean isWhiteSpaceToken(IElementType $this$isWhiteSpaceToken) {
        return Intrinsics.areEqual((Object)$this$isWhiteSpaceToken, (Object)TokenType.WHITE_SPACE) || Intrinsics.areEqual((Object)$this$isWhiteSpaceToken.getDebugName(), (Object)"NEW_LINE");
    }

    /*
     * WARNING - void declaration
     */
    private final boolean allCharactersAreWhiteSpace(Editor editor2, int startOffset, int endOffset) {
        boolean bl;
        block4: {
            void $this$all$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = (Iterable)new IntRange(startOffset, endOffset);
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            boolean $i$f$map = false;
            void var7_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void p0;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(DocumentExKt.getCharAt(document2, (int)p0));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Character it = (Character)element$iv;
                    boolean bl3 = false;
                    Character c = it;
                    if (c != null ? CharsKt.isWhitespace((char)c.charValue()) : true) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    @TestOnly
    public final void doPaintInTest(@NotNull Editor editor2, @NotNull RangeHighlighter highlighter2, @NotNull FrontendIndentGuideClipBoundProvider clipBoundProvider, @NotNull FrontendIndentGuideRenderResultCollector resultCollector) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)clipBoundProvider, (String)"clipBoundProvider");
        Intrinsics.checkNotNullParameter((Object)resultCollector, (String)"resultCollector");
        this.doPaint(editor2, highlighter2, clipBoundProvider, resultCollector);
    }

    private static final void paint$lambda$0(FrontendIndentGuideRenderer this$0, Graphics $g, Editor editorParam, VisualPosition currentPartStartVisualPosition, VisualPosition currentPartEndVisualPosition, int off, int endOffset, Document doc) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$g, (String)"$g");
        Intrinsics.checkNotNullParameter((Object)editorParam, (String)"editorParam");
        Intrinsics.checkNotNullParameter((Object)currentPartStartVisualPosition, (String)"currentPartStartVisualPosition");
        Intrinsics.checkNotNullParameter((Object)currentPartEndVisualPosition, (String)"currentPartEndVisualPosition");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        this$0.paint(editorParam, currentPartStartVisualPosition, currentPartEndVisualPosition, off, endOffset, doc, $g);
    }

    private static final void doPaint$paint(Editor $editor, int indentLevel, int visualIndentLevel, FrontendIndentGuideRenderResultCollector $resultCollector, int off, int endOffset, Document doc, int startLine, int endLine) {
        int currentPartStartOffset = $editor.logicalPositionToOffset(new LogicalPosition(startLine, 0)) + indentLevel;
        VisualPosition currentPartStartVisualPosition = new VisualPosition($editor.offsetToVisualPosition((int)currentPartStartOffset).line, visualIndentLevel);
        int currentPartEndOffset = $editor.logicalPositionToOffset(new LogicalPosition(endLine, 0)) + indentLevel;
        VisualPosition currentPartEndVisualPosition = new VisualPosition($editor.offsetToVisualPosition((int)currentPartEndOffset).line, visualIndentLevel);
        $resultCollector.collect($editor, currentPartStartVisualPosition, currentPartEndVisualPosition, off, endOffset, doc);
    }
}

