/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.actions.base;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.rdclient.actions.base.BackendActionDelegationKt;
import com.jetbrains.rdclient.actions.base.BackendDelegatingActionCustomization;
import com.jetbrains.rdclient.actions.base.BackendDelegatingActionKt;
import com.jetbrains.rdclient.actions.base.FrontendActionUpdateTrait;
import com.jetbrains.rdclient.actions.base.FrontendEditorActionUpdateTrait;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00182\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0018B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0007J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J$\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J \u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0004R\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rdclient/actions/base/FrontendEditorActionHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "Lcom/jetbrains/rdclient/actions/base/FrontendEditorActionUpdateTrait;", "Lcom/jetbrains/rdclient/actions/base/FrontendActionUpdateTrait;", "frontendId", "", "baseHandler", "(Ljava/lang/String;Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "getBaseHandler", "()Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "getFrontendId", "()Ljava/lang/String;", "backendIsEnabledForCaret", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "doExecute", "", "executeOnFrontend", "isEnabledForCaret", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendEditorActionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendEditorActionHandler.kt\ncom/jetbrains/rdclient/actions/base/FrontendEditorActionHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,74:1\n1#2:75\n10#3:76\n*S KotlinDebug\n*F\n+ 1 FrontendEditorActionHandler.kt\ncom/jetbrains/rdclient/actions/base/FrontendEditorActionHandler\n*L\n42#1:76\n*E\n"})
public class FrontendEditorActionHandler
extends EditorActionHandler
implements FrontendEditorActionUpdateTrait,
FrontendActionUpdateTrait {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String frontendId;
    @NotNull
    private final EditorActionHandler baseHandler;
    @NotNull
    private static final Logger logger;

    public FrontendEditorActionHandler(@NotNull String frontendId, @NotNull EditorActionHandler baseHandler) {
        Intrinsics.checkNotNullParameter((Object)frontendId, (String)"frontendId");
        Intrinsics.checkNotNullParameter((Object)baseHandler, (String)"baseHandler");
        this.frontendId = frontendId;
        this.baseHandler = baseHandler;
    }

    @NotNull
    public final String getFrontendId() {
        return this.frontendId;
    }

    @NotNull
    public final EditorActionHandler getBaseHandler() {
        return this.baseHandler;
    }

    protected final boolean isEnabledForCaret(@NotNull Editor editor2, @NotNull Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        boolean res = this.backendIsEnabledForCaret(editor2, caret, dataContext);
        return res || this.baseHandler.isEnabled(editor2, caret, dataContext);
    }

    protected void doExecute(@NotNull Editor editor2, @Nullable Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        boolean ret = this.backendIsEnabledForCaret(editor2, caret, dataContext);
        if (ret) {
            logger.debug("Executing backend editor handler '" + this.frontendId + "'");
            BackendActionDelegationKt.backendActionPerformed(this.frontendId, dataContext, "unknown");
        } else {
            logger.debug("Executing frontend editor base handler '" + this.frontendId + "'");
            this.executeOnFrontend(editor2, caret, dataContext);
        }
    }

    protected void executeOnFrontend(@NotNull Editor editor2, @Nullable Caret caret, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.baseHandler.execute(editor2, caret, dataContext);
    }

    @Override
    public boolean backendIsEnabledForCaret(@NotNull Editor editor2, @Nullable Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!Registry.is((String)"rdclient.backend.actionHandlers")) {
            return false;
        }
        if (!FrontendEditorActionUpdateTrait.super.backendIsEnabledForCaret(editor2, caret, dataContext)) {
            return false;
        }
        BackendDelegatingActionCustomization backendDelegatingActionCustomization = BackendDelegatingActionKt.findCustomization(dataContext, this.frontendId);
        if (backendDelegatingActionCustomization != null) {
            BackendDelegatingActionCustomization it = backendDelegatingActionCustomization;
            boolean bl = false;
            return FrontendActionUpdateTrait.frontendUpdate$default(it, this.frontendId, dataContext, null, "unknown", null, 16, null);
        }
        return FrontendActionUpdateTrait.super.frontendUpdate(this.frontendId, dataContext, null, "unknown", null);
    }

    @NotNull
    protected static final Logger getLogger() {
        return Companion.getLogger();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendEditorActionHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendEditorActionHandler.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdclient/actions/base/FrontendEditorActionHandler$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Logger getLogger() {
            return logger;
        }

        @JvmStatic
        protected static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

