/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.codeInspection.htmlInspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.htmltools.HtmlToolsBundle;
import com.intellij.htmltools.codeInspection.htmlInspections.CreateRequiredSubElement;
import com.intellij.htmltools.codeInspection.htmlInspections.InspectionUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlCustomElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class HtmlRequiredTitleElementInspection
extends HtmlLocalInspectionTool {
    private static final String TITLE = "title";
    private static final String HEAD = "head";

    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            HtmlRequiredTitleElementInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            HtmlRequiredTitleElementInspection.$$$reportNull$$$0(1);
        }
        if (!HtmlUtil.isHtmlTagContainingFile((PsiElement)tag)) {
            return;
        }
        if (!tag.getName().equalsIgnoreCase(HEAD)) {
            return;
        }
        if (XmlCustomElementDescriptor.isCustomElement((XmlTag)tag)) {
            return;
        }
        XmlTag[] subTags = tag.getSubTags();
        long count = Arrays.stream(subTags).filter(element -> element.getName().equalsIgnoreCase(TITLE)).count();
        if (count > 0L) {
            return;
        }
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        fixes.add((LocalQuickFix)new CreateRequiredSubElement(tag.getOriginalElement(), TITLE));
        InspectionUtils.RegisterProblem(tag, holder, fixes, HtmlToolsBundle.message("html.inspections.check.required.title.element", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    @NotNull
    public String getShortName() {
        return "HtmlRequiredTitleElement";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "tag";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/htmltools/codeInspection/htmlInspections/HtmlRequiredTitleElementInspection";
        objectArray[2] = "checkTag";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

