/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInspection.groovy;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.InheritanceUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInspection.fix.FixUtilKt;
import org.jetbrains.plugins.gradle.codeInspection.groovy.GroovyConfigurationAvoidanceVisitorKt;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCallReference;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/gradle/codeInspection/groovy/GroovyConfigurationAvoidanceVisitor;", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "processMethod", "", "method", "Lcom/intellij/psi/PsiMethod;", "elementToHighlight", "Lcom/intellij/psi/PsiElement;", "isReturnTypeValueUsed", "", "visitIndexProperty", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrIndexProperty;", "visitMethodCall", "call", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;", "intellij.gradle.java"})
@SourceDebugExtension(value={"SMAP\nGroovyConfigurationAvoidanceVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroovyConfigurationAvoidanceVisitor.kt\norg/jetbrains/plugins/gradle/codeInspection/groovy/GroovyConfigurationAvoidanceVisitor\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,106:1\n14#2:107\n*S KotlinDebug\n*F\n+ 1 GroovyConfigurationAvoidanceVisitor.kt\norg/jetbrains/plugins/gradle/codeInspection/groovy/GroovyConfigurationAvoidanceVisitor\n*L\n35#1:107\n*E\n"})
public final class GroovyConfigurationAvoidanceVisitor
extends GroovyElementVisitor {
    @NotNull
    private final ProblemsHolder holder;

    public GroovyConfigurationAvoidanceVisitor(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    @NotNull
    public final ProblemsHolder getHolder() {
        return this.holder;
    }

    public void visitMethodCall(@NotNull GrMethodCall call) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        if (!GroovyConfigurationAvoidanceVisitorKt.access$lazyApiAvailable((PsiElement)call)) {
            return;
        }
        PsiMethod psiMethod = call.resolveMethod();
        if (psiMethod == null) {
            return;
        }
        PsiMethod method = psiMethod;
        GrExpression grExpression = call.getInvokedExpression();
        Intrinsics.checkNotNullExpressionValue((Object)grExpression, (String)"getInvokedExpression(...)");
        GrExpression callExpression = grExpression;
        if (callExpression instanceof GrReferenceExpression) {
            psiElement = ((GrReferenceExpression)callExpression).getReferenceNameElement();
            if (psiElement == null) {
                psiElement = (PsiElement)callExpression;
            }
        } else {
            psiElement = (PsiElement)callExpression;
        }
        PsiElement elementToHighlight = psiElement;
        this.processMethod(method, elementToHighlight, this.holder, FixUtilKt.isReturnTypeValueUsed((PsiElement)call));
    }

    public void visitIndexProperty(@NotNull GrIndexProperty expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (!GroovyConfigurationAvoidanceVisitorKt.access$lazyApiAvailable((PsiElement)expression)) {
            return;
        }
        GroovyMethodCallReference groovyMethodCallReference = expression.getRValueReference();
        PsiElement $this$asSafely$iv = groovyMethodCallReference != null ? groovyMethodCallReference.resolve() : null;
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof PsiMethod)) {
            psiElement = null;
        }
        PsiMethod psiMethod = (PsiMethod)psiElement;
        if (psiMethod == null) {
            return;
        }
        PsiMethod method = psiMethod;
        GrArgumentList grArgumentList = expression.getArgumentList();
        Intrinsics.checkNotNullExpressionValue((Object)grArgumentList, (String)"getArgumentList(...)");
        GrArgumentList elementToHighlight = grArgumentList;
        this.processMethod(method, (PsiElement)elementToHighlight, this.holder, FixUtilKt.isReturnTypeValueUsed((PsiElement)expression));
    }

    private final void processMethod(PsiMethod method, PsiElement elementToHighlight, ProblemsHolder holder, boolean isReturnTypeValueUsed) {
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiClass containingClass = psiClass;
        if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.gradle.api.tasks.TaskContainer")) {
            GroovyConfigurationAvoidanceVisitorKt.access$processTaskContainer(method, elementToHighlight, holder, isReturnTypeValueUsed);
        }
        if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.gradle.api.DomainObjectCollection")) {
            GroovyConfigurationAvoidanceVisitorKt.access$processDomainObjectCollection(method, elementToHighlight, holder);
        }
        if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.gradle.api.Project")) {
            GroovyConfigurationAvoidanceVisitorKt.access$processProject(method, elementToHighlight, holder, isReturnTypeValueUsed);
        }
        if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.gradle.api.NamedDomainObjectCollection")) {
            GroovyConfigurationAvoidanceVisitorKt.access$processNamedDomainObjectCollection(method, elementToHighlight, holder);
        }
        if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.gradle.api.tasks.TaskCollection")) {
            GroovyConfigurationAvoidanceVisitorKt.access$processTaskCollection(method, elementToHighlight, holder);
        }
    }
}

