/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.junit5.impl;

import com.intellij.openapi.vfs.newvfs.persistent.VFSHealthChecker;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00132\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001\u0013B/\b\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u0010\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u0011\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/testFramework/junit5/impl/CheckVFSHealthExtension;", "Lorg/junit/jupiter/api/extension/BeforeAllCallback;", "Lorg/junit/jupiter/api/extension/AfterAllCallback;", "Lorg/junit/jupiter/api/extension/BeforeEachCallback;", "Lorg/junit/jupiter/api/extension/AfterEachCallback;", "checkBeforeEach", "", "checkAfterEach", "checkBeforeAll", "checkAfterAll", "(ZZZZ)V", "afterAll", "", "context", "Lorg/junit/jupiter/api/extension/ExtensionContext;", "afterEach", "beforeAll", "beforeEach", "checkVFS", "Companion", "intellij.platform.testFramework.junit5"})
@TestOnly
public final class CheckVFSHealthExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean checkBeforeEach;
    private final boolean checkAfterEach;
    private final boolean checkBeforeAll;
    private final boolean checkAfterAll;

    private CheckVFSHealthExtension(boolean checkBeforeEach, boolean checkAfterEach, boolean checkBeforeAll, boolean checkAfterAll) {
        this.checkBeforeEach = checkBeforeEach;
        this.checkAfterEach = checkAfterEach;
        this.checkBeforeAll = checkBeforeAll;
        this.checkAfterAll = checkAfterAll;
        if (!(this.checkBeforeAll || this.checkBeforeEach || this.checkAfterAll || this.checkAfterEach)) {
            throw new IllegalArgumentException("All check[Before|After][All|Each] flags are false -- nothing to do. At least one of flags must be true");
        }
    }

    /* synthetic */ CheckVFSHealthExtension(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        if ((n & 8) != 0) {
            bl4 = false;
        }
        this(bl, bl2, bl3, bl4);
    }

    public void beforeAll(@Nullable ExtensionContext context2) {
        if (this.checkBeforeAll) {
            ExtensionContext extensionContext = context2;
            Intrinsics.checkNotNull((Object)extensionContext);
            this.checkVFS(extensionContext);
        }
    }

    public void afterAll(@Nullable ExtensionContext context2) {
        if (this.checkAfterAll) {
            ExtensionContext extensionContext = context2;
            Intrinsics.checkNotNull((Object)extensionContext);
            this.checkVFS(extensionContext);
        }
    }

    public void beforeEach(@Nullable ExtensionContext context2) {
        if (this.checkBeforeEach) {
            ExtensionContext extensionContext = context2;
            Intrinsics.checkNotNull((Object)extensionContext);
            this.checkVFS(extensionContext);
        }
    }

    public void afterEach(@Nullable ExtensionContext context2) {
        if (this.checkAfterEach) {
            ExtensionContext extensionContext = context2;
            Intrinsics.checkNotNull((Object)extensionContext);
            this.checkVFS(extensionContext);
        }
    }

    private final void checkVFS(ExtensionContext context2) throws Exception {
        VFSHealthChecker checker = new VFSHealthChecker();
        VFSHealthChecker.VFSHealthCheckReport report = checker.checkHealth(true);
        context2.publishReportEntry("vfs-report", report.toString());
        if (!report.getHealthy()) {
            throw new AssertionError((Object)("VFS is corrupted: " + report));
        }
    }

    @JvmStatic
    @NotNull
    public static final CheckVFSHealthExtension beforeAll() {
        return Companion.beforeAll();
    }

    @JvmStatic
    @NotNull
    public static final CheckVFSHealthExtension afterAll() {
        return Companion.afterAll();
    }

    @JvmStatic
    @NotNull
    public static final CheckVFSHealthExtension beforeAndAfterAll() {
        return Companion.beforeAndAfterAll();
    }

    @JvmStatic
    @NotNull
    public static final CheckVFSHealthExtension beforeEach() {
        return Companion.beforeEach();
    }

    @JvmStatic
    @NotNull
    public static final CheckVFSHealthExtension afterEach() {
        return Companion.afterEach();
    }

    @JvmStatic
    @NotNull
    public static final CheckVFSHealthExtension beforeAndAfterEach() {
        return Companion.beforeAndAfterEach();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\b\u0010\t\u001a\u00020\u0004H\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/testFramework/junit5/impl/CheckVFSHealthExtension$Companion;", "", "()V", "afterAll", "Lcom/intellij/testFramework/junit5/impl/CheckVFSHealthExtension;", "afterEach", "beforeAll", "beforeAndAfterAll", "beforeAndAfterEach", "beforeEach", "intellij.platform.testFramework.junit5"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CheckVFSHealthExtension beforeAll() {
            return new CheckVFSHealthExtension(false, false, true, false, 11, null);
        }

        @JvmStatic
        @NotNull
        public final CheckVFSHealthExtension afterAll() {
            return new CheckVFSHealthExtension(false, false, false, true, 7, null);
        }

        @JvmStatic
        @NotNull
        public final CheckVFSHealthExtension beforeAndAfterAll() {
            return new CheckVFSHealthExtension(false, false, true, true, 3, null);
        }

        @JvmStatic
        @NotNull
        public final CheckVFSHealthExtension beforeEach() {
            return new CheckVFSHealthExtension(true, false, false, false, 14, null);
        }

        @JvmStatic
        @NotNull
        public final CheckVFSHealthExtension afterEach() {
            return new CheckVFSHealthExtension(false, true, false, false, 13, null);
        }

        @JvmStatic
        @NotNull
        public final CheckVFSHealthExtension beforeAndAfterEach() {
            return new CheckVFSHealthExtension(true, true, false, false, 12, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

