/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.daemon.DaemonAnalyzerTestCase;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.testFramework.HeavyPlatformTestCase;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@HeavyPlatformTestCase.WrapInCommand
public abstract class JavaCompletionTestCase
extends DaemonAnalyzerTestCase {
    protected String myPrefix;
    protected LookupElement[] myItems;
    private CompletionType myType = CompletionType.BASIC;

    @Override
    protected void tearDown() throws Exception {
        this.myItems = null;
        try {
            LookupManager.hideActiveLookup((Project)this.myProject);
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    protected void configureByFile(String filePath) throws Exception {
        super.configureByFile(filePath);
        this.complete();
    }

    protected void configureByFileNoCompletion(String filePath) throws Exception {
        super.configureByFile(filePath);
    }

    protected void complete() {
        this.complete(1);
    }

    protected void complete(int time) {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        new CodeCompletionHandlerBase(this.myType).invokeCompletion(this.myProject, InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)this.myEditor, (PsiFile)this.getFile()), time);
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup((Editor)this.myEditor);
        this.myItems = lookup == null ? null : lookup.getItems().toArray(LookupElement.EMPTY_ARRAY);
        this.myPrefix = lookup == null ? "" : lookup.itemPattern((LookupElement)lookup.getItems().get(0));
    }

    public void setType(CompletionType type) {
        this.myType = type;
    }

    protected void selectItem(LookupElement item, char ch) {
        LookupImpl lookup = (LookupImpl)LookupManager.getInstance((Project)this.myProject).getActiveLookup();
        assert (lookup != null);
        lookup.setCurrentItem(item);
        lookup.finishLookup(ch);
    }

    protected void selectItem(LookupElement item) {
        this.selectItem(item, '\u0000');
    }

    protected void doTestByCount(int finalCount, String ... values) {
        int index = 0;
        if (this.myItems == null) {
            JavaCompletionTestCase.assertEquals((int)0, (int)finalCount);
            return;
        }
        block0: for (LookupElement myItem : this.myItems) {
            for (String value : values) {
                if (value == null) {
                    JavaCompletionTestCase.fail((String)"Unacceptable value reached");
                }
                if (!value.equals(myItem.getLookupString())) continue;
                ++index;
                continue block0;
            }
        }
        JavaCompletionTestCase.assertEquals((String)Arrays.toString(this.myItems), (int)finalCount, (int)index);
    }

    @Nullable
    protected LookupImpl getActiveLookup() {
        return (LookupImpl)LookupManager.getActiveLookup((Editor)this.myEditor);
    }

    protected void assertStringItems(String ... strings) {
        JavaCompletionTestCase.assertNotNull((Object)this.myItems);
        List actual = ContainerUtil.map((Object[])this.myItems, element2 -> element2.getLookupString());
        JavaCompletionTestCase.assertOrderedEquals(actual, strings);
    }
}

