/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.NameUtilCore;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassFinder {
    private static final List<String> IGNORED_CLASS_NAMES = Arrays.asList("com.intellij.tests.BootstrapTests", "com.intellij.AllTests");
    private final List<String> classNameList;
    private final Path classPathRoot;
    private final boolean includeUnconventionallyNamedTests;

    public ClassFinder(Path classPathRoot, String rootPackage, boolean includeUnconventionallyNamedTests) {
        this.classPathRoot = classPathRoot;
        this.includeUnconventionallyNamedTests = includeUnconventionallyNamedTests;
        String directoryOffset = rootPackage.replace(".", classPathRoot.getFileSystem().getSeparator());
        this.classNameList = this.findAndStoreTestClasses(classPathRoot.resolve(directoryOffset));
    }

    @Deprecated(forRemoval=true)
    public ClassFinder(File classPathRoot, String rootPackage, boolean includeUnconventionallyNamedTests) {
        this(classPathRoot.toPath(), rootPackage, includeUnconventionallyNamedTests);
    }

    @Nullable
    private String computeClassName(@NotNull Path path) {
        Path absPath;
        String fileName;
        if (path == null) {
            ClassFinder.$$$reportNull$$$0(0);
        }
        if (!FileUtilRt.extensionEquals((String)(fileName = (absPath = path.toAbsolutePath()).getFileName().toString()), (String)"class")) {
            return null;
        }
        if (!this.includeUnconventionallyNamedTests) {
            if (fileName.endsWith("Test.class")) {
                return this.getClassFQN(absPath);
            }
        } else {
            String nestedClassName = FileUtilRt.getNameWithoutExtension((String)fileName);
            List<String> names = Arrays.asList(nestedClassName.split("\\$"));
            Collections.reverse(names);
            for (String className : names) {
                if (!Character.isUpperCase(className.charAt(0))) {
                    return null;
                }
                List<String> words = Arrays.asList(NameUtilCore.nameToWords((String)className));
                if (!words.contains("Test") && !words.contains("Tests") && !words.contains("Suite")) continue;
                return this.getClassFQN(absPath);
            }
        }
        return null;
    }

    @Nullable
    private String getClassFQN(@NotNull Path path) {
        String fqn;
        if (path == null) {
            ClassFinder.$$$reportNull$$$0(1);
        }
        return IGNORED_CLASS_NAMES.contains(fqn = StringUtil.trimEnd((String)this.classPathRoot.relativize(path).toString(), (String)".class").replace(path.getFileSystem().getSeparator(), ".")) ? null : fqn;
    }

    private List<String> findAndStoreTestClasses(@NotNull Path current) {
        List<String> list;
        block10: {
            if (current == null) {
                ClassFinder.$$$reportNull$$$0(2);
            }
            if (!Files.exists(current, new LinkOption[0])) {
                return Collections.emptyList();
            }
            Stream<Path> walk = Files.walk(current, new FileVisitOption[0]);
            try {
                list = walk.filter(path -> Files.isRegularFile(path, new LinkOption[0])).map(path -> this.computeClassName((Path)path)).filter(name -> name != null).toList();
                if (walk == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            walk.close();
        }
        return list;
    }

    public Collection<String> getClasses() {
        return this.classNameList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ClassFinder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "computeClassName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getClassFQN";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findAndStoreTestClasses";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

