/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.profilers;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.SystemProperties;
import com.jetbrains.performancePlugin.profilers.Profiler;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\bf\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aJ\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH&J\u0012\u0010\u000b\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\rH&J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H&J'\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u0019\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tH&J\u0016\u0010\u0019\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004R\u0012\u0010\u0005\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0004\u00f8\u0001\u0001\u0082\u0002\n\n\u0002\b\u0019\n\u0004\b!0\u0001\u00a8\u0006\u001b\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/performancePlugin/profilers/Profiler;", "", "isEnabled", "", "()Z", "isProfilingStarted", "compressResults", "Ljava/io/File;", "pathToResult", "", "archiveName", "isEnabledInProject", "project", "Lcom/intellij/openapi/project/Project;", "startProfiling", "", "activityName", "options", "", "startProfilingAsync", "(Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stopProfileAsyncWithNotification", "arguments", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stopProfileWithNotification", "stopProfiling", "Companion", "intellij.performanceTesting"})
public interface Profiler {
    @NotNull
    public static final Companion Companion = com.jetbrains.performancePlugin.profilers.Profiler$Companion.$$INSTANCE;
    @NotNull
    public static final String PROFILER_PROPERTY = "integrationTests.profiler";

    public void startProfiling(@NotNull String var1, @NotNull List<String> var2);

    @Nullable
    default public Object startProfilingAsync(@NotNull String activityName, @NotNull List<String> options, @NotNull Continuation<? super Unit> $completion) {
        return Profiler.startProfilingAsync$suspendImpl(this, activityName, options, $completion);
    }

    public static /* synthetic */ Object startProfilingAsync$suspendImpl(Profiler $this, String activityName, List<String> options, Continuation<? super Unit> $completion) {
        Object object = CoroutinesKt.blockingContext((Function0)((Function0)new Function0<Unit>($this, activityName, options){
            final /* synthetic */ Profiler this$0;
            final /* synthetic */ String $activityName;
            final /* synthetic */ List<String> $options;
            {
                this.this$0 = $receiver;
                this.$activityName = $activityName;
                this.$options = $options;
                super(0);
            }

            public final void invoke() {
                this.this$0.startProfiling(this.$activityName, this.$options);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public String stopProfiling(@NotNull List<String> var1) throws Exception;

    @NotNull
    public String stopProfileWithNotification(@NotNull String var1);

    @Nullable
    default public Object stopProfileAsyncWithNotification(@NotNull String arguments, @NotNull Continuation<? super String> $completion) {
        return Profiler.stopProfileAsyncWithNotification$suspendImpl(this, arguments, $completion);
    }

    public static /* synthetic */ Object stopProfileAsyncWithNotification$suspendImpl(Profiler $this, String arguments, Continuation<? super String> $completion) {
        return CoroutinesKt.blockingContext((Function0)((Function0)new Function0<String>($this, arguments){
            final /* synthetic */ Profiler this$0;
            final /* synthetic */ String $arguments;
            {
                this.this$0 = $receiver;
                this.$arguments = $arguments;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.this$0.stopProfileWithNotification(this.$arguments);
            }
        }), $completion);
    }

    @Nullable
    public File compressResults(@NotNull String var1, @NotNull String var2) throws IOException;

    public boolean isEnabled();

    public boolean isEnabledInProject(@Nullable Project var1);

    public boolean isProfilingStarted();

    @JvmStatic
    public static boolean isAnyProfilingStarted() {
        return Companion.isAnyProfilingStarted();
    }

    @JvmStatic
    @NotNull
    public static Profiler getCurrentProfilerHandler() {
        return Companion.getCurrentProfilerHandler();
    }

    @JvmStatic
    @NotNull
    public static Profiler getCurrentProfilerHandler(@Nullable Project project) {
        return Companion.getCurrentProfilerHandler(project);
    }

    @JvmStatic
    @NotNull
    public static String formatSnapshotName(boolean isMemorySnapshot) {
        return Companion.formatSnapshotName(isMemorySnapshot);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\u0005H\u0007J\u0012\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\b\u0010\u0010\u001a\u00020\fH\u0007R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/performancePlugin/profilers/Profiler$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/jetbrains/performancePlugin/profilers/Profiler;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "PROFILER_PROPERTY", "", "formatSnapshotName", "isMemorySnapshot", "", "getCurrentProfilerHandler", "project", "Lcom/intellij/openapi/project/Project;", "isAnyProfilingStarted", "intellij.performanceTesting"})
    @SourceDebugExtension(value={"SMAP\nProfiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Profiler.kt\ncom/jetbrains/performancePlugin/profilers/Profiler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1747#2,3:74\n766#2:77\n857#2,2:78\n*S KotlinDebug\n*F\n+ 1 Profiler.kt\ncom/jetbrains/performancePlugin/profilers/Profiler$Companion\n*L\n20#1:74,3\n31#1:77\n31#1:78,2\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        public static final String PROFILER_PROPERTY = "integrationTests.profiler";
        @NotNull
        private static final ExtensionPointName<Profiler> EP_NAME;

        private Companion() {
        }

        @NotNull
        public final ExtensionPointName<Profiler> getEP_NAME() {
            return EP_NAME;
        }

        @JvmStatic
        public final boolean isAnyProfilingStarted() {
            boolean bl;
            block3: {
                Iterable $this$any$iv = EP_NAME.getExtensionList();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Profiler it = (Profiler)element$iv;
                        boolean bl2 = false;
                        if (!it.isProfilingStarted()) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @JvmStatic
        @NotNull
        public final Profiler getCurrentProfilerHandler() {
            Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)EP_NAME.getExtensionList()), (Function1)getCurrentProfilerHandler.all.1.INSTANCE);
            Comparator<Object> comparator = Comparator.comparing(arg_0 -> Companion.getCurrentProfilerHandler$lambda$1(getCurrentProfilerHandler.all.2.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
            Sequence all2 = SequencesKt.sortedWith((Sequence)sequence, comparator);
            Profiler profiler = (Profiler)SequencesKt.firstOrNull((Sequence)all2);
            if (profiler == null) {
                throw new RuntimeException("There are no installed profilers");
            }
            return profiler;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Profiler getCurrentProfilerHandler(@Nullable Project project) {
            boolean bl;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = EP_NAME.getExtensionList();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Profiler it = (Profiler)element$iv$iv;
                boolean bl2 = false;
                if (!it.isEnabledInProject(project)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List all2 = (List)destination$iv$iv;
            boolean bl3 = bl = all2.size() == 1;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            return (Profiler)CollectionsKt.first((List)all2);
        }

        @JvmStatic
        @NotNull
        public final String formatSnapshotName(boolean isMemorySnapshot) {
            String string = ApplicationInfo.getInstance().getBuild().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String buildNumber = string;
            String string2 = SystemProperties.getUserName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUserName(...)");
            String userName = string2;
            String snapshotDate = new SimpleDateFormat("dd.MM.yyyy_HH.mm.ss").format(new Date());
            return buildNumber + "_" + (isMemorySnapshot ? "memory_" : "") + userName + "_" + snapshotDate;
        }

        private static final String getCurrentProfilerHandler$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (String)$tmp0.invoke(p0);
        }

        static {
            $$INSTANCE = new Companion();
            EP_NAME = new ExtensionPointName("com.jetbrains.performancePlugin.profiler");
        }
    }
}

