/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0016\u0010\f\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0016\u0010\r\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J&\u0010\u000e\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\u0011\u001a\u00020\u00102\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/performancePlugin/commands/WaitForFinishedCodeAnalysisListener;", "Lcom/intellij/codeInsight/daemon/DaemonCodeAnalyzer$DaemonListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "daemonCanceled", "", "reason", "", "fileEditors", "", "Lcom/intellij/openapi/fileEditor/FileEditor;", "daemonFinished", "daemonStarting", "daemonStopped", "canceled", "", "skipNonPsiFileEditors", "Companion", "ListenerState", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nWaitForFinishedCodeAnalysis.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaitForFinishedCodeAnalysis.kt\ncom/jetbrains/performancePlugin/commands/WaitForFinishedCodeAnalysisListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,117:1\n30#2,3:118\n30#2,3:121\n800#3,11:124\n2624#3,3:135\n10#4:138\n*S KotlinDebug\n*F\n+ 1 WaitForFinishedCodeAnalysis.kt\ncom/jetbrains/performancePlugin/commands/WaitForFinishedCodeAnalysisListener\n*L\n65#1:118,3\n88#1:121,3\n93#1:124,11\n116#1:135,3\n60#1:138\n*E\n"})
public final class WaitForFinishedCodeAnalysisListener
implements DaemonCodeAnalyzer.DaemonListener {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;

    public WaitForFinishedCodeAnalysisListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public void daemonStarting(@NotNull Collection<? extends FileEditor> fileEditors) {
        Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
        if (!ApplicationManagerEx.isInIntegrationTest() || this.skipNonPsiFileEditors(fileEditors)) {
            return;
        }
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ListenerState> serviceClass$iv = ListenerState.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        ListenerState state = (ListenerState)object;
        FileEditor editor = (FileEditor)CollectionsKt.first((Iterable)fileEditors);
        LOG.info("daemon starting for " + editor);
        Exception previousSessionStartTrace = state.getSessions().put(editor, new Exception("Previous daemon start trace (editors = " + fileEditors + ")"));
        if (previousSessionStartTrace != null) {
            String errMsg = "Overlapping highlighting sessions";
            AssertionError err = new AssertionError((Object)errMsg);
            ExceptionsKt.addSuppressed((Throwable)((Throwable)((Object)err)), (Throwable)new Exception("Current daemon start trace (editors = " + fileEditors + ")"));
            ExceptionsKt.addSuppressed((Throwable)((Throwable)((Object)err)), (Throwable)previousSessionStartTrace);
            LOG.error((Throwable)((Object)err));
        }
    }

    public void daemonCanceled(@NotNull String reason, @NotNull Collection<? extends FileEditor> fileEditors) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
        this.daemonStopped(fileEditors, true, reason);
    }

    public void daemonFinished(@NotNull Collection<? extends FileEditor> fileEditors) {
        Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
        this.daemonStopped(fileEditors, false, "daemonFinished");
    }

    /*
     * WARNING - void declaration
     */
    private final void daemonStopped(Collection<? extends FileEditor> fileEditors, boolean canceled, String reason) {
        void $this$filterIsInstanceTo$iv$iv;
        if (!ApplicationManagerEx.isInIntegrationTest() || this.skipNonPsiFileEditors(fileEditors)) {
            return;
        }
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ListenerState> serviceClass$iv = ListenerState.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        ListenerState state = (ListenerState)object;
        FileEditor editor = (FileEditor)CollectionsKt.first((Iterable)fileEditors);
        state.getSessions().remove(editor);
        LOG.info("daemon stopped for " + editor + " with reason " + reason);
        Iterable $this$filterIsInstance$iv = fileEditors;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TextEditor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object object2 = CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        Intrinsics.checkNotNull((Object)object2);
        TextEditor fileEditor = (TextEditor)object2;
        boolean entireFileHighlighted = DaemonCodeAnalyzerImpl.isHighlightingCompleted((FileEditor)((FileEditor)fileEditor), (Project)this.project);
        if (!canceled && entireFileHighlighted && !DumbService.Companion.isDumb(this.project)) {
            ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(state){
                final /* synthetic */ ListenerState $state;
                {
                    this.$state = $state;
                    super(0);
                }

                public final void invoke() {
                    String[] stringArray = new String[]{"idea.log"};
                    Path path = Paths.get(PathManager.getLogPath(), stringArray);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                    Path path2 = path;
                    List<String> list = Files.readAllLines(path2, Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
                    String rowFirstDateTimeFromLog = ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)StringsKt.substringBefore$default((String)((String)CollectionsKt.first(list)), (String)"[", null, (int)2, null), (String)",", (String)".", (boolean)false, (int)4, null))).toString();
                    LocalDateTime dateTimeWhenAppStarted = LocalDateTime.parse(rowFirstDateTimeFromLog, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"));
                    WaitForFinishedCodeAnalysisListener.access$getCompanion$p().getLOG().info("Total opening time is : " + ChronoUnit.MILLIS.between(dateTimeWhenAppStarted, LocalDateTime.now()));
                    if (this.$state.getSessions().isEmpty()) {
                        this.$state.getHighlightingFinishedEverywhere().setDone();
                    }
                }
            }), (int)1, null);
        }
    }

    private final boolean skipNonPsiFileEditors(Collection<? extends FileEditor> fileEditors) {
        boolean bl;
        block3: {
            Iterable $this$none$iv = fileEditors;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    FileEditor editor = (FileEditor)element$iv;
                    boolean bl2 = false;
                    if (!(editor instanceof PsiAwareTextEditorImpl)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final /* synthetic */ Companion access$getCompanion$p() {
        return Companion;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WaitForFinishedCodeAnalysisListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/performancePlugin/commands/WaitForFinishedCodeAnalysisListener$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.performanceTesting"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R%\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\f\u0012\n\u0018\u00010\nj\u0004\u0018\u0001`\u000b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/performancePlugin/commands/WaitForFinishedCodeAnalysisListener$ListenerState;", "", "()V", "highlightingFinishedEverywhere", "Lcom/intellij/openapi/util/ActionCallback;", "getHighlightingFinishedEverywhere", "()Lcom/intellij/openapi/util/ActionCallback;", "sessions", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getSessions", "()Ljava/util/concurrent/ConcurrentHashMap;", "intellij.performanceTesting"})
    public static final class ListenerState {
        @NotNull
        private final ConcurrentHashMap<FileEditor, Exception> sessions = new ConcurrentHashMap();
        @NotNull
        private final ActionCallback highlightingFinishedEverywhere = new ActionCallback();

        @NotNull
        public final ConcurrentHashMap<FileEditor, Exception> getSessions() {
            return this.sessions;
        }

        @NotNull
        public final ActionCallback getHighlightingFinishedEverywhere() {
            return this.highlightingFinishedEverywhere;
        }
    }
}

