/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin;

import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.jetbrains.performancePlugin.WarmupIJTracer;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;

public final class PerformanceTestSpan {
    public static final String SPAN_NAME = "performance_test";
    public static final IJTracer TRACER = TelemetryManager.getInstance().getTracer(new com.intellij.platform.diagnostic.telemetry.Scope("performance-plugin", null));
    public static final IJTracer WARMUP_TRACER = new WarmupIJTracer(TRACER);
    private static Span performanceTestSpan;
    private static Scope performanceScope;

    static void startSpan() {
        performanceTestSpan = TRACER.spanBuilder(SPAN_NAME).setNoParent().startSpan();
        performanceScope = performanceTestSpan.makeCurrent();
    }

    static void endSpan() {
        if (performanceScope != null) {
            performanceScope.close();
        }
        if (performanceTestSpan != null) {
            performanceTestSpan.end();
        }
    }

    public static Context getContext() {
        if (performanceTestSpan != null) {
            return Context.current().with((ImplicitContextKeyed)performanceTestSpan);
        }
        return Context.current();
    }

    public static IJTracer getTracer(boolean noopTracer) {
        return noopTracer ? WARMUP_TRACER : TRACER;
    }
}

