/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import com.intellij.gradle.toolingExtension.modelAction.DefaultBuild;
import com.intellij.gradle.toolingExtension.modelAction.DefaultBuildController;
import com.intellij.gradle.toolingExtension.modelAction.GradleModelFetchAction;
import com.intellij.gradle.toolingExtension.modelAction.GradleModelFetchPhase;
import com.intellij.util.ReflectionUtilRt;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.adapter.TargetTypeProvider;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.BuildModel;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.build.GradleEnvironment;
import org.gradle.tooling.model.build.JavaEnvironment;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.Build;
import org.jetbrains.plugins.gradle.model.ModelsHolder;
import org.jetbrains.plugins.gradle.model.ProjectImportModelProvider;
import org.jetbrains.plugins.gradle.tooling.serialization.ModelConverter;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalBuildIdentifier;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalJavaEnvironment;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.build.InternalBuildEnvironment;

public class ProjectImportAction
implements BuildAction<AllModels>,
Serializable {
    private final Set<ProjectImportModelProvider> myModelProviders = new LinkedHashSet<ProjectImportModelProvider>();
    private final Set<Class<?>> myTargetTypes = new LinkedHashSet();
    private final boolean myIsPreviewMode;
    private boolean myUseProjectsLoadedPhase;
    @Nullable
    private transient AllModels myAllModels = null;
    @Nullable
    private transient GradleBuild myGradleBuild = null;
    @Nullable
    private transient ModelConverter myModelConverter = null;

    public ProjectImportAction(boolean isPreviewMode) {
        this.myIsPreviewMode = isPreviewMode;
    }

    public void addProjectImportModelProviders(@NotNull Collection<? extends ProjectImportModelProvider> providers) {
        if (providers == null) {
            ProjectImportAction.$$$reportNull$$$0(0);
        }
        this.myModelProviders.addAll(providers);
    }

    @ApiStatus.Internal
    public Set<Class<?>> getModelProvidersClasses() {
        LinkedHashSet result = new LinkedHashSet();
        for (ProjectImportModelProvider provider : this.myModelProviders) {
            result.add(provider.getClass());
        }
        return result;
    }

    public void addTargetTypes(@NotNull Set<Class<?>> targetTypes) {
        if (targetTypes == null) {
            ProjectImportAction.$$$reportNull$$$0(1);
        }
        this.myTargetTypes.addAll(targetTypes);
    }

    public void prepareForPhasedExecuter() {
        this.myUseProjectsLoadedPhase = true;
    }

    public void prepareForNonPhasedExecuter() {
        this.myUseProjectsLoadedPhase = false;
    }

    @NotNull
    protected ModelConverter getToolingModelConverter(@NotNull BuildController controller) {
        if (controller == null) {
            ProjectImportAction.$$$reportNull$$$0(2);
        }
        ModelConverter modelConverter = ModelConverter.NOP;
        if (modelConverter == null) {
            ProjectImportAction.$$$reportNull$$$0(3);
        }
        return modelConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public AllModels execute(@NotNull BuildController controller) {
        if (controller == null) {
            ProjectImportAction.$$$reportNull$$$0(4);
        }
        ExecutorService converterExecutor = Executors.newSingleThreadExecutor(new SimpleThreadFactory());
        try {
            AllModels allModels = this.doExecute(controller, converterExecutor);
            return allModels;
        }
        finally {
            converterExecutor.shutdown();
            try {
                converterExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Nullable
    private AllModels doExecute(@NotNull BuildController controller, @NotNull ExecutorService converterExecutor) {
        boolean isProjectsLoadedAction;
        if (controller == null) {
            ProjectImportAction.$$$reportNull$$$0(5);
        }
        if (converterExecutor == null) {
            ProjectImportAction.$$$reportNull$$$0(6);
        }
        this.configureAdditionalTypes(controller);
        boolean bl = isProjectsLoadedAction = this.myAllModels == null && this.myUseProjectsLoadedPhase;
        if (isProjectsLoadedAction || !this.myUseProjectsLoadedPhase) {
            long startTime = System.currentTimeMillis();
            this.myGradleBuild = controller.getBuildModel();
            AllModels allModels = new AllModels(this.myGradleBuild);
            allModels.logPerformance("Get model GradleBuild", System.currentTimeMillis() - startTime);
            long startTimeBuildEnv = System.currentTimeMillis();
            BuildEnvironment buildEnvironment = (BuildEnvironment)controller.findModel(BuildEnvironment.class);
            allModels.setBuildEnvironment(ProjectImportAction.convert(buildEnvironment));
            allModels.logPerformance("Get model BuildEnvironment", System.currentTimeMillis() - startTimeBuildEnv);
            this.myAllModels = allModels;
            this.myModelConverter = this.getToolingModelConverter(controller);
        }
        assert (this.myAllModels != null);
        assert (this.myGradleBuild != null);
        assert (this.myModelConverter != null);
        Set<ProjectImportModelProvider> modelProviders = this.getModelProviders(isProjectsLoadedAction);
        GradleModelFetchAction modelFetchAction = new GradleModelFetchAction(this.myAllModels, modelProviders, this.myModelConverter, converterExecutor, this.myIsPreviewMode, isProjectsLoadedAction);
        long startTime = System.currentTimeMillis();
        modelFetchAction.execute(new DefaultBuildController(controller, this.myGradleBuild));
        this.myAllModels.logPerformance("Execute GradleModelFetchAction", System.currentTimeMillis() - startTime);
        return isProjectsLoadedAction && !this.myAllModels.hasModels() ? null : this.myAllModels;
    }

    @Contract(value="null -> null")
    private static BuildEnvironment convert(@Nullable BuildEnvironment buildEnvironment) {
        if (buildEnvironment == null || buildEnvironment instanceof InternalBuildEnvironment) {
            return buildEnvironment;
        }
        return new InternalBuildEnvironment(() -> {
            BuildIdentifier buildIdentifier = buildEnvironment.getBuildIdentifier();
            return new InternalBuildIdentifier(buildIdentifier.getRootDir());
        }, () -> {
            GradleEnvironment gradle = buildEnvironment.getGradle();
            return gradle.getGradleUserHome();
        }, () -> {
            GradleEnvironment gradle = buildEnvironment.getGradle();
            return gradle.getGradleVersion();
        }, () -> {
            JavaEnvironment java = buildEnvironment.getJava();
            return new InternalJavaEnvironment(java.getJavaHome(), java.getJvmArguments());
        });
    }

    private void configureAdditionalTypes(BuildController controller) {
        if (this.myTargetTypes.isEmpty()) {
            return;
        }
        try {
            ProtocolToModelAdapter modelAdapter = (ProtocolToModelAdapter)ReflectionUtilRt.getField(controller.getClass(), (Object)controller, ProtocolToModelAdapter.class, (String)"adapter");
            if (modelAdapter == null) {
                return;
            }
            TargetTypeProvider typeProvider = (TargetTypeProvider)ReflectionUtilRt.getField(ProtocolToModelAdapter.class, (Object)modelAdapter, TargetTypeProvider.class, (String)"targetTypeProvider");
            if (typeProvider == null) {
                return;
            }
            Map targetTypes = (Map)ReflectionUtilRt.getField(typeProvider.getClass(), (Object)typeProvider, Map.class, (String)"configuredTargetTypes");
            if (targetTypes == null) {
                return;
            }
            for (Class<?> targetType : this.myTargetTypes) {
                targetTypes.put(targetType.getCanonicalName(), targetType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Set<ProjectImportModelProvider> getModelProviders(boolean isProjectsLoadedAction) {
        if (this.myUseProjectsLoadedPhase) {
            if (isProjectsLoadedAction) {
                return this.myModelProviders.stream().filter(it -> it.getPhase().equals((Object)GradleModelFetchPhase.PROJECT_LOADED_PHASE)).collect(Collectors.toSet());
            }
            return this.myModelProviders.stream().filter(it -> !it.getPhase().equals((Object)GradleModelFetchPhase.PROJECT_LOADED_PHASE)).collect(Collectors.toSet());
        }
        return this.myModelProviders;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetTypes";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/model/ProjectImportAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converterExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/model/ProjectImportAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolingModelConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addProjectImportModelProviders";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addTargetTypes";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getToolingModelConverter";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class AllModels
    extends ModelsHolder<BuildModel, ProjectModel> {
        @NotNull
        private final List<Build> includedBuilds;
        private final Map<String, Long> performanceTrace;
        private transient Map<String, String> myBuildsKeyPrefixesMapping;

        public AllModels(@NotNull GradleBuild mainBuild) {
            if (mainBuild == null) {
                AllModels.$$$reportNull$$$0(0);
            }
            super(DefaultBuild.convertGradleBuild(mainBuild));
            this.includedBuilds = new ArrayList<Build>();
            this.performanceTrace = new ConcurrentHashMap<String, Long>();
        }

        public AllModels(@NotNull IdeaProject ideaProject) {
            if (ideaProject == null) {
                AllModels.$$$reportNull$$$0(1);
            }
            super(DefaultBuild.convertIdeaProject(ideaProject));
            this.includedBuilds = new ArrayList<Build>();
            this.performanceTrace = new ConcurrentHashMap<String, Long>();
            this.addModel(ideaProject, IdeaProject.class);
        }

        @NotNull
        public Build getMainBuild() {
            Build build = (Build)this.getRootModel();
            if (build == null) {
                AllModels.$$$reportNull$$$0(2);
            }
            return build;
        }

        @NotNull
        public List<Build> getIncludedBuilds() {
            List<Build> list = this.includedBuilds;
            if (list == null) {
                AllModels.$$$reportNull$$$0(3);
            }
            return list;
        }

        @ApiStatus.Internal
        public void addIncludedBuild(@NotNull Build includedBuild) {
            if (includedBuild == null) {
                AllModels.$$$reportNull$$$0(4);
            }
            this.includedBuilds.add(includedBuild);
        }

        @NotNull
        public List<Build> getAllBuilds() {
            ArrayList<Build> result = new ArrayList<Build>();
            result.add(this.getMainBuild());
            result.addAll(this.includedBuilds);
            ArrayList<Build> arrayList = result;
            if (arrayList == null) {
                AllModels.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        @Nullable
        public BuildEnvironment getBuildEnvironment() {
            return this.getModel(BuildEnvironment.class);
        }

        public void setBuildEnvironment(@Nullable BuildEnvironment buildEnvironment) {
            if (buildEnvironment != null) {
                this.addModel(buildEnvironment, BuildEnvironment.class);
            }
        }

        public void logPerformance(@NotNull String description, long millis) {
            if (description == null) {
                AllModels.$$$reportNull$$$0(6);
            }
            this.performanceTrace.put(description, millis);
        }

        public Map<String, Long> getPerformanceTrace() {
            return this.performanceTrace;
        }

        @Override
        public void applyPathsConverter(@NotNull Consumer<Object> pathsConverter) {
            if (pathsConverter == null) {
                AllModels.$$$reportNull$$$0(7);
            }
            super.applyPathsConverter(pathsConverter);
            BuildEnvironment buildEnvironment = this.getBuildEnvironment();
            if (buildEnvironment != null) {
                pathsConverter.accept(buildEnvironment);
            }
            this.myBuildsKeyPrefixesMapping = new HashMap<String, String>();
            this.convertPaths(pathsConverter, this.getMainBuild());
            for (Build includedBuild : this.includedBuilds) {
                this.convertPaths(pathsConverter, includedBuild);
            }
        }

        private void convertPaths(@NotNull Consumer<Object> fileMapper, @NotNull Build build) {
            if (fileMapper == null) {
                AllModels.$$$reportNull$$$0(8);
            }
            if (build == null) {
                AllModels.$$$reportNull$$$0(9);
            }
            String originalKey = this.getBuildKeyPrefix(build.getBuildIdentifier());
            fileMapper.accept(build);
            String currentKey = this.getBuildKeyPrefix(build.getBuildIdentifier());
            if (!originalKey.equals(currentKey)) {
                this.myBuildsKeyPrefixesMapping.put(currentKey, originalKey);
            }
        }

        @Override
        @NotNull
        protected String getBuildKeyPrefix(@NotNull BuildIdentifier buildIdentifier) {
            if (buildIdentifier == null) {
                AllModels.$$$reportNull$$$0(10);
            }
            String currentKey = super.getBuildKeyPrefix(buildIdentifier);
            String originalKey = this.myBuildsKeyPrefixesMapping == null ? null : this.myBuildsKeyPrefixesMapping.get(currentKey);
            String string = originalKey == null ? currentKey : originalKey;
            if (string == null) {
                AllModels.$$$reportNull$$$0(11);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mainBuild";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ideaProject";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/model/ProjectImportAction$AllModels";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "includedBuild";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathsConverter";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileMapper";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "build";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildIdentifier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/model/ProjectImportAction$AllModels";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMainBuild";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIncludedBuilds";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllBuilds";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBuildKeyPrefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 11: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addIncludedBuild";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "logPerformance";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "applyPathsConverter";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "convertPaths";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getBuildKeyPrefix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class SimpleThreadFactory
    implements ThreadFactory {
        private SimpleThreadFactory() {
        }

        @Override
        public Thread newThread(@NotNull Runnable runnable) {
            if (runnable == null) {
                SimpleThreadFactory.$$$reportNull$$$0(0);
            }
            return new Thread(runnable, "idea-tooling-model-converter");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "org/jetbrains/plugins/gradle/model/ProjectImportAction$SimpleThreadFactory", "newThread"));
        }
    }
}

