/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.ClassNameProvider;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GenerationUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GeneratorClassNameProvider;

public final class TypeWriter
extends PsiTypeVisitor<Object> {
    private final boolean acceptEllipsis;
    private final StringBuilder builder;
    private final ClassNameProvider classNameProvider;
    private final PsiElement context;

    public static void writeTypeForNew(@NotNull StringBuilder builder, @Nullable PsiType type2, @NotNull PsiElement context) {
        PsiType erased;
        if (builder == null) {
            TypeWriter.$$$reportNull$$$0(0);
        }
        if (context == null) {
            TypeWriter.$$$reportNull$$$0(1);
        }
        if (type2 instanceof PsiArrayType && (erased = TypeConversionUtil.erasure((PsiType)type2)) != null) {
            type2 = erased;
        }
        TypeWriter.writeType(builder, type2, context, new GeneratorClassNameProvider());
    }

    public static void writeType(@NotNull StringBuilder builder, @Nullable PsiType type2, @NotNull PsiElement context) {
        if (builder == null) {
            TypeWriter.$$$reportNull$$$0(2);
        }
        if (context == null) {
            TypeWriter.$$$reportNull$$$0(3);
        }
        TypeWriter.writeType(builder, type2, context, new GeneratorClassNameProvider());
    }

    public static void writeType(@NotNull StringBuilder builder, @Nullable PsiType type2, @NotNull PsiElement context, @NotNull ClassNameProvider classNameProvider) {
        if (builder == null) {
            TypeWriter.$$$reportNull$$$0(4);
        }
        if (context == null) {
            TypeWriter.$$$reportNull$$$0(5);
        }
        if (classNameProvider == null) {
            TypeWriter.$$$reportNull$$$0(6);
        }
        if (type2 == null || PsiTypes.nullType().equals(type2)) {
            builder.append("java.lang.Object");
            return;
        }
        if (type2 instanceof PsiPrimitiveType) {
            builder.append(type2.getCanonicalText());
            return;
        }
        boolean acceptEllipsis = TypeWriter.isLastParameter(context);
        type2.accept((PsiTypeVisitor)new TypeWriter(builder, classNameProvider, acceptEllipsis, context));
    }

    private TypeWriter(@NotNull StringBuilder builder, @NotNull ClassNameProvider classNameProvider, boolean acceptEllipsis, @NotNull PsiElement context) {
        if (builder == null) {
            TypeWriter.$$$reportNull$$$0(7);
        }
        if (classNameProvider == null) {
            TypeWriter.$$$reportNull$$$0(8);
        }
        if (context == null) {
            TypeWriter.$$$reportNull$$$0(9);
        }
        this.acceptEllipsis = acceptEllipsis;
        this.builder = builder;
        this.classNameProvider = classNameProvider;
        this.context = context;
    }

    public Object visitEllipsisType(@NotNull PsiEllipsisType ellipsisType) {
        if (ellipsisType == null) {
            TypeWriter.$$$reportNull$$$0(10);
        }
        PsiType componentType = ellipsisType.getComponentType();
        componentType.accept((PsiTypeVisitor)this);
        if (this.acceptEllipsis) {
            this.builder.append("...");
        } else {
            this.builder.append("[]");
        }
        return this;
    }

    public Object visitPrimitiveType(@NotNull PsiPrimitiveType primitiveType) {
        if (primitiveType == null) {
            TypeWriter.$$$reportNull$$$0(11);
        }
        if (this.classNameProvider.forStubs()) {
            this.builder.append(primitiveType.getCanonicalText());
            return this;
        }
        PsiType boxed = TypesUtil.boxPrimitiveType((PsiType)primitiveType, this.context.getManager(), this.context.getResolveScope());
        boxed.accept((PsiTypeVisitor)this);
        return this;
    }

    public Object visitArrayType(@NotNull PsiArrayType arrayType) {
        if (arrayType == null) {
            TypeWriter.$$$reportNull$$$0(12);
        }
        arrayType.getComponentType().accept((PsiTypeVisitor)this);
        this.builder.append("[]");
        return this;
    }

    public Object visitClassType(@NotNull PsiClassType classType) {
        if (classType == null) {
            TypeWriter.$$$reportNull$$$0(13);
        }
        PsiType[] parameters2 = classType.getParameters();
        PsiClass psiClass = classType.resolve();
        if (psiClass == null) {
            this.builder.append(classType.getClassName());
        } else if (psiClass instanceof GrAnonymousClassDefinition) {
            this.visitClassType(((GrAnonymousClassDefinition)psiClass).getBaseClassType());
        } else {
            String qname = this.classNameProvider.getQualifiedClassName(psiClass, this.context);
            this.builder.append(qname);
        }
        GenerationUtil.writeTypeParameters(this.builder, parameters2, this.context, this.classNameProvider);
        return this;
    }

    public Object visitCapturedWildcardType(@NotNull PsiCapturedWildcardType capturedWildcardType) {
        if (capturedWildcardType == null) {
            TypeWriter.$$$reportNull$$$0(14);
        }
        capturedWildcardType.getWildcard().accept((PsiTypeVisitor)this);
        return this;
    }

    public Object visitWildcardType(@NotNull PsiWildcardType wildcardType) {
        if (wildcardType == null) {
            TypeWriter.$$$reportNull$$$0(15);
        }
        this.builder.append('?');
        PsiType bound = wildcardType.getBound();
        if (bound == null) {
            return this;
        }
        if (wildcardType.isExtends()) {
            this.builder.append(" extends ");
        } else {
            this.builder.append(" super ");
        }
        bound.accept((PsiTypeVisitor)this);
        return this;
    }

    public Object visitDisjunctionType(@NotNull PsiDisjunctionType disjunctionType) {
        if (disjunctionType == null) {
            TypeWriter.$$$reportNull$$$0(16);
        }
        throw new UnsupportedOperationException();
    }

    public Object visitType(@NotNull PsiType type2) {
        if (type2 == null) {
            TypeWriter.$$$reportNull$$$0(17);
        }
        throw new UnsupportedOperationException();
    }

    private static boolean isLastParameter(@NotNull PsiElement context) {
        PsiElement scope;
        if (context == null) {
            TypeWriter.$$$reportNull$$$0(18);
        }
        if (context instanceof PsiParameter && (scope = ((PsiParameter)context).getDeclarationScope()) instanceof PsiMethod) {
            PsiParameter[] parameters2 = ((PsiMethod)scope).getParameterList().getParameters();
            return parameters2.length > 0 && parameters2[parameters2.length - 1] == context;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classNameProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ellipsisType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primitiveType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capturedWildcardType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wildcardType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disjunctionType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/convertToJava/TypeWriter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "writeTypeForNew";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "writeType";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitEllipsisType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPrimitiveType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "visitArrayType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "visitClassType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCapturedWildcardType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "visitWildcardType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDisjunctionType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "visitType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "isLastParameter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

