/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.typing;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.CollectionUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.typing.GrCallTypeCalculator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0018\u00010\tj\u0004\u0018\u0001`\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/groovy/lang/typing/DgmCallTypeCalculator;", "Lorg/jetbrains/plugins/groovy/lang/typing/GrCallTypeCalculator;", "()V", "getType", "Lcom/intellij/psi/PsiType;", "receiver", "method", "Lcom/intellij/psi/PsiMethod;", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "context", "Lcom/intellij/psi/PsiElement;", "Companion", "intellij.groovy.psi"})
public final class DgmCallTypeCalculator
implements GrCallTypeCalculator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NlsSafe
    @NotNull
    private static final String FIND = "find";
    @NlsSafe
    @NotNull
    private static final String FLATTEN = "flatten";
    @NonNls
    @NotNull
    private static final Set<String> interestingNames;

    @Override
    @Nullable
    public PsiType getType(@Nullable PsiType receiver, @NotNull PsiMethod method, @Nullable List<? extends Argument> arguments2, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (GroovyConfigUtils.getInstance().isVersionAtLeast(context, "2.4")) {
            return null;
        }
        Collection collection = arguments2;
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        PsiClass psiClass = method.getContainingClass();
        if (!Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"org.codehaus.groovy.runtime.DefaultGroovyMethods")) {
            return null;
        }
        String string = method.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String methodName = string;
        if (Intrinsics.areEqual((Object)methodName, (Object)FIND)) {
            PsiType psiType = ((Argument)CollectionsKt.first(arguments2)).getType();
            PsiArrayType psiArrayType = psiType instanceof PsiArrayType ? (PsiArrayType)psiType : null;
            return psiArrayType != null ? psiArrayType.getComponentType() : null;
        }
        if (!interestingNames.contains(methodName) || !DgmCallTypeCalculator.Companion.isSimilarCollectionReturner(method)) {
            return null;
        }
        PsiType receiverType = ((Argument)CollectionsKt.first(arguments2)).getType();
        PsiType itemType = DgmCallTypeCalculator.Companion.getItemType(receiverType);
        if (Intrinsics.areEqual((Object)FLATTEN, (Object)methodName) && itemType != null) {
            while (DgmCallTypeCalculator.Companion.getItemType(itemType) != null) {
            }
        }
        PsiType[] psiTypeArray = new PsiType[]{itemType};
        return (PsiType)CollectionUtil.createSimilarCollection(receiverType, context.getProject(), psiTypeArray);
    }

    static {
        Object[] objectArray = new String[]{"unique", "findAll", "grep", "collectMany", "split", "plus", "intersect", "leftShift"};
        interestingNames = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/groovy/lang/typing/DgmCallTypeCalculator$Companion;", "", "()V", "FIND", "", "FLATTEN", "interestingNames", "", "getItemType", "Lcom/intellij/psi/PsiType;", "type", "isSimilarCollectionReturner", "", "method", "Lcom/intellij/psi/PsiMethod;", "intellij.groovy.psi"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isSimilarCollectionReturner(PsiMethod method) {
            PsiParameter[] psiParameterArray = method.getParameterList().getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
            PsiParameter psiParameter = (PsiParameter)ArraysKt.firstOrNull((Object[])psiParameterArray);
            if (psiParameter == null) {
                return false;
            }
            PsiParameter receiverParameter = psiParameter;
            PsiType psiType = receiverParameter.getType();
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
            PsiType receiverParameterType = psiType;
            if (!(receiverParameterType instanceof PsiArrayType) && !InheritanceUtil.isInheritor((PsiType)receiverParameterType, (String)"java.util.Collection")) {
                return false;
            }
            PsiType psiType2 = method.getReturnType();
            PsiClassType psiClassType = psiType2 instanceof PsiClassType ? (PsiClassType)psiType2 : null;
            if (psiClassType == null) {
                return false;
            }
            PsiClassType returnType2 = psiClassType;
            PsiClass psiClass = returnType2.resolve();
            return Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"java.util.Collection");
        }

        private final PsiType getItemType(PsiType type2) {
            PsiArrayType psiArrayType = type2 instanceof PsiArrayType ? (PsiArrayType)type2 : null;
            if (psiArrayType == null || (psiArrayType = psiArrayType.getComponentType()) == null) {
                psiArrayType = PsiUtil.extractIterableTypeParameter((PsiType)type2, (boolean)true);
            }
            return psiArrayType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

