/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ExpressionArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCallReferenceBase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u001e\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/references/GrUnaryOperatorReference;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyMethodCallReferenceBase;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrUnaryExpression;", "element", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrUnaryExpression;)V", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "getArguments", "()Ljava/util/List;", "methodName", "", "getMethodName", "()Ljava/lang/String;", "receiverArgument", "getReceiverArgument", "()Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "Companion", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nGrUnaryOperatorReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrUnaryOperatorReference.kt\norg/jetbrains/plugins/groovy/lang/resolve/references/GrUnaryOperatorReference\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,38:1\n1#2:39\n*E\n"})
public final class GrUnaryOperatorReference
extends GroovyMethodCallReferenceBase<GrUnaryExpression> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<IElementType, String> unaryOperatorMethodNames;

    public GrUnaryOperatorReference(@NotNull GrUnaryExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = ((GrUnaryExpression)this.getElement()).getOperationToken().getTextRangeInParent();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRangeInParent(...)");
        return textRange;
    }

    @Override
    @Nullable
    public Argument getReceiverArgument() {
        ExpressionArgument expressionArgument;
        GrExpression grExpression = ((GrUnaryExpression)this.getElement()).getOperand();
        if (grExpression != null) {
            GrExpression p0 = grExpression;
            boolean bl = false;
            expressionArgument = new ExpressionArgument(p0);
        } else {
            expressionArgument = null;
        }
        return expressionArgument;
    }

    @Override
    @NotNull
    public String getMethodName() {
        IElementType iElementType = ((GrUnaryExpression)this.getElement()).getOperationTokenType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationTokenType(...)");
        IElementType tokenType = iElementType;
        String string = unaryOperatorMethodNames.get(tokenType);
        if (string == null) {
            throw new IllegalStateException(("unexpected token type: " + tokenType).toString());
        }
        return string;
    }

    @Override
    @NotNull
    public List<Argument> getArguments() {
        return CollectionsKt.emptyList();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)GroovyElementTypes.T_NOT, (Object)"asBoolean"), TuplesKt.to((Object)GroovyElementTypes.T_PLUS, (Object)"positive"), TuplesKt.to((Object)GroovyElementTypes.T_MINUS, (Object)"negative"), TuplesKt.to((Object)GroovyElementTypes.T_DEC, (Object)"previous"), TuplesKt.to((Object)GroovyElementTypes.T_INC, (Object)"next"), TuplesKt.to((Object)GroovyElementTypes.T_BNOT, (Object)"bitwiseNegate")};
        unaryOperatorMethodNames = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\u0016\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/references/GrUnaryOperatorReference$Companion;", "", "()V", "unaryOperatorMethodNames", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "", "intellij.groovy.psi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

