/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.naming;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.codeInspection.naming.ConventionInspection;
import org.jetbrains.plugins.groovy.codeInspection.utils.LibraryUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyInstanceMethodNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 4;
    private static final int DEFAULT_MAX_LENGTH = 32;

    @Override
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            GroovyInstanceMethodNamingConventionInspection.$$$reportNull$$$0(0);
        }
        return GroovyQuickFixFactory.getInstance().createRenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String className = (String)args[0];
        if (className.length() < this.getMinLength()) {
            String string = GroovyBundle.message("inspection.message.instance.method.name.ref.too.short", new Object[0]);
            if (string == null) {
                GroovyInstanceMethodNamingConventionInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (className.length() > this.getMaxLength()) {
            String string = GroovyBundle.message("inspection.message.instance.method.name.ref.too.long", new Object[0]);
            if (string == null) {
                GroovyInstanceMethodNamingConventionInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = GroovyBundle.message("inspection.message.instance.method.name.ref.doesnt.match.regex", this.getRegex());
        if (string == null) {
            GroovyInstanceMethodNamingConventionInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    protected String getDefaultRegex() {
        return "[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 4;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyInstanceMethodNamingConventionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyInstanceMethodNamingConventionInspection";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFix";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitMethod(@NotNull GrMethod grMethod) {
            if (grMethod == null) {
                NamingConventionsVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(grMethod);
            if (grMethod.hasModifierProperty("static") || grMethod.isConstructor()) {
                return;
            }
            String name = grMethod.getName();
            if (GroovyInstanceMethodNamingConventionInspection.this.isValid(name)) {
                return;
            }
            if (LibraryUtil.isOverrideOfLibraryMethod(grMethod)) {
                return;
            }
            this.registerMethodError(grMethod, name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grMethod", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyInstanceMethodNamingConventionInspection$NamingConventionsVisitor", "visitMethod"));
        }
    }
}

