/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.utils.GrInspectionUIUtil;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\u000fR\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/GroovyLocalInspectionTool;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "explicitlyEnabledFileTypes", "", "", "buildGroovyVisitor", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "getGroovyOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "getOptionController", "Lcom/intellij/codeInspection/options/OptionController;", "getOptionsPane", "intellij.groovy.psi"})
public abstract class GroovyLocalInspectionTool
extends LocalInspectionTool {
    @JvmField
    @NotNull
    public Set<String> explicitlyEnabledFileTypes = new HashSet();

    @NotNull
    public final PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        GroovyElementVisitor groovyElementVisitor = this.buildGroovyVisitor(holder, isOnTheFly);
        return new GroovyPsiElementVisitor(this, groovyElementVisitor){
            final /* synthetic */ GroovyLocalInspectionTool this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (GrInspectionUIUtil.checkInspectionEnabledByFileType(this.this$0, element, this.this$0.explicitlyEnabledFileTypes)) {
                    super.visitElement(element);
                    return;
                }
            }
        };
    }

    @NotNull
    public abstract GroovyElementVisitor buildGroovyVisitor(@NotNull ProblemsHolder var1, boolean var2);

    @NotNull
    public final OptPane getOptionsPane() {
        OptPane pane = this.getGroovyOptionsPane();
        return GrInspectionUIUtil.enhanceInspectionToolPanel(this, pane);
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = super.getOptionController().onPrefix("fileType", GrInspectionUIUtil.getFileTypeController(this.explicitlyEnabledFileTypes));
        Intrinsics.checkNotNullExpressionValue((Object)optionController, (String)"onPrefix(...)");
        return optionController;
    }

    @NotNull
    public OptPane getGroovyOptionsPane() {
        OptPane optPane = OptPane.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"EMPTY");
        return optPane;
    }
}

