/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAsIntentionAdapter;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ParamInfo;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicElementSettings;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public final class QuickfixUtil {
    @Nullable
    public static PsiClass findTargetClass(GrReferenceExpression refExpr) {
        PsiType classType;
        if (refExpr.getQualifier() == null) {
            return PsiUtil.getContextClass(refExpr);
        }
        PsiType type2 = PsiImplUtil.getQualifierType(refExpr);
        if (ResolveUtil.resolvesToClass(refExpr.getQualifierExpression()) && (classType = ResolveUtil.unwrapClassType(type2)) != null) {
            type2 = classType;
        }
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        return ((PsiClassType)type2).resolve();
    }

    public static boolean isStaticCall(GrReferenceExpression refExpr) {
        GrExpression qualifierExpression = refExpr.getQualifierExpression();
        if (!(qualifierExpression instanceof GrReferenceExpression)) {
            return false;
        }
        GrReferenceExpression referenceExpression = (GrReferenceExpression)qualifierExpression;
        GroovyPsiElement resolvedElement = ResolveUtil.resolveProperty(referenceExpression, referenceExpression.getReferenceName());
        if (resolvedElement == null) {
            return false;
        }
        return resolvedElement instanceof PsiClass;
    }

    public static List<ParamInfo> swapArgumentsAndTypes(String[] names, PsiType[] types) {
        ArrayList<ParamInfo> result2 = new ArrayList<ParamInfo>();
        if (names.length != types.length) {
            return Collections.emptyList();
        }
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            PsiType type2 = types[i2];
            result2.add(new ParamInfo(name, type2.getCanonicalText()));
        }
        return result2;
    }

    public static String[] getArgumentsTypes(List<? extends ParamInfo> listOfPairs) {
        ArrayList<String> result2 = new ArrayList<String>();
        if (listOfPairs == null) {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        for (ParamInfo paramInfo : listOfPairs) {
            String type2 = PsiTypesUtil.unboxIfPossible((String)paramInfo.type);
            result2.add(type2);
        }
        return ArrayUtilRt.toStringArray(result2);
    }

    public static String[] getArgumentsNames(List<? extends ParamInfo> listOfPairs) {
        ArrayList<String> result2 = new ArrayList<String>();
        for (ParamInfo paramInfo : listOfPairs) {
            String name = paramInfo.name;
            result2.add(name);
        }
        return ArrayUtilRt.toStringArray(result2);
    }

    @NlsSafe
    public static String shortenType(@NlsSafe String typeText) {
        if (typeText == null) {
            return "";
        }
        int i2 = typeText.lastIndexOf(".");
        if (i2 != -1) {
            return typeText.substring(i2 + 1);
        }
        return typeText;
    }

    public static DynamicElementSettings createSettings(GrReferenceExpression referenceExpression) {
        DynamicElementSettings settings = new DynamicElementSettings();
        PsiClass containingClass = QuickfixUtil.findTargetClass(referenceExpression);
        assert (containingClass != null);
        String className = containingClass.getQualifiedName();
        String string = className = className == null ? containingClass.getContainingFile().getName() : className;
        if (QuickfixUtil.isStaticCall(referenceExpression)) {
            settings.setStatic(true);
        }
        settings.setContainingClassName(className);
        settings.setName(referenceExpression.getReferenceName());
        if (PsiUtil.isCall(referenceExpression)) {
            ArrayList<PsiType> unboxedTypes = new ArrayList<PsiType>();
            for (PsiType type2 : PsiUtil.getArgumentTypes(referenceExpression, false)) {
                unboxedTypes.add(TypesUtil.unboxPrimitiveTypeWrapperAndEraseGenerics(type2));
            }
            PsiType[] types = unboxedTypes.toArray(PsiType.createArray((int)unboxedTypes.size()));
            String[] names = GroovyNamesUtil.getMethodArgumentsNames(referenceExpression.getProject(), types);
            List<ParamInfo> infos = QuickfixUtil.swapArgumentsAndTypes(names, types);
            settings.setMethod(true);
            settings.setParams(infos);
        } else {
            settings.setMethod(false);
        }
        return settings;
    }

    public static DynamicElementSettings createSettings(GrArgumentLabel label, PsiClass targetClass) {
        DynamicElementSettings settings = new DynamicElementSettings();
        assert (targetClass != null);
        String className = targetClass.getQualifiedName();
        className = className == null ? targetClass.getContainingFile().getName() : className;
        settings.setContainingClassName(className);
        settings.setName(label.getName());
        return settings;
    }

    @NotNull
    public static List<IntentionAction> fixesToIntentions(@NotNull PsiElement highlightElement, LocalQuickFix @NotNull [] fixes) {
        if (highlightElement == null) {
            QuickfixUtil.$$$reportNull$$$0(0);
        }
        if (fixes == null) {
            QuickfixUtil.$$$reportNull$$$0(1);
        }
        InspectionManager inspectionManager = InspectionManager.getInstance((Project)highlightElement.getProject());
        ProblemDescriptor descriptor2 = inspectionManager.createProblemDescriptor(highlightElement, highlightElement, "", ProblemHighlightType.INFORMATION, true, LocalQuickFix.EMPTY_ARRAY);
        List list = ContainerUtil.map((Object[])fixes, it -> new LocalQuickFixAsIntentionAdapter(it, descriptor2));
        if (list == null) {
            QuickfixUtil.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static @NotNull LocalQuickFix @NotNull [] intentionsToFixes(@NotNull PsiElement highlightElement, @NotNull List<? extends IntentionAction> actions) {
        if (highlightElement == null) {
            QuickfixUtil.$$$reportNull$$$0(3);
        }
        if (actions == null) {
            QuickfixUtil.$$$reportNull$$$0(4);
        }
        LocalQuickFix[] localQuickFixArray = IntentionWrapper.wrapToQuickFixes(actions, (PsiFile)highlightElement.getContainingFile()).toArray(LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            QuickfixUtil.$$$reportNull$$$0(5);
        }
        return localQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/intentions/QuickfixUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/QuickfixUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "fixesToIntentions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "intentionsToFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fixesToIntentions";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "intentionsToFixes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }
}

