/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsLoweredDeclarationOrigin;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsManglerIr;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTable;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u0016\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\t\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u001b\u0010\n\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\u0005\u001a\u0002H\u000bH\u0002\u00a2\u0006\u0002\u0010\f\u001a\u0018\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a\u0010\u0010\u0011\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00130\u0012\u001a\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0006H\u0002\u001a\u001a\u0010\u0016\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a&\u0010\u0019\u001a\u00020\u001a*\u00020\u001a2\u0017\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00100\u001c\u00a2\u0006\u0002\b\u001dH\u0082\b\u001a\f\u0010\u001e\u001a\u0004\u0018\u00010\u0001*\u00020\u001f\u001a\n\u0010 \u001a\u00020\u0001*\u00020!\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"RESERVED_MEMBER_NAME_SUFFIX", "", "SYNTHETIC_BLOCK_LABEL", "SYNTHETIC_LOOP_LABEL", "calculateJsFunctionSignature", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "jsFunctionSignature", "mapToKey", "T", "(Ljava/lang/Object;)Ljava/lang/String;", "sanitizeName", "name", "withHash", "", "dump", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "findOriginallyContainingModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "joinTypes", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "mangleIfNot", "", "predicate", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "nameIfPropertyAccessor", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "toJsIdentifier", "", "backend.js"})
@SourceDebugExtension(value={"SMAP\nNameTables.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NameTables.kt\norg/jetbrains/kotlin/ir/backend/js/utils/NameTablesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,328:1\n324#1:334\n324#1:335\n1#2:329\n188#3:330\n188#3:333\n1855#4,2:331\n*S KotlinDebug\n*F\n+ 1 NameTables.kt\norg/jetbrains/kotlin/ir/backend/js/utils/NameTablesKt\n*L\n283#1:334\n287#1:335\n150#1:330\n160#1:333\n152#1:331,2\n*E\n"})
public final class NameTablesKt {
    @NotNull
    private static final String RESERVED_MEMBER_NAME_SUFFIX = "_k$";
    @NotNull
    private static final String SYNTHETIC_LOOP_LABEL = "$l$loop";
    @NotNull
    private static final String SYNTHETIC_BLOCK_LABEL = "$l$block";

    /*
     * WARNING - void declaration
     */
    private static final <T> String mapToKey(T declaration) {
        String string2;
        JsManglerIr $this$mapToKey_u24lambda_u241 = JsManglerIr.INSTANCE;
        boolean bl = false;
        if (declaration instanceof IrDeclaration) {
            String string3;
            try {
                string3 = String.valueOf($this$mapToKey_u24lambda_u241.hashedMangle(declaration, false));
            }
            catch (Throwable e) {
                string3 = "wrong_key";
            }
            string2 = string3;
        } else if (declaration instanceof String) {
            string2 = String.valueOf($this$mapToKey_u24lambda_u241.getHashMangle((String)declaration));
        } else {
            String string4;
            StringBuilder stringBuilder2 = new StringBuilder().append("Key is not generated for ");
            T t = declaration;
            if (t != null) {
                void it;
                T e = t;
                StringBuilder stringBuilder3 = stringBuilder2;
                boolean bl2 = false;
                string4 = Reflection.getOrCreateKotlinClass(it.getClass()).getSimpleName();
                stringBuilder2 = stringBuilder3;
            } else {
                string4 = null;
            }
            String string5 = stringBuilder2.append(string4).toString();
            throw new IllegalStateException(string5.toString());
        }
        return string2;
    }

    @NotNull
    public static final String dump(@NotNull NameTable<IrDeclaration> $this$dump) {
        Intrinsics.checkNotNullParameter($this$dump, (String)"<this>");
        return "Names: \n" + CollectionsKt.joinToString$default((Iterable)MapsKt.toList($this$dump.getNames()), (CharSequence)"\n", null, null, (int)0, null, (Function1)dump.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public static final String toJsIdentifier(int $this$toJsIdentifier) {
        String string2;
        String first = String.valueOf((char)(97 + $this$toJsIdentifier % 26));
        int other = $this$toJsIdentifier / 26;
        if (other == 0) {
            string2 = first;
        } else {
            StringBuilder stringBuilder2 = new StringBuilder().append(first);
            String string3 = Integer.toString(other, CharsKt.checkRadix((int)36));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            string2 = stringBuilder2.append(string3).toString();
        }
        return string2;
    }

    private static final String joinTypes(List<? extends IrType> $this$joinTypes, JsIrBackendContext context) {
        if ($this$joinTypes.isEmpty()) {
            return "";
        }
        return CollectionsKt.joinToString$default((Iterable)$this$joinTypes, (CharSequence)"$", (CharSequence)"$", null, (int)0, null, (Function1)((Function1)new Function1<IrType, CharSequence>(context){
            final /* synthetic */ JsIrBackendContext $context;
            {
                this.$context = $context;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull IrType superType) {
                Intrinsics.checkNotNullParameter((Object)superType, (String)"superType");
                return IrTypeUtilsKt.asString(superType, this.$context);
            }
        }), (int)28, null);
    }

    private static final IrModuleFragment findOriginallyContainingModule(IrFunction $this$findOriginallyContainingModule) {
        if (JsLoweredDeclarationOrigin.INSTANCE.isBridgeDeclarationOrigin($this$findOriginallyContainingModule.getOrigin())) {
            IrSimpleFunction irSimpleFunction = $this$findOriginallyContainingModule instanceof IrSimpleFunction ? (IrSimpleFunction)$this$findOriginallyContainingModule : null;
            if (irSimpleFunction == null) {
                throw new IllegalStateException("Bridge must be IrSimpleFunction".toString());
            }
            IrSimpleFunction thisSimpleFunction = irSimpleFunction;
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)CollectionsKt.firstOrNull((List)thisSimpleFunction.getOverriddenSymbols());
            if (irSimpleFunctionSymbol == null) {
                throw new IllegalStateException("Couldn't find the overridden function for the bridge".toString());
            }
            IrSimpleFunctionSymbol bridgeFrom = irSimpleFunctionSymbol;
            return NameTablesKt.findOriginallyContainingModule(bridgeFrom.getOwner());
        }
        IrPackageFragment irPackageFragment = IrUtilsKt.getPackageFragment((IrDeclaration)((IrDeclaration)$this$findOriginallyContainingModule));
        IrFile irFile = irPackageFragment instanceof IrFile ? (IrFile)irPackageFragment : null;
        return irFile != null ? irFile.getModule() : null;
    }

    @NotNull
    public static final String calculateJsFunctionSignature(@NotNull IrFunction declaration, @NotNull JsIrBackendContext context) {
        IrModuleFragment containingModule;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string2 = NameTablesKt.nameIfPropertyAccessor((IrDeclarationWithName)declaration);
        if (string2 == null) {
            String string3 = AnnotationUtilsKt.getJsNameOrKotlinName((IrDeclarationWithName)declaration).asString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
        }
        String declarationName = string2;
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(declarationName);
        if (declaration.getVisibility() == DescriptorVisibilities.INTERNAL && IrUtilsKt.getParentClassOrNull((IrDeclaration)((IrDeclaration)declaration)) != null && (containingModule = NameTablesKt.findOriginallyContainingModule(declaration)) != null) {
            nameBuilder.append("_$m_").append(containingModule.getName().toString());
        }
        Collection $this$ifNotEmpty$iv = declaration.getTypeParameters();
        boolean $i$f$ifNotEmpty = false;
        if (!$this$ifNotEmpty$iv.isEmpty()) {
            List $this$calculateJsFunctionSignature_u24lambda_u243 = (List)$this$ifNotEmpty$iv;
            boolean bl = false;
            nameBuilder.append("_$t");
            Iterable $this$forEach$iv = $this$calculateJsFunctionSignature_u24lambda_u243;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrTypeParameter typeParam = (IrTypeParameter)element$iv;
                boolean bl2 = false;
                nameBuilder.append("_").append(typeParam.getName().asString()).append(NameTablesKt.joinTypes(typeParam.getSuperTypes(), context));
            }
        }
        IrValueParameter irValueParameter = declaration.getExtensionReceiverParameter();
        if (irValueParameter != null) {
            IrValueParameter it = irValueParameter;
            boolean bl = false;
            String superTypes2 = NameTablesKt.joinTypes(org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.superTypes((IrType)it.getType()), context);
            nameBuilder.append("_r$" + IrTypeUtilsKt.asString(it.getType(), context) + superTypes2);
        }
        $this$ifNotEmpty$iv = declaration.getValueParameters();
        $i$f$ifNotEmpty = false;
        if (!$this$ifNotEmpty$iv.isEmpty()) {
            List $this$calculateJsFunctionSignature_u24lambda_u245 = (List)$this$ifNotEmpty$iv;
            boolean bl = false;
            StringBuilder cfr_ignored_0 = (StringBuilder)CollectionsKt.joinTo$default((Iterable)$this$calculateJsFunctionSignature_u24lambda_u245, (Appendable)nameBuilder, (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<IrValueParameter, CharSequence>(context){
                final /* synthetic */ JsIrBackendContext $context;
                {
                    this.$context = $context;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull IrValueParameter it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String defaultValueSign = Intrinsics.areEqual((Object)it.getOrigin(), (Object)((Object)JsLoweredDeclarationOrigin.JS_SHADOWED_DEFAULT_PARAMETER.INSTANCE)) ? "?" : "";
                    String superTypes2 = NameTablesKt.access$joinTypes(org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.superTypes((IrType)it.getType()), this.$context);
                    return '_' + IrTypeUtilsKt.asString(it.getType(), this.$context) + superTypes2 + defaultValueSign;
                }
            }), (int)60, null);
        }
        IrType it = declaration.getReturnType();
        boolean bl = false;
        if (context.getInlineClassesUtils().isTypeInlined(it) || IrTypePredicatesKt.isUnit((IrType)it)) {
            nameBuilder.append("_ret$" + IrTypeUtilsKt.asString(it, context));
        }
        String string4 = Integer.toString(Math.abs(nameBuilder.toString().hashCode()), CharsKt.checkRadix((int)36));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        String signature2 = string4;
        String sanitizedName = NameTablesKt.sanitizeName(declarationName, false);
        return context.getGlobalInternationService().string(sanitizedName + '_' + signature2 + RESERVED_MEMBER_NAME_SUFFIX);
    }

    @NotNull
    public static final String jsFunctionSignature(@NotNull IrFunction declaration, @NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(!IrDeclarationsKt.isStaticMethodOfClass((IrFunction)declaration))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!(declaration.getDispatchReceiverParameter() != null)) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        if (MiscKt.hasStableJsName(declaration, context)) {
            String string4 = AnnotationUtilsKt.getJsNameOrKotlinName((IrDeclarationWithName)declaration).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"asString(...)");
            String declarationName = string4;
            if (!(!StringsKt.endsWith$default((String)declarationName, (String)RESERVED_MEMBER_NAME_SUFFIX, (boolean)false, (int)2, null))) {
                boolean bl = false;
                String string5 = "Function " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration)) + " uses reserved name suffix \"_k$\"";
                throw new IllegalArgumentException(string5.toString());
            }
            return declarationName;
        }
        IrSimpleFunction irSimpleFunction = declaration instanceof IrSimpleFunction ? (IrSimpleFunction)declaration : null;
        IrFunction declarationSignature = irSimpleFunction != null && (irSimpleFunction = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverride$default((IrOverridableDeclaration)((IrOverridableDeclaration)irSimpleFunction), (boolean)false, null, (int)3, null)) != null ? (IrFunction)irSimpleFunction : declaration;
        return NameTablesKt.calculateJsFunctionSignature(declarationSignature, context);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String sanitizeName(@NotNull String name2, boolean withHash) {
        String string2;
        void p0;
        char first;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (IdentifierPolicyKt.isValidES5Identifier(name2)) {
            return name2;
        }
        if (((CharSequence)name2).length() == 0) {
            return "_";
        }
        StringBuilder builder2 = new StringBuilder(name2.length() + (withHash ? 7 : 0));
        char $this$mangleIfNot$iv = first = StringsKt.first((CharSequence)name2);
        boolean $i$f$mangleIfNot = false;
        char c = $this$mangleIfNot$iv;
        StringBuilder stringBuilder2 = builder2;
        boolean bl = false;
        boolean bl2 = IdentifierPolicyKt.isES5IdentifierStart((char)p0);
        stringBuilder2.append(bl2 ? $this$mangleIfNot$iv : (char)'_');
        int idx = 1;
        int n = StringsKt.getLastIndex((CharSequence)name2);
        if (idx <= n) {
            while (true) {
                void p02;
                char c2;
                char $this$mangleIfNot$iv2 = c2 = name2.charAt(idx);
                boolean $i$f$mangleIfNot2 = false;
                char c3 = $this$mangleIfNot$iv2;
                stringBuilder2 = builder2;
                boolean bl3 = false;
                bl2 = IdentifierPolicyKt.isES5IdentifierPart((char)p02);
                stringBuilder2.append(bl2 ? $this$mangleIfNot$iv2 : (char)'_');
                if (idx == n) break;
                ++idx;
            }
        }
        if (withHash) {
            StringBuilder stringBuilder3 = new StringBuilder().append((Object)builder2).append('_');
            String string3 = Integer.toString(Math.abs(name2.hashCode()), CharsKt.checkRadix((int)36));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            string2 = stringBuilder3.append(string3).toString();
        } else {
            String string4 = builder2.toString();
            Intrinsics.checkNotNull((Object)string4);
            string2 = string4;
        }
        return string2;
    }

    public static /* synthetic */ String sanitizeName$default(String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return NameTablesKt.sanitizeName(string2, bl);
    }

    @Nullable
    public static final String nameIfPropertyAccessor(@NotNull IrDeclarationWithName $this$nameIfPropertyAccessor) {
        Intrinsics.checkNotNullParameter((Object)$this$nameIfPropertyAccessor, (String)"<this>");
        if ($this$nameIfPropertyAccessor instanceof IrSimpleFunction) {
            String string2;
            if (((IrSimpleFunction)$this$nameIfPropertyAccessor).getCorrespondingPropertySymbol() != null) {
                String string3;
                IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)$this$nameIfPropertyAccessor).getCorrespondingPropertySymbol();
                Intrinsics.checkNotNull((Object)irPropertySymbol);
                IrProperty property = (IrProperty)irPropertySymbol.getOwner();
                String string4 = AnnotationUtilsKt.getJsNameOrKotlinName((IrDeclarationWithName)property).asString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"asString(...)");
                String name2 = string4;
                IrDeclarationWithName irDeclarationWithName = $this$nameIfPropertyAccessor;
                if (Intrinsics.areEqual((Object)irDeclarationWithName, (Object)property.getGetter())) {
                    string3 = "get_";
                } else if (Intrinsics.areEqual((Object)irDeclarationWithName, (Object)property.getSetter())) {
                    string3 = "set_";
                } else {
                    throw new IllegalStateException("".toString());
                }
                String prefix = string3;
                string2 = prefix + name2;
            } else if (Intrinsics.areEqual((Object)$this$nameIfPropertyAccessor.getOrigin(), (Object)((Object)JsLoweredDeclarationOrigin.BRIDGE_PROPERTY_ACCESSOR.INSTANCE))) {
                String string5 = AnnotationUtilsKt.getJsNameOrKotlinName($this$nameIfPropertyAccessor).asString();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"asString(...)");
                string2 = StringsKt.replaceFirst$default((String)StringsKt.replaceFirst$default((String)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string5, (CharSequence)"<"), (CharSequence)">"), (String)"get-", (String)"get_", (boolean)false, (int)4, null), (String)"set-", (String)"set_", (boolean)false, (int)4, null);
            } else {
                string2 = null;
            }
            return string2;
        }
        return null;
    }

    private static final char mangleIfNot(char $this$mangleIfNot, Function1<? super Character, Boolean> predicate) {
        boolean $i$f$mangleIfNot = false;
        return (Boolean)predicate.invoke((Object)Character.valueOf($this$mangleIfNot)) != false ? $this$mangleIfNot : (char)'_';
    }

    public static final /* synthetic */ String access$mapToKey(Object declaration) {
        return NameTablesKt.mapToKey(declaration);
    }

    public static final /* synthetic */ String access$joinTypes(List $receiver, JsIrBackendContext context) {
        return NameTablesKt.joinTypes($receiver, context);
    }
}

