/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.utils.SmartList;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u0004*\u000e\b\u0002\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00010\u00062\u00020\u0007B\u001d\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\rJ\u0019\u0010'\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00060\u000f\u00a2\u0006\u0002\u0010(JE\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u00028\u00022\u0006\u00101\u001a\u00028\u00022\u0006\u00102\u001a\u00028\u0002H$\u00a2\u0006\u0002\u00103J\b\u00104\u001a\u00020*H\u0002J\b\u00105\u001a\u00020*H\u0014J\b\u00106\u001a\u00020*H\u0002J\u0010\u00107\u001a\u00020*2\u0006\u00108\u001a\u00020\u0013H\u0002J\u0010\u00109\u001a\u00020*2\u0006\u0010:\u001a\u00020\u000bH\u0002J\u0010\u0010;\u001a\u00020*2\u0006\u00108\u001a\u00020\u0013H\u0002J\u0017\u0010<\u001a\u0004\u0018\u00018\u00022\u0006\u0010=\u001a\u00020\u001dH\u0004\u00a2\u0006\u0002\u0010>J\u0017\u0010<\u001a\u0004\u0018\u00018\u00022\u0006\u0010?\u001a\u00020,H\u0004\u00a2\u0006\u0002\u0010@J\u0015\u0010A\u001a\u00020*2\u0006\u00101\u001a\u00028\u0002H\u0002\u00a2\u0006\u0002\u0010BJ'\u0010C\u001a\u00020*2\u0006\u0010D\u001a\u00020\u001d2\u0006\u0010E\u001a\u00028\u00022\b\b\u0002\u0010F\u001a\u00020GH$\u00a2\u0006\u0002\u0010HJ\u001d\u0010I\u001a\u00028\u00022\u0006\u0010J\u001a\u00020\u001d2\u0006\u0010K\u001a\u00020\u001dH$\u00a2\u0006\u0002\u0010LJ\u001d\u0010M\u001a\u00020*2\u0006\u0010=\u001a\u00020\u001d2\u0006\u0010I\u001a\u00028\u0002H\u0004\u00a2\u0006\u0002\u0010NJ\u0018\u0010O\u001a\u00020*2\u0006\u0010P\u001a\u00020G2\u0006\u0010D\u001a\u00020\u001dH\u0004J\b\u0010Q\u001a\u00020GH\u0014J-\u0010R\u001a\u00020*2\u0006\u0010+\u001a\u00020S2\u0006\u00101\u001a\u00028\u00022\u0006\u0010?\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u001dH$\u00a2\u0006\u0002\u0010TJ\u001d\u0010U\u001a\u00020*2\u0006\u0010+\u001a\u00020V2\u0006\u00101\u001a\u00028\u0002H$\u00a2\u0006\u0002\u0010WJ5\u0010X\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u001d2\u0006\u00101\u001a\u00028\u00022\u0006\u0010?\u001a\u00020\u001dH\u0004\u00a2\u0006\u0002\u0010YJ%\u0010Z\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u00101\u001a\u00028\u00022\u0006\u0010?\u001a\u00020\u001dH$\u00a2\u0006\u0002\u0010[J\u001d\u0010\\\u001a\u00020*2\u0006\u0010+\u001a\u00020]2\u0006\u00101\u001a\u00028\u0002H$\u00a2\u0006\u0002\u0010^J\u0011\u0010_\u001a\u00020\t*\u00028\u0002H\u0004\u00a2\u0006\u0002\u0010`J\f\u0010a\u001a\u00020\u001d*\u00020,H\u0004R\u001e\u0010\u000e\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00060\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R$\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00120\u000fX\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\f\u001a\u00028\u0001X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006b"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/common/FastAnalyzer;", "V", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "I", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;", "F", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "", "owner", "", "method", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "interpreter", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;Lorg/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;)V", "frames", "", "[Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "handlers", "", "Lorg/jetbrains/org/objectweb/asm/tree/TryCatchBlockNode;", "getHandlers", "()[Ljava/util/List;", "[Ljava/util/List;", "getInterpreter", "()Lorg/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;", "getMethod", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "nInsns", "", "getNInsns", "()I", "getOwner", "()Ljava/lang/String;", "queue", "", "queued", "", "top", "analyze", "()[Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "analyzeInstruction", "", "insnNode", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "insnIndex", "insnType", "insnOpcode", "currentlyAnalyzing", "current", "handler", "(Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;IIILorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;)V", "analyzeMainLoop", "beforeAnalyze", "checkAssertions", "computeExceptionHandlerFast", "tcb", "computeExceptionHandlers", "m", "computeExceptionHandlersForEachInsn", "getFrame", "index", "(I)Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "insn", "(Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;)Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "initLocals", "(Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;)V", "mergeControlFlowEdge", "dest", "frame", "canReuse", "", "(ILorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;Z)V", "newFrame", "nLocals", "nStack", "(II)Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "setFrame", "(ILorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;)V", "updateQueue", "changes", "useFastComputeExceptionHandlers", "visitJumpInsnNode", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "(Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;II)V", "visitLookupSwitchInsnNode", "Lorg/jetbrains/org/objectweb/asm/tree/LookupSwitchInsnNode;", "(Lorg/jetbrains/org/objectweb/asm/tree/LookupSwitchInsnNode;Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;)V", "visitMeaningfulInstruction", "(Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;IILorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;I)V", "visitOpInsn", "(Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;I)V", "visitTableSwitchInsnNode", "Lorg/jetbrains/org/objectweb/asm/tree/TableSwitchInsnNode;", "(Lorg/jetbrains/org/objectweb/asm/tree/TableSwitchInsnNode;Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;)V", "dump", "(Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;)Ljava/lang/String;", "indexOf", "backend"})
@SourceDebugExtension(value={"SMAP\nFastAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FastAnalyzer.kt\norg/jetbrains/kotlin/codegen/optimization/common/FastAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,222:1\n1747#2,3:223\n*S KotlinDebug\n*F\n+ 1 FastAnalyzer.kt\norg/jetbrains/kotlin/codegen/optimization/common/FastAnalyzer\n*L\n149#1:223,3\n*E\n"})
public abstract class FastAnalyzer<V extends Value, I extends Interpreter<V>, F extends Frame<V>> {
    @NotNull
    private final String owner;
    @NotNull
    private final MethodNode method;
    @NotNull
    private final I interpreter;
    private final int nInsns;
    @NotNull
    private final List<TryCatchBlockNode>[] handlers;
    @NotNull
    private final Frame<V>[] frames;
    @NotNull
    private final boolean[] queued;
    @NotNull
    private final int[] queue;
    private int top;

    public FastAnalyzer(@NotNull String owner, @NotNull MethodNode method, @NotNull I interpreter2) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(interpreter2, (String)"interpreter");
        this.owner = owner;
        this.method = method;
        this.interpreter = interpreter2;
        this.nInsns = this.method.instructions.size();
        this.handlers = new List[this.nInsns];
        this.frames = new Frame[this.nInsns];
        this.queued = new boolean[this.nInsns];
        this.queue = new int[this.nInsns];
    }

    @NotNull
    protected final String getOwner() {
        return this.owner;
    }

    @NotNull
    protected final MethodNode getMethod() {
        return this.method;
    }

    @NotNull
    protected final I getInterpreter() {
        return this.interpreter;
    }

    protected final int getNInsns() {
        return this.nInsns;
    }

    @NotNull
    protected final List<TryCatchBlockNode>[] getHandlers() {
        return this.handlers;
    }

    @NotNull
    public final Frame<V>[] analyze() {
        if (this.nInsns == 0) {
            return this.frames;
        }
        this.checkAssertions();
        this.computeExceptionHandlers(this.method);
        this.beforeAnalyze();
        this.analyzeMainLoop();
        return this.frames;
    }

    private final void analyzeMainLoop() {
        F current = this.newFrame(this.method.maxLocals, this.method.maxStack);
        F handler2 = this.newFrame(this.method.maxLocals, this.method.maxStack);
        this.initLocals(current);
        FastAnalyzer.mergeControlFlowEdge$default(this, 0, current, false, 4, null);
        while (this.top > 0) {
            this.top += -1;
            int insn = this.queue[this.top];
            Intrinsics.checkNotNull(this.getFrame(insn));
            this.queued[insn] = false;
            AbstractInsnNode insnNode = this.method.instructions.get(insn);
            int insnOpcode = insnNode.getOpcode();
            int insnType = insnNode.getType();
            try {
                F f;
                Intrinsics.checkNotNull((Object)insnNode);
                this.analyzeInstruction(insnNode, insn, insnType, insnOpcode, f, current, handler2);
            }
            catch (AnalyzerException e) {
                AbstractInsnNode abstractInsnNode = e.node;
                StringBuilder stringBuilder2 = new StringBuilder().append("Error at instruction #").append(insn).append(' ');
                InsnList insnList = this.method.instructions;
                Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
                throw new AnalyzerException(abstractInsnNode, stringBuilder2.append(InlineCodegenUtilsKt.insnText(insnNode, insnList)).append(": ").append(e.getMessage()).append("\ncurrent: ").append(this.dump(current)).toString(), (Throwable)e);
            }
            catch (Exception e) {
                StringBuilder stringBuilder3 = new StringBuilder().append("Error at instruction #").append(insn).append(' ');
                InsnList insnList = this.method.instructions;
                Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
                throw new AnalyzerException(insnNode, stringBuilder3.append(InlineCodegenUtilsKt.insnText(insnNode, insnList)).append(": ").append(e.getMessage()).append("\ncurrent: ").append(this.dump(current)).toString(), (Throwable)e);
            }
        }
    }

    protected void beforeAnalyze() {
    }

    private final void initLocals(F current) {
        boolean isInstanceMethod;
        current.setReturn(this.interpreter.newReturnTypeValue(Type.getReturnType((String)this.method.desc)));
        Type[] args = Type.getArgumentTypes((String)this.method.desc);
        int local = 0;
        boolean bl = isInstanceMethod = (this.method.access & 8) == 0;
        if (isInstanceMethod) {
            Type ctype = Type.getObjectType((String)this.owner);
            current.setLocal(local, this.interpreter.newParameterValue(true, local, ctype));
            ++local;
        }
        Intrinsics.checkNotNull((Object)args);
        for (Type arg : args) {
            current.setLocal(local, this.interpreter.newParameterValue(isInstanceMethod, local, arg));
            ++local;
            if (arg.getSize() != 2) continue;
            current.setLocal(local, this.interpreter.newEmptyValue(local));
            ++local;
        }
        while (local < this.method.maxLocals) {
            current.setLocal(local, this.interpreter.newEmptyValue(local));
            ++local;
        }
    }

    protected abstract void mergeControlFlowEdge(int var1, @NotNull F var2, boolean var3);

    public static /* synthetic */ void mergeControlFlowEdge$default(FastAnalyzer fastAnalyzer, int n, Frame frame, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: mergeControlFlowEdge");
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        fastAnalyzer.mergeControlFlowEdge(n, frame, bl);
    }

    protected abstract void analyzeInstruction(@NotNull AbstractInsnNode var1, int var2, int var3, int var4, @NotNull F var5, @NotNull F var6, @NotNull F var7);

    @NotNull
    protected abstract F newFrame(int var1, int var2);

    @Nullable
    protected final F getFrame(@NotNull AbstractInsnNode insn) {
        Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
        Frame<V> frame = this.frames[this.indexOf(insn)];
        return (F)(frame instanceof Frame ? frame : null);
    }

    @Nullable
    protected final F getFrame(int index2) {
        Frame<V> frame = this.frames[index2];
        return (F)(frame instanceof Frame ? frame : null);
    }

    protected final void setFrame(int index2, @NotNull F newFrame) {
        Intrinsics.checkNotNullParameter(newFrame, (String)"newFrame");
        this.frames[index2] = newFrame;
    }

    protected final void visitMeaningfulInstruction(@NotNull AbstractInsnNode insnNode, int insnType, int insnOpcode, @NotNull F current, int insn) {
        Intrinsics.checkNotNullParameter((Object)insnNode, (String)"insnNode");
        Intrinsics.checkNotNullParameter(current, (String)"current");
        if (insnType == 7) {
            this.visitJumpInsnNode((JumpInsnNode)insnNode, current, insn, insnOpcode);
        } else if (insnType == 12) {
            this.visitLookupSwitchInsnNode((LookupSwitchInsnNode)insnNode, current);
        } else if (insnType == 11) {
            this.visitTableSwitchInsnNode((TableSwitchInsnNode)insnNode, current);
        } else if (insnOpcode != 191 && (insnOpcode < 172 || insnOpcode > 177)) {
            this.visitOpInsn(insnNode, current, insn);
        }
    }

    protected abstract void visitJumpInsnNode(@NotNull JumpInsnNode var1, @NotNull F var2, int var3, int var4);

    protected abstract void visitLookupSwitchInsnNode(@NotNull LookupSwitchInsnNode var1, @NotNull F var2);

    protected abstract void visitTableSwitchInsnNode(@NotNull TableSwitchInsnNode var1, @NotNull F var2);

    protected abstract void visitOpInsn(@NotNull AbstractInsnNode var1, @NotNull F var2, int var3);

    private final void checkAssertions() {
        boolean bl;
        block4: {
            InsnList insnList = this.method.instructions;
            Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"instructions");
            Iterable $this$any$iv = (Iterable)insnList;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AbstractInsnNode it = (AbstractInsnNode)element$iv;
                    boolean bl2 = false;
                    if (!(it.getOpcode() == 168 || it.getOpcode() == 169)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new AssertionError((Object)"Subroutines are deprecated since Java 6");
        }
    }

    protected final int indexOf(@NotNull AbstractInsnNode $this$indexOf) {
        Intrinsics.checkNotNullParameter((Object)$this$indexOf, (String)"<this>");
        return this.method.instructions.indexOf($this$indexOf);
    }

    protected boolean useFastComputeExceptionHandlers() {
        return false;
    }

    private final void computeExceptionHandlers(MethodNode m) {
        for (TryCatchBlockNode tcb : m.tryCatchBlocks) {
            if (this.useFastComputeExceptionHandlers()) {
                Intrinsics.checkNotNull((Object)tcb);
                this.computeExceptionHandlerFast(tcb);
                continue;
            }
            Intrinsics.checkNotNull((Object)tcb);
            this.computeExceptionHandlersForEachInsn(tcb);
        }
    }

    private final void computeExceptionHandlersForEachInsn(TryCatchBlockNode tcb) {
        LabelNode labelNode = tcb.start;
        Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"start");
        AbstractInsnNode current = (AbstractInsnNode)labelNode;
        LabelNode end = tcb.end;
        while (!Intrinsics.areEqual((Object)current, (Object)end)) {
            if (UtilKt.isMeaningful(current)) {
                int currentIndex = this.indexOf(current);
                List insnHandlers = this.handlers[currentIndex];
                if (insnHandlers == null) {
                    this.handlers[currentIndex] = insnHandlers = (List)new SmartList();
                }
                insnHandlers.add((TryCatchBlockNode)tcb);
            }
            Intrinsics.checkNotNullExpressionValue((Object)current.getNext(), (String)"getNext(...)");
        }
    }

    private final void computeExceptionHandlerFast(TryCatchBlockNode tcb) {
        LabelNode labelNode = tcb.start;
        Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"start");
        int start = this.indexOf((AbstractInsnNode)labelNode);
        List insnHandlers = this.handlers[start];
        if (insnHandlers == null) {
            this.handlers[start] = insnHandlers = (List)new ArrayList();
        }
        insnHandlers.add((TryCatchBlockNode)tcb);
    }

    protected final void updateQueue(boolean changes, int dest) {
        if (changes && !this.queued[dest]) {
            this.queued[dest] = true;
            int n = this.top;
            this.top = n + 1;
            this.queue[n] = dest;
        }
    }

    @NotNull
    protected final String dump(@NotNull F $this$dump) {
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter($this$dump, (String)"<this>");
        StringBuilder $this$dump_u24lambda_u241 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        $this$dump_u24lambda_u241.append("{\n");
        $this$dump_u24lambda_u241.append("  locals: [\n");
        int n = this.method.maxLocals;
        for (int i = 0; i < n; ++i) {
            $this$dump_u24lambda_u241.append("    #" + i + ": " + $this$dump.getLocal(i) + '\n');
        }
        $this$dump_u24lambda_u241.append("  ]\n");
        int stackSize = $this$dump.getStackSize();
        $this$dump_u24lambda_u241.append("  stack: size=");
        $this$dump_u24lambda_u241.append(stackSize);
        if (stackSize == 0) {
            $this$dump_u24lambda_u241.append(" []\n");
        } else {
            $this$dump_u24lambda_u241.append(" [\n");
            for (int i = 0; i < stackSize; ++i) {
                $this$dump_u24lambda_u241.append("    #" + i + ": " + $this$dump.getStack(i) + '\n');
            }
            $this$dump_u24lambda_u241.append("  ]\n");
        }
        $this$dump_u24lambda_u241.append("}\n");
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }
}

