/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.NodeBuilder;
import org.jetbrains.jps.dependency.Usage;
import org.jetbrains.jps.dependency.java.AnnotationUsage;
import org.jetbrains.jps.dependency.java.ClassAsGenericBoundUsage;
import org.jetbrains.jps.dependency.java.ClassNewUsage;
import org.jetbrains.jps.dependency.java.ClassUsage;
import org.jetbrains.jps.dependency.java.ElemType;
import org.jetbrains.jps.dependency.java.FieldAssignUsage;
import org.jetbrains.jps.dependency.java.FieldUsage;
import org.jetbrains.jps.dependency.java.JVMClassNode;
import org.jetbrains.jps.dependency.java.JVMFlags;
import org.jetbrains.jps.dependency.java.JvmClass;
import org.jetbrains.jps.dependency.java.JvmField;
import org.jetbrains.jps.dependency.java.JvmMethod;
import org.jetbrains.jps.dependency.java.JvmModule;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.MethodUsage;
import org.jetbrains.jps.dependency.java.ModulePackage;
import org.jetbrains.jps.dependency.java.ModuleRequires;
import org.jetbrains.jps.dependency.java.ParamAnnotation;
import org.jetbrains.jps.dependency.java.Proto;
import org.jetbrains.jps.dependency.java.TypeRepr;
import org.jetbrains.jps.javac.Iterators;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.ModuleVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.signature.SignatureReader;
import org.jetbrains.org.objectweb.asm.signature.SignatureVisitor;

public final class JvmClassNodeBuilder
extends ClassVisitor
implements NodeBuilder {
    private static final Logger LOG = Logger.getInstance(JvmClassNodeBuilder.class);
    public static final String LAMBDA_FACTORY_CLASS = "java/lang/invoke/LambdaMetafactory";
    private static final String KOTLIN_LAMBDA_USAGE_CLASS_MARKER = "$sam$";
    private static final int ASM_API_VERSION = 589824;
    private final SignatureVisitor mySignatureCrawler = new BaseSignatureVisitor(){

        @Override
        public SignatureVisitor visitClassBound() {
            return JvmClassNodeBuilder.this.mySignatureWithGenericBoundUsageCrawler;
        }

        @Override
        public SignatureVisitor visitInterfaceBound() {
            return JvmClassNodeBuilder.this.mySignatureWithGenericBoundUsageCrawler;
        }

        @Override
        public SignatureVisitor visitTypeArgument(char wildcard) {
            return wildcard == '+' || wildcard == '-' ? JvmClassNodeBuilder.this.mySignatureWithGenericBoundUsageCrawler : super.visitTypeArgument(wildcard);
        }
    };
    private final SignatureVisitor mySignatureWithGenericBoundUsageCrawler = new BaseSignatureVisitor(){

        @Override
        public void visitClassType(String name) {
            super.visitClassType(name);
            JvmClassNodeBuilder.this.addUsage(new ClassAsGenericBoundUsage(name));
        }
    };
    private boolean myIsModule = false;
    private final String myFileName;
    private final boolean myIsGenerated;
    private int myAccess;
    private String myName;
    private String myVersion;
    private String mySuperClass;
    private Iterable<String> myInterfaces;
    private String mySignature;
    private final Ref<String> myClassNameHolder = Ref.create();
    private final Ref<String> myOuterClassName = Ref.create();
    private final Ref<Boolean> myLocalClassFlag = Ref.create((Object)false);
    private final Ref<Boolean> myAnonymousClassFlag = Ref.create((Object)false);
    private final Set<JvmMethod> myMethods = new HashSet<JvmMethod>();
    private final Set<JvmField> myFields = new HashSet<JvmField>();
    private final Set<Usage> myUsages = new HashSet<Usage>();
    private final Set<ElemType> myTargets = EnumSet.noneOf(ElemType.class);
    private RetentionPolicy myRetentionPolicy = null;
    private final Map<TypeRepr.ClassType, Set<String>> myAnnotationArguments = new HashMap<TypeRepr.ClassType, Set<String>>();
    private final Map<TypeRepr.ClassType, Set<ElemType>> myAnnotationTargets = new HashMap<TypeRepr.ClassType, Set<ElemType>>();
    private final Set<TypeRepr.ClassType> myAnnotations = new HashSet<TypeRepr.ClassType>();
    private final Set<ModuleRequires> myModuleRequires = new HashSet<ModuleRequires>();
    private final Set<ModulePackage> myModuleExports = new HashSet<ModulePackage>();

    private void processSignature(String sig) {
        if (sig != null) {
            try {
                new SignatureReader(sig).accept(this.mySignatureCrawler);
            }
            catch (Exception e) {
                LOG.info("Problems parsing signature \"" + sig + "\" in " + this.myFileName, (Throwable)e);
            }
        }
    }

    private JvmClassNodeBuilder(String fn, boolean isGenerated) {
        super(589824);
        this.myFileName = fn;
        this.myIsGenerated = isGenerated;
    }

    public static JvmClassNodeBuilder create(String filePath, ClassReader cr, boolean isGenerated) {
        JvmClassNodeBuilder builder = new JvmClassNodeBuilder(filePath, isGenerated);
        try {
            cr.accept((ClassVisitor)builder, 6);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Corrupted .class file: " + filePath, e);
        }
        return builder;
    }

    @Override
    @NotNull
    public JvmNodeReferenceID getReferenceID() {
        return new JvmNodeReferenceID(this.myName);
    }

    @Override
    public void addUsage(Usage usage) {
        this.myUsages.add(usage);
    }

    public JVMClassNode<? extends JVMClassNode<?, ?>, ? extends Proto.Diff<? extends JVMClassNode<?, ?>>> getResult() {
        JVMFlags flags = new JVMFlags(this.myAccess);
        if (((Boolean)this.myLocalClassFlag.get()).booleanValue()) {
            flags = flags.deriveIsLocal();
        }
        if (((Boolean)this.myAnonymousClassFlag.get()).booleanValue()) {
            flags = flags.deriveIsAnonymous();
        }
        if (this.myIsGenerated) {
            flags = flags.deriveIsGenerated();
        }
        if (this.myIsModule) {
            return new JvmModule(flags, this.myName, this.myFileName, this.myVersion, this.myModuleRequires, this.myModuleExports, this.myUsages);
        }
        return new JvmClass(flags, this.mySignature, this.myName, this.myFileName, this.mySuperClass, (String)this.myOuterClassName.get(), this.myInterfaces, this.myFields, this.myMethods, this.myAnnotations, this.myTargets, this.myRetentionPolicy, this.myUsages);
    }

    public void visit(int version, int access, String name, String sig, String superName, String[] interfaces) {
        this.myAccess = access;
        this.myName = name;
        this.myVersion = String.valueOf(version);
        this.mySignature = sig;
        this.mySuperClass = superName;
        this.myInterfaces = Iterators.asIterable((Object[])interfaces);
        this.myClassNameHolder.set((Object)name);
        if (this.mySuperClass != null && !"java/lang/Object".equals(this.mySuperClass)) {
            this.addUsage(new ClassUsage(this.mySuperClass));
        }
        for (String ifaceName : this.myInterfaces) {
            this.addUsage(new ClassUsage(ifaceName));
        }
        this.processSignature(sig);
    }

    public void visitEnd() {
        for (Map.Entry<TypeRepr.ClassType, Set<ElemType>> entry : this.myAnnotationTargets.entrySet()) {
            TypeRepr.ClassType type = entry.getKey();
            Set<ElemType> targets = entry.getValue();
            Set<String> usedArguments = this.myAnnotationArguments.get(type);
            this.addUsage(new AnnotationUsage(type, usedArguments != null ? usedArguments : Collections.emptyList(), targets));
        }
    }

    public ModuleVisitor visitModule(String name, int access, String version) {
        this.myIsModule = true;
        this.myAccess = access;
        this.myName = name;
        this.myVersion = version;
        return new ModuleCrawler();
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (desc.equals("Ljava/lang/annotation/Target;")) {
            return new AnnotationTargetCrawler();
        }
        if (desc.equals("Ljava/lang/annotation/Retention;")) {
            return new AnnotationRetentionPolicyCrawler();
        }
        TypeRepr.ClassType annotationType = (TypeRepr.ClassType)TypeRepr.getType(desc);
        this.myAnnotations.add(annotationType);
        return new AnnotationCrawler(annotationType, (this.myAccess & 0x2000) > 0 ? ElemType.ANNOTATION_TYPE : ElemType.TYPE);
    }

    public void visitSource(String source, String debug) {
    }

    public FieldVisitor visitField(final int access, final String name, final String desc, final String signature, final Object value) {
        this.processSignature(signature);
        return new FieldVisitor(589824){
            final Set<TypeRepr.ClassType> annotations;
            {
                super(arg0);
                this.annotations = new HashSet<TypeRepr.ClassType>();
            }

            public AnnotationVisitor visitAnnotation(String desc2, boolean visible) {
                TypeRepr.ClassType annotation = (TypeRepr.ClassType)TypeRepr.getType(desc2);
                this.annotations.add(annotation);
                return new AnnotationCrawler(annotation, ElemType.FIELD);
            }

            public void visitEnd() {
                try {
                    super.visitEnd();
                }
                finally {
                    if ((access & 0x1000) == 0) {
                        JvmClassNodeBuilder.this.myFields.add(new JvmField(new JVMFlags(access), signature, name, desc, this.annotations, value));
                    }
                }
            }
        };
    }

    public MethodVisitor visitMethod(final int access, final String n, final String desc, final String signature, final String[] exceptions) {
        final Ref defaultValue = Ref.create();
        final HashSet annotations = new HashSet();
        final HashSet paramAnnotations = new HashSet();
        this.processSignature(signature);
        return new MethodVisitor(589824){

            public void visitEnd() {
                if ((access & 0x1000) == 0 || (access & 0x40) > 0) {
                    JvmClassNodeBuilder.this.myMethods.add(new JvmMethod(new JVMFlags(access), signature, n, desc, annotations, paramAnnotations, exceptions, defaultValue.get()));
                }
            }

            public AnnotationVisitor visitAnnotation(String desc2, boolean visible) {
                TypeRepr.ClassType annoType = (TypeRepr.ClassType)TypeRepr.getType(desc2);
                annotations.add(annoType);
                return new AnnotationCrawler(annoType, "<init>".equals(n) ? ElemType.CONSTRUCTOR : ElemType.METHOD);
            }

            public AnnotationVisitor visitAnnotationDefault() {
                return new AnnotationVisitor(589824){
                    @Nullable
                    private List<Object> myAcc;

                    public void visit(String name, Object value) {
                        this.collectValue(value);
                    }

                    public void visitEnum(String name, String desc, String value) {
                        this.collectValue(value);
                    }

                    public AnnotationVisitor visitArray(String name) {
                        this.myAcc = new SmartList();
                        return this;
                    }

                    public void visitEnd() {
                        if (this.myAcc != null) {
                            Object elem;
                            Object[] template = null;
                            if (!this.myAcc.isEmpty() && (elem = this.myAcc.get(0)) != null) {
                                template = ArrayUtil.newArray(elem.getClass(), (int)0);
                            }
                            defaultValue.set((Object)(template != null ? this.myAcc.toArray(template) : this.myAcc.toArray()));
                        }
                    }

                    private void collectValue(Object value) {
                        if (this.myAcc != null) {
                            this.myAcc.add(value);
                        } else {
                            defaultValue.set(value);
                        }
                    }
                };
            }

            public AnnotationVisitor visitParameterAnnotation(int parameter, String desc2, boolean visible) {
                TypeRepr.ClassType annoType = (TypeRepr.ClassType)TypeRepr.getType(desc2);
                paramAnnotations.add(new ParamAnnotation(parameter, annoType));
                return new AnnotationCrawler(annoType, ElemType.PARAMETER);
            }

            public void visitLdcInsn(Object cst) {
                if (cst instanceof Type) {
                    JvmClassNodeBuilder.this.addUsage(new ClassUsage(((Type)cst).getInternalName()));
                }
                super.visitLdcInsn(cst);
            }

            public void visitMultiANewArrayInsn(String desc2, int dims) {
                TypeRepr.ArrayType typ = (TypeRepr.ArrayType)TypeRepr.getType(desc2);
                Iterators.collect(typ.getUsages(), JvmClassNodeBuilder.this.myUsages);
                TypeRepr element = typ.getDeepElementType();
                if (element instanceof TypeRepr.ClassType) {
                    JvmClassNodeBuilder.this.addUsage(new ClassNewUsage(((TypeRepr.ClassType)element).getJvmName()));
                }
                super.visitMultiANewArrayInsn(desc2, dims);
            }

            public void visitLocalVariable(String n2, String desc2, String signature2, Label start, Label end, int index) {
                JvmClassNodeBuilder.this.processSignature(signature2);
                Iterators.collect(TypeRepr.getType(desc2).getUsages(), JvmClassNodeBuilder.this.myUsages);
                super.visitLocalVariable(n2, desc2, signature2, start, end, index);
            }

            public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                if (type != null) {
                    Iterators.collect(new TypeRepr.ClassType(type).getUsages(), JvmClassNodeBuilder.this.myUsages);
                }
                super.visitTryCatchBlock(start, end, handler, type);
            }

            public void visitTypeInsn(int opcode, String type) {
                TypeRepr typ;
                TypeRepr typeRepr = typ = type.startsWith("[") ? TypeRepr.getType(type) : new TypeRepr.ClassType(type);
                if (opcode == 187) {
                    int ifNameStart;
                    int ifNameEnd;
                    JvmClassNodeBuilder.this.addUsage(new ClassUsage(((TypeRepr.ClassType)typ).getJvmName()));
                    JvmClassNodeBuilder.this.addUsage(new ClassNewUsage(((TypeRepr.ClassType)typ).getJvmName()));
                    int ktLambdaMarker = type.indexOf(JvmClassNodeBuilder.KOTLIN_LAMBDA_USAGE_CLASS_MARKER);
                    if (ktLambdaMarker > 0 && (ifNameEnd = type.indexOf("$", ifNameStart = ktLambdaMarker + JvmClassNodeBuilder.KOTLIN_LAMBDA_USAGE_CLASS_MARKER.length())) > ifNameStart) {
                        JvmClassNodeBuilder.this.addUsage(new ClassNewUsage(type.substring(ifNameStart, ifNameEnd).replace('_', '/')));
                    }
                } else if (opcode == 189 && typ instanceof TypeRepr.ClassType) {
                    JvmClassNodeBuilder.this.addUsage(new ClassUsage(((TypeRepr.ClassType)typ).getJvmName()));
                    JvmClassNodeBuilder.this.addUsage(new ClassNewUsage(((TypeRepr.ClassType)typ).getJvmName()));
                }
                Iterators.collect(typ.getUsages(), JvmClassNodeBuilder.this.myUsages);
                super.visitTypeInsn(opcode, type);
            }

            public void visitFieldInsn(int opcode, String owner, String name, String desc2) {
                this.registerFieldUsage(opcode, owner, name, desc2);
                super.visitFieldInsn(opcode, owner, name, desc2);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc2, boolean itf) {
                this.registerMethodUsage(owner, name, desc2);
                super.visitMethodInsn(opcode, owner, name, desc2, itf);
            }

            public void visitInvokeDynamicInsn(String methodName, String desc2, Handle bsm, Object ... bsmArgs) {
                Type samMethodType;
                Type returnType = Type.getReturnType((String)desc2);
                Iterators.collect(TypeRepr.getType(returnType).getUsages(), JvmClassNodeBuilder.this.myUsages);
                for (Object arg : bsmArgs) {
                    if (arg instanceof Type) {
                        Type type = (Type)arg;
                        if (type.getSort() == 11) {
                            for (Type argType : type.getArgumentTypes()) {
                                Iterators.collect(TypeRepr.getType(argType).getUsages(), JvmClassNodeBuilder.this.myUsages);
                            }
                            Iterators.collect(TypeRepr.getType(type.getReturnType()).getUsages(), JvmClassNodeBuilder.this.myUsages);
                            continue;
                        }
                        Iterators.collect(TypeRepr.getType(type).getUsages(), JvmClassNodeBuilder.this.myUsages);
                        continue;
                    }
                    if (!(arg instanceof Handle)) continue;
                    this.processMethodHandle((Handle)arg);
                }
                if (JvmClassNodeBuilder.LAMBDA_FACTORY_CLASS.equals(bsm.getOwner()) && returnType.getSort() == 10 && bsmArgs.length >= 3 && bsmArgs[0] instanceof Type && (samMethodType = (Type)bsmArgs[0]).getSort() == 11) {
                    this.registerMethodUsage(returnType.getInternalName(), methodName, samMethodType.getDescriptor());
                    JvmClassNodeBuilder.this.addUsage(new ClassNewUsage(returnType.getInternalName()));
                }
                super.visitInvokeDynamicInsn(methodName, desc2, bsm, bsmArgs);
            }

            private void processMethodHandle(Handle handle) {
                String memberOwner = handle.getOwner();
                if (memberOwner != null && !memberOwner.equals(JvmClassNodeBuilder.this.myClassNameHolder.get())) {
                    String memberName = handle.getName();
                    String memberDescriptor = handle.getDesc();
                    int opCode = JvmClassNodeBuilder.getFieldAccessOpcode(handle);
                    if (opCode > 0) {
                        this.registerFieldUsage(opCode, memberOwner, memberName, memberDescriptor);
                    } else {
                        this.registerMethodUsage(memberOwner, memberName, memberDescriptor);
                    }
                }
            }

            private void registerFieldUsage(int opcode, String owner, String fName, String desc2) {
                if (opcode == 181 || opcode == 179) {
                    JvmClassNodeBuilder.this.addUsage(new FieldAssignUsage(owner, fName, desc2));
                }
                if (opcode == 180 || opcode == 178) {
                    Iterators.collect(TypeRepr.getType(desc2).getUsages(), JvmClassNodeBuilder.this.myUsages);
                }
                JvmClassNodeBuilder.this.addUsage(new FieldUsage(owner, fName, desc2));
            }

            private void registerMethodUsage(String owner, String name, @Nullable String desc2) {
                if (desc2 != null) {
                    JvmClassNodeBuilder.this.addUsage(new MethodUsage(owner, name, desc2));
                    Iterators.collect(TypeRepr.getType(Type.getReturnType((String)desc2)).getUsages(), JvmClassNodeBuilder.this.myUsages);
                } else {
                    JvmClassNodeBuilder.this.addUsage(new MethodUsage(owner, name, ""));
                }
            }
        };
    }

    private static int getFieldAccessOpcode(Handle handle) {
        switch (handle.getTag()) {
            case 1: {
                return 180;
            }
            case 2: {
                return 178;
            }
            case 3: {
                return 181;
            }
            case 4: {
                return 179;
            }
        }
        return -1;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (name != null && name.equals(this.myClassNameHolder.get())) {
            this.myAccess |= access;
            if (outerName != null) {
                this.myOuterClassName.set((Object)outerName);
            }
            if (innerName == null) {
                this.myAnonymousClassFlag.set((Object)true);
            }
        }
    }

    public void visitOuterClass(String owner, String name, String desc) {
        this.myOuterClassName.set((Object)owner);
        if (name != null) {
            this.myLocalClassFlag.set((Object)true);
        }
    }

    private final class ModuleCrawler
    extends ModuleVisitor {
        ModuleCrawler() {
            super(589824);
        }

        public void visitMainClass(String mainClass) {
            JvmClassNodeBuilder.this.addUsage(new ClassUsage(mainClass));
        }

        public void visitRequire(String module, int access, String version) {
            if (this.isExplicit(access)) {
                JvmClassNodeBuilder.this.myModuleRequires.add(new ModuleRequires(new JVMFlags(access), module, version));
            }
        }

        public void visitExport(String packaze, int access, String ... modules) {
            if (this.isExplicit(access)) {
                JvmClassNodeBuilder.this.myModuleExports.add(new ModulePackage(packaze, modules != null ? Arrays.asList(modules) : Collections.emptyList()));
            }
        }

        public void visitUse(String service) {
            JvmClassNodeBuilder.this.addUsage(new ClassUsage(service));
        }

        public void visitProvide(String service, String ... providers) {
            JvmClassNodeBuilder.this.addUsage(new ClassUsage(service));
            if (providers != null) {
                for (String provider : providers) {
                    JvmClassNodeBuilder.this.addUsage(new ClassUsage(provider));
                }
            }
        }

        private boolean isExplicit(int access) {
            return (access & 0x9000) == 0;
        }
    }

    private final class AnnotationTargetCrawler
    extends AnnotationVisitor {
        private AnnotationTargetCrawler() {
            super(589824);
        }

        public void visit(String name, Object value) {
        }

        public void visitEnum(String name, String desc, String value) {
            JvmClassNodeBuilder.this.myTargets.add(ElemType.valueOf(value));
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return this;
        }

        public AnnotationVisitor visitArray(String name) {
            return this;
        }

        public void visitEnd() {
        }
    }

    private final class AnnotationRetentionPolicyCrawler
    extends AnnotationVisitor {
        private AnnotationRetentionPolicyCrawler() {
            super(589824);
        }

        public void visit(String name, Object value) {
        }

        public void visitEnum(String name, String desc, String value) {
            JvmClassNodeBuilder.this.myRetentionPolicy = RetentionPolicy.valueOf(value);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return null;
        }

        public AnnotationVisitor visitArray(String name) {
            return null;
        }

        public void visitEnd() {
        }
    }

    private final class AnnotationCrawler
    extends AnnotationVisitor {
        private final TypeRepr.ClassType myType;
        private final ElemType myTarget;
        private final Set<String> myUsedArguments;
        @Nullable
        private String myArrayName;

        private AnnotationCrawler(TypeRepr.ClassType type, ElemType target) {
            super(589824);
            this.myUsedArguments = new HashSet<String>();
            this.myType = type;
            this.myTarget = target;
            Set<ElemType> targets = JvmClassNodeBuilder.this.myAnnotationTargets.get(type);
            if (targets == null) {
                JvmClassNodeBuilder.this.myAnnotationTargets.put(type, EnumSet.of(target));
            } else {
                targets.add(target);
            }
            JvmClassNodeBuilder.this.addUsage(new ClassUsage(type.getJvmName()));
        }

        private String getMethodDescr(Object value, boolean isArray) {
            StringBuilder descriptor = new StringBuilder();
            descriptor.append("()");
            if (isArray) {
                descriptor.append("[");
            }
            if (value instanceof Type) {
                descriptor.append("Ljava/lang/Class;");
            } else {
                String name;
                switch (name = Type.getType(value.getClass()).getInternalName()) {
                    case "java/lang/Integer": {
                        descriptor.append("I;");
                        break;
                    }
                    case "java/lang/Short": {
                        descriptor.append("S;");
                        break;
                    }
                    case "java/lang/Long": {
                        descriptor.append("J;");
                        break;
                    }
                    case "java/lang/Byte": {
                        descriptor.append("B;");
                        break;
                    }
                    case "java/lang/Char": {
                        descriptor.append("C;");
                        break;
                    }
                    case "java/lang/Boolean": {
                        descriptor.append("Z;");
                        break;
                    }
                    case "java/lang/Float": {
                        descriptor.append("F;");
                        break;
                    }
                    case "java/lang/Double": {
                        descriptor.append("D;");
                        break;
                    }
                    default: {
                        descriptor.append("L").append(name).append(";");
                    }
                }
            }
            return descriptor.toString();
        }

        public void visit(String name, Object value) {
            String argName;
            boolean isArray;
            boolean bl = isArray = name == null && this.myArrayName != null;
            if (name != null) {
                argName = name;
            } else {
                argName = this.myArrayName;
                this.myArrayName = null;
            }
            if (argName != null) {
                this.registerUsages(argName, this.getMethodDescr(value, isArray), value);
            }
        }

        public void visitEnum(String name, String desc, String value) {
            String argName;
            boolean isArray;
            boolean bl = isArray = name == null && this.myArrayName != null;
            if (name != null) {
                argName = name;
            } else {
                argName = this.myArrayName;
                this.myArrayName = null;
            }
            if (argName != null) {
                this.registerUsages(argName, (isArray ? "()[" : "()") + desc, value);
            }
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return new AnnotationCrawler((TypeRepr.ClassType)TypeRepr.getType(desc), this.myTarget);
        }

        public AnnotationVisitor visitArray(String name) {
            this.myArrayName = name;
            return this;
        }

        private void registerUsages(String methodName, String methodDescr, Object value) {
            if (value instanceof Type) {
                String className = ((Type)value).getClassName().replace('.', '/');
                JvmClassNodeBuilder.this.addUsage(new ClassUsage(className));
            }
            JvmClassNodeBuilder.this.addUsage(new MethodUsage(this.myType.getJvmName(), methodName, methodDescr));
            this.myUsedArguments.add(methodName);
        }

        public void visitEnd() {
            Set<String> s = JvmClassNodeBuilder.this.myAnnotationArguments.get(this.myType);
            if (s == null) {
                JvmClassNodeBuilder.this.myAnnotationArguments.put(this.myType, this.myUsedArguments);
            } else {
                s.retainAll(this.myUsedArguments);
            }
        }
    }

    private class BaseSignatureVisitor
    extends SignatureVisitor {
        BaseSignatureVisitor() {
            super(589824);
        }

        public void visitFormalTypeParameter(String name) {
        }

        public SignatureVisitor visitClassBound() {
            return super.visitClassBound();
        }

        public SignatureVisitor visitInterfaceBound() {
            return super.visitInterfaceBound();
        }

        public SignatureVisitor visitSuperclass() {
            return super.visitSuperclass();
        }

        public SignatureVisitor visitInterface() {
            return super.visitInterface();
        }

        public SignatureVisitor visitParameterType() {
            return super.visitParameterType();
        }

        public SignatureVisitor visitReturnType() {
            return super.visitReturnType();
        }

        public SignatureVisitor visitExceptionType() {
            return super.visitExceptionType();
        }

        public void visitBaseType(char descriptor) {
        }

        public void visitTypeVariable(String name) {
        }

        public SignatureVisitor visitArrayType() {
            return super.visitArrayType();
        }

        public void visitInnerClassType(String name) {
        }

        public void visitTypeArgument() {
            super.visitTypeArgument();
        }

        public SignatureVisitor visitTypeArgument(char wildcard) {
            return this;
        }

        public void visitEnd() {
            super.visitEnd();
        }

        public void visitClassType(String name) {
            JvmClassNodeBuilder.this.addUsage(new ClassUsage(name));
        }
    }
}

