/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.client;

import com.google.protobuf.MessageLite;
import com.intellij.openapi.diagnostic.Logger;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.RequestFuture;
import org.jetbrains.jps.client.ProtobufClientMessageHandler;
import org.jetbrains.jps.client.ProtobufResponseHandler;
import org.jetbrains.jps.client.UUIDGetter;

public final class SimpleProtobufClient<T extends ProtobufResponseHandler> {
    private static final Logger LOG = Logger.getInstance(SimpleProtobufClient.class);
    private final AtomicReference<State> myState = new AtomicReference<State>(State.DISCONNECTED);
    private final ChannelInitializer myChannelInitializer;
    private final EventLoopGroup myEventLoopGroup;
    private volatile ChannelFuture myConnectFuture;
    private final ProtobufClientMessageHandler<T> myMessageHandler;

    public SimpleProtobufClient(final MessageLite msgDefaultInstance, Executor asyncExec, UUIDGetter uuidGetter) {
        this.myMessageHandler = new ProtobufClientMessageHandler(uuidGetter, this, asyncExec);
        this.myEventLoopGroup = new NioEventLoopGroup(1, asyncExec);
        this.myChannelInitializer = new ChannelInitializer(){

            protected void initChannel(Channel channel) {
                channel.pipeline().addLast(new ChannelHandler[]{new ProtobufVarint32FrameDecoder(), new ProtobufDecoder(msgDefaultInstance), new ProtobufVarint32LengthFieldPrepender(), new ProtobufEncoder(), SimpleProtobufClient.this.myMessageHandler});
            }
        };
    }

    public void checkConnected() throws Exception {
        if (this.myState.get() != State.CONNECTED) {
            throw new Exception("Client not connected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(String host, int port) {
        if (this.myState.compareAndSet(State.DISCONNECTED, State.CONNECTING)) {
            boolean bl;
            boolean success = false;
            try {
                Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.myEventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)this.myChannelInitializer);
                ((Bootstrap)bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
                ChannelFuture future = bootstrap.connect(host, port).syncUninterruptibly();
                success = future.isSuccess();
                if (success) {
                    this.myConnectFuture = future;
                    try {
                        this.onConnect();
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
                bl = success;
                this.myState.compareAndSet(State.CONNECTING, success ? State.CONNECTED : State.DISCONNECTED);
            }
            catch (Throwable throwable) {
                this.myState.compareAndSet(State.CONNECTING, success ? State.CONNECTED : State.DISCONNECTED);
                throw throwable;
            }
            return bl;
        }
        return true;
    }

    private void onConnect() {
    }

    private void beforeDisconnect() {
    }

    private void onDisconnect() {
    }

    public void disconnect() {
        block10: {
            if (this.myState.compareAndSet(State.CONNECTED, State.DISCONNECTING)) {
                try {
                    ChannelFuture future = this.myConnectFuture;
                    if (future == null) break block10;
                    try {
                        this.beforeDisconnect();
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                    ChannelFuture closeFuture = future.channel().close();
                    closeFuture.awaitUninterruptibly();
                }
                finally {
                    this.myConnectFuture = null;
                    this.myState.compareAndSet(State.DISCONNECTING, State.DISCONNECTED);
                    try {
                        this.onDisconnect();
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
            }
        }
    }

    public boolean isConnected() {
        return this.myState.get() == State.CONNECTED;
    }

    public RequestFuture<T> sendMessage(final UUID messageId, MessageLite message, @Nullable T responseHandler, @Nullable RequestFuture.CancelAction<T> cancelAction) {
        Channel channel;
        final RequestFuture<T> requestFuture = new RequestFuture<T>(responseHandler, messageId, cancelAction);
        this.myMessageHandler.registerFuture(messageId, requestFuture);
        ChannelFuture connectFuture = this.myConnectFuture;
        Channel channel2 = channel = connectFuture != null ? connectFuture.channel() : null;
        if (channel != null && channel.isActive()) {
            channel.writeAndFlush((Object)message).addListener((GenericFutureListener)new ChannelFutureListener(){
                final /* synthetic */ ProtobufResponseHandler val$responseHandler;
                {
                    this.val$responseHandler = protobufResponseHandler;
                }

                public void operationComplete(ChannelFuture future) {
                    if (!future.isSuccess()) {
                        SimpleProtobufClient.this.notifyTerminated(messageId, requestFuture, this.val$responseHandler);
                    }
                }
            });
        } else {
            this.notifyTerminated(messageId, requestFuture, responseHandler);
        }
        return requestFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTerminated(UUID messageId, RequestFuture<T> requestFuture, @Nullable T responseHandler) {
        try {
            this.myMessageHandler.removeFuture(messageId);
            if (responseHandler != null) {
                responseHandler.sessionTerminated();
            }
        }
        finally {
            requestFuture.setDone();
        }
    }

    private static enum State {
        DISCONNECTED,
        CONNECTING,
        CONNECTED,
        DISCONNECTING;

    }
}

