/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.FileCollectionFactory;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.AdditionalRootsProviderService;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.TargetTypeRegistry;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.service.JpsServiceManager;

public final class BuildRootIndexImpl
implements BuildRootIndex {
    private static final Key<Map<File, BuildRootDescriptor>> ROOT_DESCRIPTOR_MAP = Key.create((String)"_root_to_descriptor_map");
    private static final Key<Map<BuildTarget<?>, List<? extends BuildRootDescriptor>>> TEMP_TARGET_ROOTS_MAP = Key.create((String)"_module_to_root_map");
    private final IgnoredFileIndex myIgnoredFileIndex;
    private final Map<BuildTarget<?>, List<? extends BuildRootDescriptor>> myRootsByTarget;
    private final Map<File, List<BuildRootDescriptor>> myRootToDescriptors;
    private final ConcurrentMap<BuildRootDescriptor, FileFilter> myFileFilters;

    public BuildRootIndexImpl(@NotNull BuildTargetRegistry targetRegistry, @NotNull JpsModel model, @NotNull ModuleExcludeIndex index, @NotNull BuildDataPaths dataPaths, @NotNull IgnoredFileIndex ignoredFileIndex) {
        if (targetRegistry == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(0);
        }
        if (model == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(1);
        }
        if (index == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(2);
        }
        if (dataPaths == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(3);
        }
        if (ignoredFileIndex == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(4);
        }
        this.myIgnoredFileIndex = ignoredFileIndex;
        this.myRootsByTarget = new HashMap();
        this.myRootToDescriptors = FileCollectionFactory.createCanonicalFileMap();
        this.myFileFilters = new ConcurrentHashMap<BuildRootDescriptor, FileFilter>(16, 0.75f, 1);
        Iterable rootsProviders = JpsServiceManager.getInstance().getExtensions(AdditionalRootsProviderService.class);
        for (BuildTargetType<?> targetType : TargetTypeRegistry.getInstance().getTargetTypes()) {
            for (BuildTarget target : targetRegistry.getAllTargets(targetType)) {
                this.addRoots(dataPaths, rootsProviders, target, model, index, ignoredFileIndex);
            }
        }
    }

    private <R extends BuildRootDescriptor> void addRoots(@NotNull BuildDataPaths dataPaths, @NotNull Iterable<? extends AdditionalRootsProviderService> rootsProviders, @NotNull BuildTarget<R> target, @NotNull JpsModel model, @NotNull ModuleExcludeIndex index, @NotNull IgnoredFileIndex ignoredFileIndex) {
        if (dataPaths == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(5);
        }
        if (rootsProviders == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(6);
        }
        if (target == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(7);
        }
        if (model == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(8);
        }
        if (index == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(9);
        }
        if (ignoredFileIndex == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(10);
        }
        List<R> descriptors = target.computeRootDescriptors(model, index, ignoredFileIndex, dataPaths);
        for (AdditionalRootsProviderService additionalRootsProviderService : rootsProviders) {
            AdditionalRootsProviderService providerService;
            List<R> additionalRoots;
            if (!additionalRootsProviderService.getTargetTypes().contains(target.getTargetType()) || (additionalRoots = (providerService = additionalRootsProviderService).getAdditionalRoots(target, dataPaths)).isEmpty()) continue;
            descriptors = new ArrayList<R>(descriptors);
            descriptors.addAll(additionalRoots);
        }
        for (BuildRootDescriptor buildRootDescriptor : descriptors) {
            this.registerDescriptor(buildRootDescriptor);
        }
        if (descriptors instanceof ArrayList) {
            ((ArrayList)descriptors).trimToSize();
        }
        this.myRootsByTarget.put(target, descriptors);
    }

    private void registerDescriptor(BuildRootDescriptor descriptor) {
        SmartList list = this.myRootToDescriptors.get(descriptor.getRootFile());
        if (list == null) {
            list = new SmartList();
            this.myRootToDescriptors.put(descriptor.getRootFile(), (List<BuildRootDescriptor>)list);
        }
        list.add((BuildRootDescriptor)descriptor);
    }

    @Override
    @NotNull
    public <R extends BuildRootDescriptor> List<R> getRootDescriptors(@NotNull File root, @Nullable Collection<? extends BuildTargetType<? extends BuildTarget<R>>> types, @Nullable CompileContext context) {
        Map contextMap;
        BuildRootDescriptor descriptor2;
        if (root == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(11);
        }
        List<BuildRootDescriptor> descriptors = this.myRootToDescriptors.get(root);
        SmartList result = new SmartList();
        if (descriptors != null) {
            for (BuildRootDescriptor descriptor2 : descriptors) {
                if (types != null && !types.contains(descriptor2.getTarget().getTargetType())) continue;
                result.add(descriptor2);
            }
        }
        if (context != null && (contextMap = (Map)ROOT_DESCRIPTOR_MAP.get((UserDataHolder)context)) != null && (descriptor2 = (BuildRootDescriptor)contextMap.get(root)) != null && (types == null || types.contains(descriptor2.getTarget().getTargetType()))) {
            result.add(descriptor2);
        }
        SmartList smartList = result;
        if (smartList == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(12);
        }
        return smartList;
    }

    @Override
    @NotNull
    public <R extends BuildRootDescriptor> List<R> getTargetRoots(@NotNull BuildTarget<R> target, CompileContext context) {
        List<R> tempDescriptors;
        if (target == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(13);
        }
        List<BuildRootDescriptor> roots = this.myRootsByTarget.get(target);
        if (context != null && !(tempDescriptors = this.getTempTargetRoots(target, context)).isEmpty()) {
            if (roots != null) {
                roots = new ArrayList<BuildRootDescriptor>(roots);
                roots.addAll(tempDescriptors);
            } else {
                roots = tempDescriptors;
            }
        }
        List<Object> list = roots != null ? Collections.unmodifiableList(roots) : Collections.emptyList();
        if (list == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Override
    @NotNull
    public <R extends BuildRootDescriptor> List<R> getTempTargetRoots(@NotNull BuildTarget<R> target, @NotNull CompileContext context) {
        Map contextMap;
        if (target == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(15);
        }
        if (context == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(16);
        }
        List rootList = (contextMap = (Map)TEMP_TARGET_ROOTS_MAP.get((UserDataHolder)context)) != null ? (List)contextMap.get(target) : null;
        List list = rootList != null ? rootList : Collections.emptyList();
        if (list == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(17);
        }
        return list;
    }

    @Override
    public <R extends BuildRootDescriptor> void associateTempRoot(@NotNull CompileContext context, @NotNull BuildTarget<R> target, @NotNull R root) {
        BuildRootDescriptor d;
        HashMap targetToRootMap;
        Map rootToDescriptorMap;
        if (context == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(18);
        }
        if (target == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(19);
        }
        if (root == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(20);
        }
        if ((rootToDescriptorMap = (Map)ROOT_DESCRIPTOR_MAP.get((UserDataHolder)context)) == null) {
            rootToDescriptorMap = FileCollectionFactory.createCanonicalFileMap();
            ROOT_DESCRIPTOR_MAP.set((UserDataHolder)context, (Object)rootToDescriptorMap);
        }
        if ((targetToRootMap = (HashMap)TEMP_TARGET_ROOTS_MAP.get((UserDataHolder)context)) == null) {
            targetToRootMap = new HashMap();
            TEMP_TARGET_ROOTS_MAP.set((UserDataHolder)context, targetToRootMap);
        }
        if ((d = (BuildRootDescriptor)rootToDescriptorMap.get(root.getRootFile())) != null) {
            return;
        }
        ArrayList<R> targetRoots = (ArrayList<R>)targetToRootMap.get(target);
        if (targetRoots == null) {
            targetRoots = new ArrayList<R>();
            targetToRootMap.put(target, targetRoots);
        }
        rootToDescriptorMap.put(root.getRootFile(), root);
        targetRoots.add(root);
    }

    @Override
    @Nullable
    public <R extends BuildRootDescriptor> R findParentDescriptor(@NotNull File file, @NotNull Collection<? extends BuildTargetType<? extends BuildTarget<R>>> types, @Nullable CompileContext context) {
        if (file == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(21);
        }
        if (types == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(22);
        }
        File current = file;
        int depth = 0;
        while (current != null) {
            List<R> descriptors = this.filterDescriptorsByFile(this.getRootDescriptors(current, types, context), file, depth);
            if (!descriptors.isEmpty()) {
                return (R)((BuildRootDescriptor)descriptors.get(0));
            }
            current = FileUtilRt.getParentFile((File)current);
            ++depth;
        }
        return null;
    }

    @Override
    @NotNull
    public <R extends BuildRootDescriptor> Collection<R> findAllParentDescriptors(@NotNull File file, @Nullable Collection<? extends BuildTargetType<? extends BuildTarget<R>>> types, @Nullable CompileContext context) {
        if (file == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(23);
        }
        File current = file;
        List<Object> result = null;
        int depth = 0;
        while (current != null) {
            List<R> descriptors = this.filterDescriptorsByFile(this.getRootDescriptors(current, types, context), file, depth);
            if (!descriptors.isEmpty()) {
                if (result == null) {
                    result = descriptors;
                } else {
                    result = new ArrayList(result);
                    result.addAll(descriptors);
                }
            }
            current = FileUtilRt.getParentFile((File)current);
            ++depth;
        }
        List<Object> list = result != null ? result : Collections.emptyList();
        if (list == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(24);
        }
        return list;
    }

    @NotNull
    private <R extends BuildRootDescriptor> List<R> filterDescriptorsByFile(@NotNull List<R> descriptors, File file, int parentsToCheck) {
        if (descriptors == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(25);
        }
        List<R> result = descriptors;
        for (int i = 0; i < descriptors.size(); ++i) {
            BuildRootDescriptor descriptor = (BuildRootDescriptor)descriptors.get(i);
            if (this.isFileAccepted(file, descriptor) && this.isParentDirectoriesAccepted(file, parentsToCheck, descriptor)) {
                if (result == descriptors) continue;
                result.add(descriptor);
                continue;
            }
            if (result != descriptors) continue;
            result = new ArrayList<R>(descriptors.size() - 1);
            for (int j = 0; j < i; ++j) {
                result.add((BuildRootDescriptor)descriptors.get(j));
            }
        }
        List<R> list = result;
        if (list == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(26);
        }
        return list;
    }

    private boolean isParentDirectoriesAccepted(File file, int parentsToCheck, BuildRootDescriptor descriptor) {
        File current = file;
        while (parentsToCheck-- > 0) {
            if (this.isDirectoryAccepted(current = FileUtil.getParentFile((File)current), descriptor)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public <R extends BuildRootDescriptor> Collection<R> findAllParentDescriptors(@NotNull File file, @Nullable CompileContext context) {
        if (file == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(27);
        }
        Collection<R> collection = this.findAllParentDescriptors(file, null, context);
        if (collection == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(28);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Collection<? extends BuildRootDescriptor> clearTempRoots(@NotNull CompileContext context) {
        if (context == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(29);
        }
        Map map = (Map)ROOT_DESCRIPTOR_MAP.get((UserDataHolder)context);
        Collection<Object> collection = map != null ? map.values() : Collections.emptyList();
        Collection<Object> collection2 = collection;
        if (collection2 == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(30);
        }
        return collection2;
        finally {
            TEMP_TARGET_ROOTS_MAP.set((UserDataHolder)context, null);
            ROOT_DESCRIPTOR_MAP.set((UserDataHolder)context, null);
        }
    }

    @Override
    @Nullable
    public JavaSourceRootDescriptor findJavaRootDescriptor(@Nullable CompileContext context, File file) {
        return (JavaSourceRootDescriptor)this.findParentDescriptor(file, JavaModuleBuildTargetType.ALL_TYPES, context);
    }

    @Override
    @NotNull
    public FileFilter getRootFilter(@NotNull BuildRootDescriptor descriptor) {
        FileFilter filter;
        if (descriptor == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(31);
        }
        if ((filter = (FileFilter)this.myFileFilters.get(descriptor)) == null) {
            filter = descriptor.createFileFilter();
            this.myFileFilters.put(descriptor, filter);
        }
        FileFilter fileFilter = filter;
        if (fileFilter == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(32);
        }
        return fileFilter;
    }

    @Override
    public boolean isFileAccepted(@NotNull File file, @NotNull BuildRootDescriptor descriptor) {
        if (file == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(33);
        }
        if (descriptor == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(34);
        }
        return !this.myIgnoredFileIndex.isIgnored(file.getName()) && this.getRootFilter(descriptor).accept(file);
    }

    @Override
    public boolean isDirectoryAccepted(@NotNull File dir, @NotNull BuildRootDescriptor descriptor) {
        if (dir == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(35);
        }
        if (descriptor == null) {
            BuildRootIndexImpl.$$$reportNull$$$0(36);
        }
        return !this.myIgnoredFileIndex.isIgnored(dir.getName()) && !descriptor.getExcludedRoots().contains(dir);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRegistry";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPaths";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredFileIndex";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsProviders";
                break;
            }
            case 7: 
            case 13: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/builders/impl/BuildRootIndexImpl";
                break;
            }
            case 16: 
            case 18: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 21: 
            case 23: 
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 31: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/builders/impl/BuildRootIndexImpl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootDescriptors";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetRoots";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempTargetRoots";
                break;
            }
            case 24: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllParentDescriptors";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "filterDescriptorsByFile";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "clearTempRoots";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addRoots";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRootDescriptors";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTargetRoots";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTempTargetRoots";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "associateTempRoot";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findParentDescriptor";
                break;
            }
            case 23: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findAllParentDescriptors";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "filterDescriptorsByFile";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "clearTempRoots";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getRootFilter";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isFileAccepted";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isDirectoryAccepted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

