/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations.coverage;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.JavaCoverageEngine;
import com.intellij.coverage.JavaCoverageRunner;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageClassFilterEditor;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.configurations.coverage.JavaCoverageEnabledConfiguration;
import com.intellij.execution.util.JreVersionDetector;
import com.intellij.icons.AllIcons;
import com.intellij.java.coverage.JavaCoverageBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CoverageConfigurable
extends SettingsEditor<RunConfigurationBase> {
    private static final Logger LOG = Logger.getInstance(CoverageConfigurable.class);
    private final JreVersionDetector myVersionDetector = new JreVersionDetector();
    final Project myProject;
    private CoverageClassFilterEditor myClassFilterEditor;
    private CoverageClassFilterEditor myExcludeClassFilterEditor;
    private JLabel myCoverageNotSupportedLabel;
    private ComboBox<CoverageRunnerItem> myCoverageRunnerCb;
    private JPanel myRunnerPanel;
    private JCheckBox myTrackPerTestCoverageCb;
    private JCheckBox myTrackTestSourcesCb;
    private JCheckBox myBranchCoverageCb;
    private final RunConfigurationBase myConfig;

    public CoverageConfigurable(RunConfigurationBase config) {
        this.myConfig = config;
        this.myProject = config.getProject();
    }

    protected void resetEditorFrom(@NotNull RunConfigurationBase runConfiguration) {
        if (runConfiguration == null) {
            CoverageConfigurable.$$$reportNull$$$0(0);
        }
        boolean isJre50 = runConfiguration instanceof CommonJavaRunConfigurationParameters && this.myVersionDetector.isJre50Configured((CommonJavaRunConfigurationParameters)runConfiguration) ? true : (runConfiguration instanceof ModuleBasedConfiguration ? this.myVersionDetector.isModuleJre50Configured((ModuleBasedConfiguration)runConfiguration) : true);
        this.myCoverageNotSupportedLabel.setVisible(!isJre50);
        JavaCoverageEnabledConfiguration configuration = (JavaCoverageEnabledConfiguration)CoverageEnabledConfiguration.getOrCreate((RunConfigurationBase)runConfiguration);
        CoverageRunner runner = configuration.getCoverageRunner();
        if (runner != null) {
            this.myCoverageRunnerCb.setSelectedItem((Object)new CoverageRunnerItem(runner));
        } else {
            String runnerId = configuration.getRunnerId();
            if (runnerId != null) {
                CoverageRunnerItem runnerItem = new CoverageRunnerItem(runnerId);
                DefaultComboBoxModel model = (DefaultComboBoxModel)this.myCoverageRunnerCb.getModel();
                if (model.getIndexOf(runnerItem) == -1) {
                    model.addElement(runnerItem);
                }
                this.myCoverageRunnerCb.setSelectedItem((Object)runnerItem);
            } else {
                this.myCoverageRunnerCb.setSelectedIndex(0);
            }
            runner = ((CoverageRunnerItem)Objects.requireNonNull(this.myCoverageRunnerCb.getSelectedItem())).getRunner();
        }
        this.myRunnerPanel.setEnabled(isJre50);
        this.myClassFilterEditor.setFilters(CoverageConfigurable.getCoveragePatterns(configuration, true));
        this.myExcludeClassFilterEditor.setFilters(CoverageConfigurable.getCoveragePatterns(configuration, false));
        this.setUpBranchCoverage(runner, configuration.isBranchCoverageEnabled(), configuration.isTrackPerTestCoverage());
        this.myTrackTestSourcesCb.setSelected(configuration.isTrackTestFolders());
    }

    private void setUpBranchCoverage(CoverageRunner runner, boolean branchCoverage, boolean testTracking) {
        if (runner instanceof JavaCoverageRunner) {
            JavaCoverageRunner javaRunner = (JavaCoverageRunner)runner;
            boolean alwaysAvailable = javaRunner.isBranchInfoAvailable(false);
            boolean neverAvailable = !javaRunner.isBranchInfoAvailable(true);
            this.myBranchCoverageCb.setEnabled(!alwaysAvailable && !neverAvailable);
            this.myBranchCoverageCb.setSelected(javaRunner.isBranchInfoAvailable(branchCoverage));
        } else {
            this.myBranchCoverageCb.setEnabled(true);
            this.myBranchCoverageCb.setSelected(branchCoverage);
        }
        boolean isCoverageByTestApplicable = runner != null && runner.isCoverageByTestApplicable();
        this.myTrackPerTestCoverageCb.setSelected(testTracking);
        this.myTrackPerTestCoverageCb.setEnabled(isCoverageByTestApplicable && this.myBranchCoverageCb.isSelected() && this.canHavePerTestCoverage());
    }

    static ClassFilter[] getCoveragePatterns(@NotNull JavaCoverageEnabledConfiguration configuration, boolean include) {
        if (configuration == null) {
            CoverageConfigurable.$$$reportNull$$$0(1);
        }
        return (ClassFilter[])Arrays.stream((ClassFilter[])ObjectUtils.chooseNotNull((Object)configuration.getCoveragePatterns(), (Object)ClassFilter.EMPTY_ARRAY)).filter(classFilter -> classFilter.INCLUDE == include).toArray(ClassFilter[]::new);
    }

    private boolean canHavePerTestCoverage() {
        return CoverageEnabledConfiguration.getOrCreate((RunConfigurationBase)this.myConfig).canHavePerTestCoverage();
    }

    protected void applyEditorTo(@NotNull RunConfigurationBase runConfiguration) {
        Object[] oldCoveragePatterns;
        if (runConfiguration == null) {
            CoverageConfigurable.$$$reportNull$$$0(2);
        }
        JavaCoverageEnabledConfiguration configuration = (JavaCoverageEnabledConfiguration)CoverageEnabledConfiguration.getOrCreate((RunConfigurationBase)runConfiguration);
        Object[] newCoveragePatterns = (ClassFilter[])ArrayUtil.mergeArrays((Object[])this.myClassFilterEditor.getFilters(), (Object[])this.myExcludeClassFilterEditor.getFilters());
        if (newCoveragePatterns.length != (oldCoveragePatterns = (ClassFilter[])ObjectUtils.chooseNotNull((Object)configuration.getCoveragePatterns(), (Object)ClassFilter.EMPTY_ARRAY)).length || !ContainerUtil.newHashSet((Object[])newCoveragePatterns).equals(ContainerUtil.newHashSet((Object[])oldCoveragePatterns))) {
            configuration.setCoveragePatterns((ClassFilter[])newCoveragePatterns);
        }
        configuration.setCoverageRunner(this.getSelectedRunner());
        configuration.setTrackPerTestCoverage(this.myTrackPerTestCoverageCb.isSelected());
        configuration.setBranchCoverage(this.myBranchCoverageCb.isSelected());
        configuration.setTrackTestFolders(this.myTrackTestSourcesCb.isSelected());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel result = new JPanel(new GridBagLayout());
        DefaultComboBoxModel<CoverageRunnerItem> runnersModel = new DefaultComboBoxModel<CoverageRunnerItem>();
        this.myCoverageRunnerCb = new ComboBox(runnersModel);
        JavaCoverageEnabledConfiguration javaCoverageEnabledConfiguration = JavaCoverageEnabledConfiguration.getFrom(this.myConfig);
        LOG.assertTrue(javaCoverageEnabledConfiguration != null);
        JavaCoverageEngine provider = JavaCoverageEngine.getInstance();
        for (CoverageRunner runner : CoverageRunner.EP_NAME.getExtensionList()) {
            if (!runner.acceptsCoverageEngine((CoverageEngine)provider)) continue;
            runnersModel.addElement(new CoverageRunnerItem(runner));
        }
        this.myCoverageRunnerCb.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", CoverageRunnerItem::getPresentableName));
        this.myCoverageRunnerCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageConfigurable.this.setUpBranchCoverage(CoverageConfigurable.this.getSelectedRunner(), CoverageConfigurable.this.myBranchCoverageCb.isSelected(), CoverageConfigurable.this.myTrackPerTestCoverageCb.isSelected());
            }
        });
        this.myRunnerPanel = new JPanel(new GridBagLayout());
        this.myRunnerPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.myRunnerPanel.add((Component)new JLabel(JavaCoverageBundle.message("run.configuration.choose.coverage.runner", new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, (Insets)JBUI.insetsRight((int)10), 0, 0));
        this.myRunnerPanel.add((Component)this.myCoverageRunnerCb, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, (Insets)JBInsets.emptyInsets(), 0, 0));
        JPanel cPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        this.myBranchCoverageCb = new JCheckBox(JavaCoverageBundle.message("run.configuration.coverage.branches", new Object[0]));
        JPanel branchCoveragePanel = UI.PanelFactory.panel((JComponent)this.myBranchCoverageCb).withComment(JavaCoverageBundle.message("run.configuration.coverage.branches.comment", new Object[0])).createPanel();
        cPanel.add(branchCoveragePanel);
        ActionListener branchCoverageListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageConfigurable.this.setUpBranchCoverage(CoverageConfigurable.this.getSelectedRunner(), CoverageConfigurable.this.myBranchCoverageCb.isSelected(), CoverageConfigurable.this.myTrackPerTestCoverageCb.isSelected());
            }
        };
        this.myBranchCoverageCb.addActionListener(branchCoverageListener);
        this.myTrackPerTestCoverageCb = new JCheckBox(JavaCoverageBundle.message("run.configuration.track.per.test.coverage", new Object[0]));
        JBPanel testTrackingPanel = JBUI.Panels.simplePanel((Component)this.myTrackPerTestCoverageCb).withBorder((Border)JBUI.Borders.emptyLeft((int)15));
        cPanel.add((Component)testTrackingPanel);
        this.myRunnerPanel.add((Component)cPanel, new GridBagConstraints(0, 1, 0, 1, 1.0, 1.0, 17, 0, (Insets)JBInsets.emptyInsets(), 0, 0));
        GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBInsets.emptyInsets(), 0, 0);
        result.add((Component)this.myRunnerPanel, gc);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints bagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 1, (Insets)JBInsets.emptyInsets(), 0, 0);
        panel.add((Component)new TitledSeparator(JavaCoverageBundle.message("record.coverage.filters.title", new Object[0])), bagConstraints);
        this.myClassFilterEditor = new CoverageClassFilterEditor(this.myProject);
        panel.add((Component)((Object)this.myClassFilterEditor), bagConstraints);
        panel.add((Component)new TitledSeparator(JavaCoverageBundle.message("exclude.coverage.filters.title", new Object[0])), bagConstraints);
        this.myExcludeClassFilterEditor = new CoverageClassFilterEditor(this.myProject){

            @NotNull
            protected ClassFilter createFilter(String pattern) {
                ClassFilter filter = super.createFilter(pattern);
                filter.setInclude(false);
                ClassFilter classFilter = filter;
                if (classFilter == null) {
                    3.$$$reportNull$$$0(0);
                }
                return classFilter;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/coverage/CoverageConfigurable$3", "createFilter"));
            }
        };
        panel.add((Component)((Object)this.myExcludeClassFilterEditor), bagConstraints);
        bagConstraints.weighty = 0.0;
        this.myTrackTestSourcesCb = new JCheckBox(JavaCoverageBundle.message("run.configuration.enable.coverage.in.test.folders", new Object[0]));
        panel.add((Component)this.myTrackTestSourcesCb, bagConstraints);
        gc.weighty = 1.0;
        gc.fill = 1;
        result.add((Component)panel, gc);
        this.myCoverageNotSupportedLabel = new JLabel(JavaCoverageBundle.message("code.coverage.is.not.supported", new Object[0]));
        this.myCoverageNotSupportedLabel.setIcon(AllIcons.General.WarningDialog);
        result.add((Component)this.myCoverageNotSupportedLabel, gc);
        JPanel jPanel = result;
        if (jPanel == null) {
            CoverageConfigurable.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @Nullable
    private CoverageRunner getSelectedRunner() {
        CoverageRunnerItem runnerItem = (CoverageRunnerItem)this.myCoverageRunnerCb.getSelectedItem();
        if (runnerItem == null) {
            LOG.debug("Available runners: " + this.myCoverageRunnerCb.getModel().getSize());
        }
        return runnerItem != null ? runnerItem.getRunner() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/coverage/CoverageConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/coverage/CoverageConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCoveragePatterns";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static final class CoverageRunnerItem {
        private CoverageRunner myRunner;
        @NotNull
        private final String myRunnerId;

        private CoverageRunnerItem(@NotNull CoverageRunner runner) {
            if (runner == null) {
                CoverageRunnerItem.$$$reportNull$$$0(0);
            }
            this.myRunner = runner;
            this.myRunnerId = runner.getId();
        }

        private CoverageRunnerItem(@NotNull String runnerId) {
            if (runnerId == null) {
                CoverageRunnerItem.$$$reportNull$$$0(1);
            }
            this.myRunnerId = runnerId;
        }

        public CoverageRunner getRunner() {
            return this.myRunner;
        }

        @NotNull
        public String getRunnerId() {
            String string = this.myRunnerId;
            if (string == null) {
                CoverageRunnerItem.$$$reportNull$$$0(2);
            }
            return string;
        }

        public String getPresentableName() {
            return this.myRunner != null ? this.myRunner.getPresentableName() : this.myRunnerId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CoverageRunnerItem that = (CoverageRunnerItem)o;
            return this.myRunnerId.equals(that.myRunnerId);
        }

        public int hashCode() {
            return this.myRunnerId.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnerId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/configurations/coverage/CoverageConfigurable$CoverageRunnerItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/configurations/coverage/CoverageConfigurable$CoverageRunnerItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRunnerId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

