/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.analysis.PackageAnnotator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.ClassUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="JavaCoverageOptionsProvider", storages={@Storage(value="$WORKSPACE_FILE$")})
@Service(value={Service.Level.PROJECT})
public final class JavaCoverageOptionsProvider
implements PersistentStateComponent<State> {
    private final State myState = new State();
    private final Project myProject;

    public JavaCoverageOptionsProvider(Project project) {
        this.myProject = project;
    }

    public boolean ignoreImplicitConstructors() {
        return this.myState.myIgnoreImplicitConstructors;
    }

    public static JavaCoverageOptionsProvider getInstance(Project project) {
        return (JavaCoverageOptionsProvider)project.getService(JavaCoverageOptionsProvider.class);
    }

    public void setIgnoreImplicitConstructors(boolean state) {
        this.myState.myIgnoreImplicitConstructors = state;
    }

    void setExcludeAnnotationPatterns(List<String> patterns) {
        this.myState.myExcludeAnnotationPatterns = patterns;
    }

    public List<String> getExcludeAnnotationPatterns() {
        return this.myState.myExcludeAnnotationPatterns;
    }

    public boolean isGeneratedConstructor(String qualifiedName, String methodSignature) {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (this.myState.myIgnoreImplicitConstructors) {
            PsiClass psiClass2 = (PsiClass)DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(() -> ClassUtil.findPsiClassByJVMName((PsiManager)PsiManager.getInstance((Project)this.myProject), (String)qualifiedName));
            return PackageAnnotator.isGeneratedDefaultConstructor(psiClass2, methodSignature);
        }
        return false;
    }

    public @NotNull State getState() {
        State state = this.myState;
        if (state == null) {
            JavaCoverageOptionsProvider.$$$reportNull$$$0(0);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            JavaCoverageOptionsProvider.$$$reportNull$$$0(1);
        }
        this.myState.myIgnoreImplicitConstructors = state.myIgnoreImplicitConstructors;
        this.myState.myExcludeAnnotationPatterns = JavaCoverageOptionsProvider.listWithDefaultAnnotations(state.myExcludeAnnotationPatterns);
    }

    @NotNull
    private static ArrayList<String> listWithDefaultAnnotations(List<String> patterns) {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>(JavaCoverageOptionsProvider.getDefaultExcludeAnnotationPatterns());
        annotations.addAll(patterns);
        return new ArrayList<String>(annotations);
    }

    @NotNull
    public static List<String> getDefaultExcludeAnnotationPatterns() {
        List list = CollectionsKt.mutableListOf((Object[])new String[]{"*Generated*"});
        if (list == null) {
            JavaCoverageOptionsProvider.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/JavaCoverageOptionsProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/JavaCoverageOptionsProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultExcludeAnnotationPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    public static class State {
        public boolean myIgnoreImplicitConstructors = true;
        public List<String> myExcludeAnnotationPatterns = JavaCoverageOptionsProvider.getDefaultExcludeAnnotationPatterns();
    }
}

