/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterInStringLiteralHandler;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaElementType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaEnterInTextBlockHandler
extends EnterInStringLiteralHandler {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        int offsetInTextBlock;
        boolean isAtFirstLine;
        int offset;
        PsiElement textBlock;
        if (file == null) {
            JavaEnterInTextBlockHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JavaEnterInTextBlockHandler.$$$reportNull$$$0(1);
        }
        if (caretOffsetRef == null) {
            JavaEnterInTextBlockHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvanceRef == null) {
            JavaEnterInTextBlockHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            JavaEnterInTextBlockHandler.$$$reportNull$$$0(4);
        }
        if ((textBlock = JavaEnterInTextBlockHandler.getTextBlockAt(file, offset = editor.getCaretModel().getOffset())) == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int textBlockOffset = textBlock.getTextOffset();
        String text = textBlock.getText();
        boolean bl = isAtFirstLine = !text.substring(0, offsetInTextBlock = offset - textBlockOffset).contains("\n");
        if (!isAtFirstLine) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor.getDocument();
        Project project = textBlock.getProject();
        int secondLineStart = text.indexOf(10);
        if (secondLineStart == -1) {
            document.insertString(offset, (CharSequence)"\n");
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            CodeStyleManager.getInstance((Project)project).reformat(textBlock);
            text = textBlock.getText();
            int indent = JavaEnterInTextBlockHandler.getIndent(text, offsetInTextBlock + 1);
            if (indent == -1) {
                return EnterHandlerDelegate.Result.Continue;
            }
            editor.getCaretModel().moveToOffset(offset + 1 + indent);
        } else {
            int indent = JavaEnterInTextBlockHandler.getIndent(text, secondLineStart + 1);
            if (indent == -1) {
                return EnterHandlerDelegate.Result.Continue;
            }
            String newLine = "\n" + StringUtil.repeatSymbol((char)' ', (int)indent);
            document.insertString(offset, (CharSequence)newLine);
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            editor.getCaretModel().moveToOffset(offset + newLine.length());
        }
        return EnterHandlerDelegate.Result.Stop;
    }

    @Contract(value="null, _ -> null")
    private static PsiElement getTextBlockAt(PsiFile file, int offset) {
        if (!JavaEnterInTextBlockHandler.isJavaFile(file)) {
            return null;
        }
        PsiElement token = file.findElementAt(offset);
        if (token == null || token.getNode() == null || !BasicJavaAstTreeUtil.is(token.getNode(), JavaTokenType.TEXT_BLOCK_LITERAL)) {
            return null;
        }
        PsiElement parent = token.getParent();
        if (!BasicJavaAstTreeUtil.is(BasicJavaAstTreeUtil.toNode(parent), BasicJavaElementType.BASIC_LITERAL_EXPRESSION)) {
            return null;
        }
        return parent;
    }

    private static boolean isJavaFile(@Nullable PsiFile file) {
        return file != null && file.getLanguage() == JavaLanguage.INSTANCE;
    }

    private static int getIndent(@NotNull String text, int start) {
        if (text == null) {
            JavaEnterInTextBlockHandler.$$$reportNull$$$0(5);
        }
        int indent = 0;
        for (int i = start; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                indent = 0;
                continue;
            }
            if (Character.isWhitespace(c)) {
                ++indent;
                continue;
            }
            return indent;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffsetRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvanceRef";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/JavaEnterInTextBlockHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessEnter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

