/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.graph;

import io.kinference.data.ONNXData;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0010\b\u0000\u0010\u0001*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00022\u00060\u0003j\u0002`\u0004B\u0017\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0015\u0010\u0010\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0011\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\tJ\u0013\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\tJ\u0014\u0010\u0018\u001a\u00020\u000e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0016\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\nJ\u001b\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001eJ\u001a\u0010\u001f\u001a\u00020\u000e2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00160!R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u0000`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/kinference/graph/GraphContext;", "T", "Lio/kinference/data/ONNXData;", "Ljava/io/Closeable;", "Lio/kinference/utils/Closeable;", "base", "(Lio/kinference/graph/GraphContext;)V", "shapes", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "values", "clear", "", "close", "getOrNullValue", "name", "(Ljava/lang/String;)Lio/kinference/data/ONNXData;", "getShape", "getValue", "hasShape", "", "hasValue", "mergeContext", "context", "putShape", "shape", "putValue", "value", "(Ljava/lang/String;Lio/kinference/data/ONNXData;)V", "removeValues", "predicate", "Lkotlin/Function1;", "inference-ir"})
@SourceDebugExtension(value={"SMAP\nGraphContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphContext.kt\nio/kinference/graph/GraphContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1#2:67\n766#3:68\n857#3,2:69\n1855#3,2:71\n*S KotlinDebug\n*F\n+ 1 GraphContext.kt\nio/kinference/graph/GraphContext\n*L\n37#1:68\n37#1:69,2\n38#1:71,2\n*E\n"})
public final class GraphContext<T extends ONNXData<?, ?>>
implements Closeable {
    @Nullable
    private final GraphContext<T> base;
    @NotNull
    private final HashMap<String, T> values;
    @NotNull
    private final HashMap<String, Integer> shapes;

    public GraphContext(@Nullable GraphContext<T> base) {
        this.base = base;
        this.values = new HashMap();
        this.shapes = new HashMap();
    }

    public /* synthetic */ GraphContext(GraphContext graphContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            graphContext = null;
        }
        this(graphContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasValue(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (((Map)this.values).containsKey(name)) return true;
        GraphContext<T> graphContext = this.base;
        if (graphContext == null) return false;
        boolean bl = graphContext.hasValue(name);
        if (!bl) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasShape(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (((Map)this.shapes).containsKey(name)) return true;
        GraphContext<T> graphContext = this.base;
        if (graphContext == null) return false;
        boolean bl = graphContext.hasShape(name);
        if (!bl) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public final void putValue(@NotNull String name, @NotNull T value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (((Map)this.values).containsKey(name)) ** GOTO lbl-1000
        v0 = this.base;
        v1 = v0 != null ? !v0.hasValue(name) : true;
        if (v1) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        if (!v2) {
            $i$a$-require-GraphContext$putValue$1 = false;
            var3_4 = "'" + name + "' already exists in context values";
            throw new IllegalArgumentException(var3_4.toString());
        }
        ((Map)this.values).put(name, value);
    }

    @NotNull
    public final T getValue(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ONNXData oNNXData = (ONNXData)this.values.get(name);
        if (oNNXData == null) {
            GraphContext<T> graphContext = this.base;
            oNNXData = graphContext != null ? graphContext.getValue(name) : null;
        }
        if (oNNXData == null) {
            throw new IllegalStateException(("'" + name + "' not found in context values").toString());
        }
        return (T)oNNXData;
    }

    @Nullable
    public final T getOrNullValue(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ONNXData oNNXData = (ONNXData)this.values.get(name);
        if (oNNXData == null) {
            GraphContext<T> graphContext = this.base;
            oNNXData = graphContext != null ? graphContext.getOrNullValue(name) : null;
        }
        return (T)oNNXData;
    }

    /*
     * Unable to fully structure code
     */
    public final void putShape(@NotNull String name, int shape) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (((Map)this.shapes).containsKey(name)) ** GOTO lbl-1000
        v0 = this.base;
        v1 = v0 != null ? !v0.hasShape(name) : true;
        if (v1) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        if (!v2) {
            $i$a$-require-GraphContext$putShape$1 = false;
            var3_4 = "'" + name + "' already exists in context shapes";
            throw new IllegalArgumentException(var3_4.toString());
        }
        var3_5 = shape;
        ((Map)this.shapes).put(name, var3_5);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeValues(@NotNull Function1<? super String, Boolean> predicate) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Set<Map.Entry<String, T>> set = this.values.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Object k2 = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k2, (String)"<get-key>(...)");
            if (!((Boolean)predicate.invoke(k2)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allToRemove = (List)destination$iv$iv;
        Iterable $this$forEach$iv = allToRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            ((ONNXData)it.getValue()).close();
        }
        this.values.entrySet().removeAll(allToRemove);
    }

    public final int getShape(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Integer n = this.shapes.get(name);
        if (n == null) {
            GraphContext<T> graphContext = this.base;
            n = graphContext != null ? Integer.valueOf(graphContext.getShape(name)) : null;
        }
        if (n == null) {
            throw new IllegalStateException(("'" + name + "' not found in context shapes").toString());
        }
        return n;
    }

    public final void clear() {
        for (Map.Entry value : ((Map)this.values).entrySet()) {
            ((ONNXData)value.getValue()).close();
        }
        this.values.clear();
        this.shapes.clear();
    }

    @Override
    public void close() {
        for (Map.Entry value : ((Map)this.values).entrySet()) {
            ((ONNXData)value.getValue()).close();
        }
    }

    public final void mergeContext(@NotNull GraphContext<T> context2) {
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        this.values.putAll((Map)context2.values);
        this.shapes.putAll((Map<String, Integer>)context2.shapes);
    }

    public GraphContext() {
        this(null, 1, null);
    }
}

