/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.ui;

import com.intellij.execution.util.ListTableWithButtons;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenConfigurableBundle;
import org.jetbrains.idea.maven.server.MavenServerConnector;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.ui.ConnectorTable;
import org.jetbrains.idea.maven.statistics.MavenActionsUsagesCollector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0014\u0010\r\u001a\u0004\u0018\u00010\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0014J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0014J\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013H\u0014\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0014J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0010H\u0014J\u0012\u0010\u0018\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0002H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/idea/maven/server/ui/ConnectorTable;", "Lcom/intellij/execution/util/ListTableWithButtons;", "Lorg/jetbrains/idea/maven/server/MavenServerConnector;", "()V", "refresh", "Lcom/intellij/ui/AnActionButton;", "getRefresh", "()Lcom/intellij/ui/AnActionButton;", "stop", "getStop", "canDeleteElement", "", "selection", "cloneElement", "variable", "createAddAction", "Lcom/intellij/ui/AnActionButtonRunnable;", "createElement", "createExtraActions", "", "()[Lcom/intellij/ui/AnActionButton;", "createListModel", "Lcom/intellij/util/ui/ListTableModel;", "createRemoveAction", "isEmpty", "element", "TableColumn", "intellij.maven"})
public final class ConnectorTable
extends ListTableWithButtons<MavenServerConnector> {
    @NotNull
    private final AnActionButton stop;
    @NotNull
    private final AnActionButton refresh;

    public ConnectorTable() {
        String string = MavenConfigurableBundle.message("connector.ui.stop", new Object[0]);
        Icon icon = AllIcons.Debugger.KillProcess;
        this.stop = new AnActionButton(this, string, icon){
            final /* synthetic */ ConnectorTable this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                MavenActionsUsagesCollector.Companion.trigger(e.getProject(), MavenActionsUsagesCollector.KILL_MAVEN_CONNECTOR);
                MavenServerConnector mavenServerConnector = (MavenServerConnector)this.this$0.getTableView().getSelectedObject();
                if (mavenServerConnector == null) {
                    return;
                }
                MavenServerConnector connector = mavenServerConnector;
                MavenServerManager.getInstance().shutdownConnector(connector, true);
                this.this$0.refreshValues();
            }

            public void updateButton(@NotNull AnActionEvent e) {
                MavenServerConnector connector;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                MavenServerConnector mavenServerConnector = connector = (MavenServerConnector)this.this$0.getTableView().getSelectedObject();
                this.setEnabled((mavenServerConnector != null ? mavenServerConnector.getState() : null) == MavenServerConnector.State.RUNNING);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }
        };
        string = MavenConfigurableBundle.message("connector.ui.refresh", new Object[0]);
        icon = AllIcons.Actions.Refresh;
        this.refresh = new AnActionButton(this, string, icon){
            final /* synthetic */ ConnectorTable this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.getTableView().setModelAndUpdateColumns(this.this$0.createListModel());
                ConnectorTable.access$setModified(this.this$0);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }
        };
        this.getTableView().getSelectionModel().setSelectionMode(0);
        this.getTableView().getSelectionModel().addListSelectionListener(arg_0 -> ConnectorTable._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final AnActionButton getStop() {
        return this.stop;
    }

    @NotNull
    public final AnActionButton getRefresh() {
        return this.refresh;
    }

    @NotNull
    protected ListTableModel<MavenServerConnector> createListModel() {
        String string = MavenConfigurableBundle.message("connector.ui.project", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        TableColumn project2 = new TableColumn(string, (Function1<? super MavenServerConnector, String>)((Function1)createListModel.project.1.INSTANCE));
        String string2 = MavenConfigurableBundle.message("connector.ui.jdk", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        TableColumn jdk2 = new TableColumn(string2, (Function1<? super MavenServerConnector, String>)((Function1)createListModel.jdk.1.INSTANCE));
        String string3 = MavenConfigurableBundle.message("connector.ui.vmOptions", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        TableColumn vmopts2 = new TableColumn(string3, (Function1<? super MavenServerConnector, String>)((Function1)createListModel.vmopts.1.INSTANCE));
        String string4 = MavenConfigurableBundle.message("connector.ui.dir", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        TableColumn dir2 = new TableColumn(string4, (Function1<? super MavenServerConnector, String>)((Function1)createListModel.dir.1.INSTANCE));
        String string5 = MavenConfigurableBundle.message("connector.ui.maven", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        TableColumn maven2 = new TableColumn(string5, (Function1<? super MavenServerConnector, String>)((Function1)createListModel.maven.1.INSTANCE));
        String string6 = MavenConfigurableBundle.message("connector.ui.state", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
        TableColumn state2 = new TableColumn(string6, (Function1<? super MavenServerConnector, String>)((Function1)createListModel.state.1.INSTANCE));
        String string7 = MavenConfigurableBundle.message("connector.ui.type", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
        TableColumn type2 = new TableColumn(string7, (Function1<? super MavenServerConnector, String>)((Function1)createListModel.type.1.INSTANCE));
        TableColumn[] tableColumnArray = new TableColumn[]{project2, dir2, type2, maven2, state2};
        TableColumn[] columnInfos = tableColumnArray;
        ColumnInfo[] columnInfoArray = (ColumnInfo[])columnInfos;
        Collection<MavenServerConnector> collection = MavenServerManager.getInstance().getAllConnectors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getAllConnectors(...)");
        return new ListTableModel(columnInfoArray, CollectionsKt.toList((Iterable)collection), 3, SortOrder.DESCENDING);
    }

    @NotNull
    protected AnActionButton[] createExtraActions() {
        AnActionButton[] anActionButtonArray = new AnActionButton[]{this.refresh, this.stop};
        return anActionButtonArray;
    }

    @Nullable
    protected MavenServerConnector createElement() {
        return null;
    }

    protected boolean isEmpty(@Nullable MavenServerConnector element) {
        return element == null;
    }

    protected boolean canDeleteElement(@NotNull MavenServerConnector selection) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        return false;
    }

    @Nullable
    protected AnActionButtonRunnable createRemoveAction() {
        return null;
    }

    @Nullable
    protected AnActionButtonRunnable createAddAction() {
        return null;
    }

    @Nullable
    protected MavenServerConnector cloneElement(@Nullable MavenServerConnector variable) {
        return null;
    }

    private static final void _init_$lambda$0(ConnectorTable this$0, ListSelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (it.getValueIsAdjusting()) {
            return;
        }
        MavenServerConnector connector = (MavenServerConnector)this$0.getTableView().getSelectedObject();
        MavenServerConnector mavenServerConnector = connector;
        this$0.stop.setEnabled((mavenServerConnector != null ? mavenServerConnector.getState() : null) == MavenServerConnector.State.RUNNING);
    }

    public static final /* synthetic */ void access$setModified(ConnectorTable $this) {
        $this.setModified();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/maven/server/ui/ConnectorTable$TableColumn;", "Lcom/intellij/execution/util/ListTableWithButtons$ElementsColumnInfoBase;", "Lorg/jetbrains/idea/maven/server/MavenServerConnector;", "name", "", "supplier", "Lkotlin/Function1;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getSupplier", "()Lkotlin/jvm/functions/Function1;", "getDescription", "element", "valueOf", "item", "intellij.maven"})
    private static final class TableColumn
    extends ListTableWithButtons.ElementsColumnInfoBase<MavenServerConnector> {
        @NotNull
        private final Function1<MavenServerConnector, String> supplier;

        public TableColumn(@NlsContexts.ColumnName @NotNull String name, @NotNull Function1<? super MavenServerConnector, String> supplier) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            super(name);
            this.supplier = supplier;
        }

        @NotNull
        public final Function1<MavenServerConnector, String> getSupplier() {
            return this.supplier;
        }

        @Nullable
        protected String getDescription(@Nullable MavenServerConnector element) {
            return null;
        }

        @NotNull
        public String valueOf(@NotNull MavenServerConnector item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return (String)this.supplier.invoke((Object)item);
        }
    }
}

