/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.model.SideEffectGuard;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.indices.IndicesBundle;
import org.jetbrains.idea.maven.indices.IndicesContentUpdateRequest;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenIndexHolder;
import org.jetbrains.idea.maven.indices.MavenIndicesManager;
import org.jetbrains.idea.maven.indices.MavenSystemIndicesManager;
import org.jetbrains.idea.maven.model.MavenRepositoryInfo;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenRehighlighter;

@ApiStatus.Internal
public final class MavenIndexUpdateManager
implements Disposable {
    private final Object myUpdatingIndicesLock = new Object();
    private final BackgroundTaskQueue myUpdatingQueue = new BackgroundTaskQueue(null, IndicesBundle.message("maven.indices.updating", new Object[0]));
    private final MergingUpdateQueue myUpdateQueueList = new MergingUpdateQueue(this.getClass().getName(), 1000, true, null, (Disposable)this, null, false).usePassThroughInUnitTestMode();
    private volatile String myCurrentUpdateIndexUrl;

    public void dispose() {
        this.myUpdatingQueue.clear();
    }

    void scheduleUpdateIndicesList(@NotNull Project project2, @Nullable Consumer<? super List<MavenIndex>> consumer) {
        if (project2 == null) {
            MavenIndexUpdateManager.$$$reportNull$$$0(0);
        }
        this.myUpdateQueueList.queue(Update.create((Object)this, () -> {
            MavenIndicesManager indicesManager = MavenIndicesManager.getInstance(project2);
            indicesManager.updateIndicesListSync();
            if (project2.isDisposed()) {
                return;
            }
            MavenIndexHolder indexHolder = indicesManager.getIndex();
            MavenIndex localIndex = indexHolder.getLocalIndex();
            if (localIndex != null && localIndex.getUpdateTimestamp() == -1L && Registry.is((String)"maven.auto.update.local.index")) {
                this.scheduleUpdateContent(project2, IndicesContentUpdateRequest.background(List.of(localIndex.getRepository())));
            }
            if (consumer != null) {
                consumer.consume(indexHolder.getIndices());
            }
        }));
    }

    CompletableFuture<?> scheduleUpdateContent(@NotNull Project project2, IndicesContentUpdateRequest request) {
        if (project2 == null) {
            MavenIndexUpdateManager.$$$reportNull$$$0(1);
        }
        SideEffectGuard.checkSideEffectAllowed((SideEffectGuard.EffectType)SideEffectGuard.EffectType.PROJECT_MODEL);
        if (request.getShowProgress()) {
            return this.runIndexUpdateWithProgress(project2, request);
        }
        return MavenIndexUpdateManager.runIndexUpdateInBackgroundWithoutProgress(project2, request);
    }

    private static CompletableFuture<?> runIndexUpdateInBackgroundWithoutProgress(Project project2, IndicesContentUpdateRequest request) {
        MavenProgressIndicator indicator = new MavenProgressIndicator(null, null);
        try {
            MavenIndexUpdateManager.doUpdateIndicesContent(project2, request, indicator);
        }
        catch (MavenProcessCanceledException e) {
            return CompletableFuture.failedFuture(e);
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<?> runIndexUpdateWithProgress(final @NotNull Project project2, final IndicesContentUpdateRequest request) {
        if (project2 == null) {
            MavenIndexUpdateManager.$$$reportNull$$$0(2);
        }
        final CompletableFuture promise2 = new CompletableFuture();
        this.myUpdatingQueue.run(new Task.Backgroundable(project2, IndicesBundle.message("maven.indices.updating", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    indicator.setIndeterminate(false);
                    MavenIndexUpdateManager.doUpdateIndicesContent(project2, request, new MavenProgressIndicator(null, indicator, null));
                }
                catch (MavenProcessCanceledException mavenProcessCanceledException) {
                }
                finally {
                    promise2.complete(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/maven/indices/MavenIndexUpdateManager$1", "run"));
            }
        });
        return promise2;
    }

    private static void doUpdateIndicesContent(@NotNull Project project2, @NotNull IndicesContentUpdateRequest request, @NotNull MavenProgressIndicator indicator) throws MavenProcessCanceledException {
        if (project2 == null) {
            MavenIndexUpdateManager.$$$reportNull$$$0(3);
        }
        if (request == null) {
            MavenIndexUpdateManager.$$$reportNull$$$0(4);
        }
        if (indicator == null) {
            MavenIndexUpdateManager.$$$reportNull$$$0(5);
        }
        MavenSystemIndicesManager indicesManager = MavenSystemIndicesManager.getInstance();
        for (MavenRepositoryInfo repo : request.getIndicesToUpdate()) {
            if (indicator.isCanceled()) {
                return;
            }
            indicesManager.updateIndexContentSync(repo, request.getFull(), request.getExplicit(), indicator);
            indicator.setText(IndicesBundle.message("maven.indices.updating.index", repo.getId(), repo.getUrl()));
        }
        MavenRehighlighter.rehighlight(project2);
    }

    @TestOnly
    void waitForBackgroundTasksInTests() {
        while (!this.myUpdatingQueue.isEmpty()) {
            UIUtil.dispatchAllInvocationEvents();
        }
        try {
            this.myUpdateQueueList.waitForAllExecuted(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    private static MavenGeneralSettings getMavenSettings(@NotNull Project project2, @NotNull MavenProgressIndicator indicator) throws MavenProcessCanceledException {
        MavenGeneralSettings settings;
        if (project2 == null) {
            MavenIndexUpdateManager.$$$reportNull$$$0(6);
        }
        if (indicator == null) {
            MavenIndexUpdateManager.$$$reportNull$$$0(7);
        }
        if ((settings = (MavenGeneralSettings)ReadAction.compute(() -> project2.isDisposed() ? null : MavenProjectsManager.getInstance(project2).getGeneralSettings().clone())) == null) {
            indicator.cancel();
            indicator.checkCanceled();
        }
        return settings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/indices/MavenIndexUpdateManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleUpdateIndicesList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleUpdateContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "runIndexUpdateWithProgress";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doUpdateIndicesContent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getMavenSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum IndexUpdatingState {
        IDLE,
        WAITING,
        UPDATING;

    }
}

