/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapterInterface;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.Path;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class MavenRootModelAdapter
implements MavenRootModelAdapterInterface {
    private final MavenRootModelAdapterInterface myDelegate;

    public MavenRootModelAdapter(MavenRootModelAdapterInterface delegate) {
        this.myDelegate = delegate;
    }

    @Override
    public void init(boolean isNewlyCreatedModule) {
        this.myDelegate.init(isNewlyCreatedModule);
    }

    @Override
    public ModifiableRootModel getRootModel() {
        return this.myDelegate.getRootModel();
    }

    @Override
    public String @NotNull [] getSourceRootUrls(boolean includingTests) {
        String[] stringArray = this.myDelegate.getSourceRootUrls(includingTests);
        if (stringArray == null) {
            MavenRootModelAdapter.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    @Override
    public Module getModule() {
        return this.myDelegate.getModule();
    }

    @Override
    public void clearSourceFolders() {
        this.myDelegate.clearSourceFolders();
    }

    @Override
    public <P extends JpsElement> void addSourceFolder(String path2, JpsModuleSourceRootType<P> rootType) {
        this.myDelegate.addSourceFolder(path2, rootType);
    }

    @Override
    public void addGeneratedJavaSourceFolder(String path2, JavaSourceRootType rootType, boolean ifNotEmpty) {
        this.myDelegate.addGeneratedJavaSourceFolder(path2, rootType, ifNotEmpty);
    }

    @Override
    public void addGeneratedJavaSourceFolder(String path2, JavaSourceRootType rootType) {
        this.myDelegate.addGeneratedJavaSourceFolder(path2, rootType);
    }

    @Override
    public boolean hasRegisteredSourceSubfolder(@NotNull File f) {
        if (f == null) {
            MavenRootModelAdapter.$$$reportNull$$$0(1);
        }
        return this.myDelegate.hasRegisteredSourceSubfolder(f);
    }

    @Override
    @Nullable
    public SourceFolder getSourceFolder(File folder) {
        return this.myDelegate.getSourceFolder(folder);
    }

    @Override
    public boolean isAlreadyExcluded(File f) {
        return this.myDelegate.isAlreadyExcluded(f);
    }

    @Override
    public void addExcludedFolder(String path2) {
        this.myDelegate.addExcludedFolder(path2);
    }

    @Override
    public void unregisterAll(String path2, boolean under, boolean unregisterSources) {
        this.myDelegate.unregisterAll(path2, under, unregisterSources);
    }

    @Override
    public boolean hasCollision(String sourceRootPath) {
        return this.myDelegate.hasCollision(sourceRootPath);
    }

    @Override
    public void useModuleOutput(String production, String test) {
        this.myDelegate.useModuleOutput(production, test);
    }

    @Override
    public Path toPath(String path2) {
        return this.myDelegate.toPath(path2);
    }

    @Override
    public void addModuleDependency(@NotNull String moduleName, @NotNull DependencyScope scope, boolean testJar) {
        if (moduleName == null) {
            MavenRootModelAdapter.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            MavenRootModelAdapter.$$$reportNull$$$0(3);
        }
        this.myDelegate.addModuleDependency(moduleName, scope, testJar);
    }

    @Override
    @Nullable
    public Module findModuleByName(String moduleName) {
        return this.myDelegate.findModuleByName(moduleName);
    }

    @Override
    public void addSystemDependency(MavenArtifact artifact, DependencyScope scope) {
        this.myDelegate.addSystemDependency(artifact, scope);
    }

    @Override
    public LibraryOrderEntry addLibraryDependency(MavenArtifact artifact, DependencyScope scope, IdeModifiableModelsProvider provider, MavenProject project2) {
        return this.myDelegate.addLibraryDependency(artifact, scope, provider, project2);
    }

    @Override
    public Library findLibrary(@NotNull MavenArtifact artifact) {
        if (artifact == null) {
            MavenRootModelAdapter.$$$reportNull$$$0(4);
        }
        return this.myDelegate.findLibrary(artifact);
    }

    @Override
    public void setLanguageLevel(LanguageLevel level) {
        this.myDelegate.setLanguageLevel(level);
    }

    public static boolean isChangedByUser(Library library) {
        String[] classRoots = library.getUrls(OrderRootType.CLASSES);
        if (classRoots.length != 1) {
            return true;
        }
        String classes = classRoots[0];
        if (!classes.endsWith("!/")) {
            return true;
        }
        int dotPos = classes.lastIndexOf("/", classes.length() - 2);
        if (dotPos == -1) {
            return true;
        }
        String pathToJar = classes.substring(0, dotPos);
        if (MavenRootModelAdapter.hasUserPaths(OrderRootType.SOURCES, library, pathToJar)) {
            return true;
        }
        return MavenRootModelAdapter.hasUserPaths(JavadocOrderRootType.getInstance(), library, pathToJar);
    }

    private static boolean hasUserPaths(OrderRootType rootType, Library library, String pathToJar) {
        String[] sources;
        for (String each : sources = library.getUrls(rootType)) {
            if (FileUtil.startsWith((String)each, (String)pathToJar)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMavenLibrary(@Nullable Library library) {
        return library != null && MavenArtifact.isMavenLibrary((String)library.getName());
    }

    public static ProjectModelExternalSource getMavenExternalSource() {
        return ExternalProjectSystemRegistry.getInstance().getSourceById("Maven");
    }

    @Nullable
    public static OrderEntry findLibraryEntry(@NotNull Module m, @NotNull MavenArtifact artifact) {
        if (m == null) {
            MavenRootModelAdapter.$$$reportNull$$$0(5);
        }
        if (artifact == null) {
            MavenRootModelAdapter.$$$reportNull$$$0(6);
        }
        String name = artifact.getLibraryName();
        for (OrderEntry each : ModuleRootManager.getInstance((Module)m).getOrderEntries()) {
            if (!(each instanceof LibraryOrderEntry) || !name.equals(((LibraryOrderEntry)each).getLibraryName())) continue;
            return each;
        }
        return null;
    }

    @Nullable
    public static MavenArtifact findArtifact(@NotNull MavenProject project2, @Nullable Library library) {
        if (project2 == null) {
            MavenRootModelAdapter.$$$reportNull$$$0(7);
        }
        if (library == null) {
            return null;
        }
        String name = library.getName();
        if (!MavenArtifact.isMavenLibrary((String)name)) {
            return null;
        }
        for (MavenArtifact each : project2.getDependencies()) {
            if (!each.getLibraryName().equals(name)) continue;
            return each;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/importing/MavenRootModelAdapter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRootUrls";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/importing/MavenRootModelAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasRegisteredSourceSubfolder";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addModuleDependency";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findLibrary";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryEntry";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findArtifact";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

