/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemModulePropertyManagerBridge;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.EntityStorageSnapshot;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenProjectImporterBase;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenUtil;

public abstract class MavenProjectImporterLegacyBase
extends MavenProjectImporterBase {
    protected final ModifiableModuleModel myModuleModel;
    protected volatile Map<MavenProject, MavenProjectChanges> myProjectsToImportWithChanges;

    public MavenProjectImporterLegacyBase(Project project2, MavenProjectsTree projectsTree, MavenImportingSettings importingSettings, Map<MavenProject, MavenProjectChanges> projectsToImportWithChanges, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (modelsProvider == null) {
            MavenProjectImporterLegacyBase.$$$reportNull$$$0(0);
        }
        super(project2, projectsTree, importingSettings, modelsProvider);
        this.myProjectsToImportWithChanges = projectsToImportWithChanges;
        this.myModuleModel = this.myModelsProvider.getModifiableModuleModel();
    }

    protected void finalizeImport(List<Module> obsoleteModules) {
        MavenUtil.invokeAndWaitWriteAction(this.myProject, () -> this.setMavenizedModules(obsoleteModules, false));
        MavenUtil.invokeAndWaitWriteAction(this.myProject, () -> this.myModelsProvider.dispose());
    }

    protected void setMavenizedModules(Collection<Module> modules, boolean mavenized) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        EntityStorageSnapshot initialStorage = WorkspaceModel.getInstance((Project)this.myProject).getCurrentSnapshot();
        MutableEntityStorage storageBuilder = MutableEntityStorage.from((EntityStorageSnapshot)initialStorage.toSnapshot());
        for (Module module2 : modules) {
            if (module2.isDisposed()) continue;
            ExternalSystemModulePropertyManager modulePropertyManager = ExternalSystemModulePropertyManager.getInstance((Module)module2);
            if (modulePropertyManager instanceof ExternalSystemModulePropertyManagerBridge && module2 instanceof ModuleBridge && ((ModuleBridge)module2).getDiff() == null) {
                ((ExternalSystemModulePropertyManagerBridge)modulePropertyManager).setMavenized(mavenized, null, storageBuilder);
                continue;
            }
            modulePropertyManager.setMavenized(mavenized);
        }
        WorkspaceModel.getInstance((Project)this.myProject).updateProjectModel("Set mavenized modules", builder -> {
            builder.addDiff(storageBuilder);
            return null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/idea/maven/importing/MavenProjectImporterLegacyBase", "<init>"));
    }
}

