/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenImportUtil;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenLegacyFoldersImporter;
import org.jetbrains.idea.maven.importing.MavenLegacyModuleImporter;
import org.jetbrains.idea.maven.importing.MavenPomPathModuleService;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapterLegacyImpl;
import org.jetbrains.idea.maven.importing.StandardMavenModuleType;
import org.jetbrains.idea.maven.importing.tree.MavenTreeModuleImportData;
import org.jetbrains.idea.maven.importing.tree.dependency.BaseDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.LibraryDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.MavenImportDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.ModuleDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.SystemDependency;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.SupportedRequestType;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 (2\u00020\u0001:\u0002()BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\u0011J\u0018\u0010\u001b\u001a\u00020\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020\u0013H\u0002J\u001a\u0010\u001f\u001a\u00020\u00132\u0010\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"0!H\u0002J\b\u0010#\u001a\u00020\u0013H\u0002J\b\u0010$\u001a\u00020\u0013H\u0002J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020\u0013H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenLegacyModuleImporter;", "", "myModule", "Lcom/intellij/openapi/module/Module;", "myMavenTree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "myMavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "myMavenProjectToModuleName", "", "", "mySettings", "Lorg/jetbrains/idea/maven/project/MavenImportingSettings;", "myModifiableModelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "(Lcom/intellij/openapi/module/Module;Lorg/jetbrains/idea/maven/project/MavenProjectsTree;Lorg/jetbrains/idea/maven/project/MavenProject;Ljava/util/Map;Lorg/jetbrains/idea/maven/project/MavenImportingSettings;Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;)V", "myRootModelAdapter", "Lorg/jetbrains/idea/maven/importing/MavenRootModelAdapter;", "addAttachArtifactDependency", "", "buildHelperCfg", "Lorg/jdom/Element;", "scope", "Lcom/intellij/openapi/roots/DependencyScope;", "mavenProject", "artifact", "Lorg/jetbrains/idea/maven/model/MavenArtifact;", "config", "mavenRootModelAdapter", "importData", "Lorg/jetbrains/idea/maven/importing/tree/MavenTreeModuleImportData;", "configDependencies", "dependencies", "", "Lorg/jetbrains/idea/maven/importing/tree/dependency/MavenImportDependency;", "configFolders", "configLanguageLevel", "level", "Lcom/intellij/pom/java/LanguageLevel;", "configSurefirePlugin", "Companion", "ExtensionImporter", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenLegacyModuleImporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenLegacyModuleImporter.kt\norg/jetbrains/idea/maven/importing/MavenLegacyModuleImporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,399:1\n1#2:400\n*E\n"})
public final class MavenLegacyModuleImporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Module myModule;
    @NotNull
    private final MavenProjectsTree myMavenTree;
    @NotNull
    private final MavenProject myMavenProject;
    @NotNull
    private final Map<MavenProject, String> myMavenProjectToModuleName;
    @NotNull
    private final MavenImportingSettings mySettings;
    @NotNull
    private final IdeModifiableModelsProvider myModifiableModelsProvider;
    @Nullable
    private MavenRootModelAdapter myRootModelAdapter;
    @NotNull
    public static final String SUREFIRE_PLUGIN_LIBRARY_NAME = "maven-surefire-plugin urls";
    @JvmField
    @NotNull
    public static final Set<String> IMPORTED_CLASSIFIERS = SetsKt.setOf((Object)"client");

    public MavenLegacyModuleImporter(@NotNull Module myModule, @NotNull MavenProjectsTree myMavenTree, @NotNull MavenProject myMavenProject, @NotNull Map<MavenProject, String> myMavenProjectToModuleName, @NotNull MavenImportingSettings mySettings, @NotNull IdeModifiableModelsProvider myModifiableModelsProvider) {
        Intrinsics.checkNotNullParameter((Object)myModule, (String)"myModule");
        Intrinsics.checkNotNullParameter((Object)myMavenTree, (String)"myMavenTree");
        Intrinsics.checkNotNullParameter((Object)myMavenProject, (String)"myMavenProject");
        Intrinsics.checkNotNullParameter(myMavenProjectToModuleName, (String)"myMavenProjectToModuleName");
        Intrinsics.checkNotNullParameter((Object)mySettings, (String)"mySettings");
        Intrinsics.checkNotNullParameter((Object)myModifiableModelsProvider, (String)"myModifiableModelsProvider");
        this.myModule = myModule;
        this.myMavenTree = myMavenTree;
        this.myMavenProject = myMavenProject;
        this.myMavenProjectToModuleName = myMavenProjectToModuleName;
        this.mySettings = mySettings;
        this.myModifiableModelsProvider = myModifiableModelsProvider;
        VirtualFile virtualFile = this.myMavenProject.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        VirtualFile pomFile = virtualFile;
        if (!FileUtil.namesEqual((String)"pom", (String)pomFile.getNameWithoutExtension())) {
            MavenPomPathModuleService.Companion.getInstance(this.myModule).setPomFileUrl(pomFile.getUrl());
        }
    }

    public final void config(@Nullable MavenRootModelAdapter mavenRootModelAdapter) {
        this.myRootModelAdapter = mavenRootModelAdapter;
        this.configFolders();
        this.configDependencies();
        this.configLanguageLevel();
    }

    public final void config(@Nullable MavenRootModelAdapter mavenRootModelAdapter, @NotNull MavenTreeModuleImportData importData) {
        Intrinsics.checkNotNullParameter((Object)importData, (String)"importData");
        this.myRootModelAdapter = mavenRootModelAdapter;
        this.configFolders();
        this.configDependencies(importData.getDependencies());
        LanguageLevel languageLevel = MavenImportUtil.getLanguageLevel(this.myMavenProject, () -> MavenLegacyModuleImporter.config$lambda$0(importData));
        Intrinsics.checkNotNullExpressionValue((Object)languageLevel, (String)"getLanguageLevel(...)");
        LanguageLevel level = languageLevel;
        this.configLanguageLevel(level);
    }

    private final void configFolders() {
        new MavenLegacyFoldersImporter(this.myMavenProject, this.mySettings, this.myRootModelAdapter).config();
    }

    private final void configDependencies() {
        Set dependencyTypesFromSettings = new HashSet();
        if (!((Boolean)ReadAction.compute(() -> MavenLegacyModuleImporter.configDependencies$lambda$1(this, dependencyTypesFromSettings))).booleanValue()) {
            return;
        }
        for (MavenArtifact d : this.myMavenProject.getDependencies()) {
            MavenArtifact artifact = null;
            artifact = d;
            String dependencyType = artifact.getType();
            if (!dependencyTypesFromSettings.contains(dependencyType) && !this.myMavenProject.getDependencyTypesFromImporters(SupportedRequestType.FOR_IMPORT).contains(dependencyType)) continue;
            DependencyScope scope = Companion.selectScope(artifact.getScope());
            MavenProject depProject = this.myMavenTree.findProject(artifact.getMavenId());
            if (depProject != null) {
                String classifier;
                if (depProject == this.myMavenProject) continue;
                String moduleName = this.myMavenProjectToModuleName.get(depProject);
                if (moduleName == null || this.myMavenTree.isIgnored(depProject)) {
                    MavenArtifact mavenArtifact = artifact;
                    Intrinsics.checkNotNullExpressionValue((Object)mavenArtifact, (String)"element");
                    MavenArtifact projectsArtifactInRepository = Companion.createCopyForLocalRepo(mavenArtifact, this.myMavenProject);
                    MavenRootModelAdapter mavenRootModelAdapter = this.myRootModelAdapter;
                    Intrinsics.checkNotNull((Object)mavenRootModelAdapter);
                    mavenRootModelAdapter.addLibraryDependency(projectsArtifactInRepository, scope, this.myModifiableModelsProvider, this.myMavenProject);
                    continue;
                }
                boolean isTestJar = Intrinsics.areEqual((Object)"test-jar", (Object)dependencyType) || Intrinsics.areEqual((Object)"tests", (Object)artifact.getClassifier());
                MavenRootModelAdapter mavenRootModelAdapter = this.myRootModelAdapter;
                Intrinsics.checkNotNull((Object)mavenRootModelAdapter);
                mavenRootModelAdapter.addModuleDependency(moduleName, scope, isTestJar);
                Element buildHelperCfg = depProject.getPluginGoalConfiguration("org.codehaus.mojo", "build-helper-maven-plugin", "attach-artifact");
                if (buildHelperCfg != null) {
                    Element it;
                    boolean bl = false;
                    MavenArtifact mavenArtifact = artifact;
                    Intrinsics.checkNotNullExpressionValue((Object)mavenArtifact, (String)"element");
                    this.addAttachArtifactDependency(it, scope, depProject, mavenArtifact);
                }
                if ((classifier = artifact.getClassifier()) == null || !IMPORTED_CLASSIFIERS.contains(classifier) || isTestJar || Intrinsics.areEqual((Object)"system", (Object)artifact.getScope()) || Intrinsics.areEqual((Object)"false", (Object)System.getProperty("idea.maven.classifier.dep"))) continue;
                MavenArtifact mavenArtifact = artifact;
                Intrinsics.checkNotNullExpressionValue((Object)mavenArtifact, (String)"element");
                MavenArtifact a = Companion.createCopyForLocalRepo(mavenArtifact, this.myMavenProject);
                MavenRootModelAdapter mavenRootModelAdapter2 = this.myRootModelAdapter;
                Intrinsics.checkNotNull((Object)mavenRootModelAdapter2);
                mavenRootModelAdapter2.addLibraryDependency(a, scope, this.myModifiableModelsProvider, this.myMavenProject);
                continue;
            }
            if (Intrinsics.areEqual((Object)"system", (Object)artifact.getScope())) {
                MavenRootModelAdapter mavenRootModelAdapter = this.myRootModelAdapter;
                Intrinsics.checkNotNull((Object)mavenRootModelAdapter);
                mavenRootModelAdapter.addSystemDependency(artifact, scope);
                continue;
            }
            if (Intrinsics.areEqual((Object)"bundle", (Object)dependencyType)) {
                artifact = new MavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getBaseVersion(), "jar", artifact.getClassifier(), artifact.getScope(), artifact.isOptional(), "jar", null, this.myMavenProject.getLocalRepository(), false, false);
            }
            MavenRootModelAdapter mavenRootModelAdapter = this.myRootModelAdapter;
            Intrinsics.checkNotNull((Object)mavenRootModelAdapter);
            LibraryOrderEntry libraryOrderEntry = mavenRootModelAdapter.addLibraryDependency(artifact, scope, this.myModifiableModelsProvider, this.myMavenProject);
            ProjectId projectId = new ProjectId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            this.myModifiableModelsProvider.trySubstitute(this.myModule, libraryOrderEntry, (ProjectCoordinate)projectId);
        }
        this.configSurefirePlugin();
    }

    private final void configDependencies(List<? extends MavenImportDependency<?>> dependencies) {
        for (MavenImportDependency<?> dependency : dependencies) {
            MavenImportDependency<?> mavenImportDependency = dependency;
            if (mavenImportDependency instanceof SystemDependency) {
                MavenRootModelAdapter mavenRootModelAdapter = this.myRootModelAdapter;
                Intrinsics.checkNotNull((Object)mavenRootModelAdapter);
                mavenRootModelAdapter.addSystemDependency((MavenArtifact)((SystemDependency)dependency).getArtifact(), dependency.getScope());
                continue;
            }
            if (mavenImportDependency instanceof LibraryDependency) {
                MavenRootModelAdapter mavenRootModelAdapter = this.myRootModelAdapter;
                Intrinsics.checkNotNull((Object)mavenRootModelAdapter);
                mavenRootModelAdapter.addLibraryDependency((MavenArtifact)((LibraryDependency)dependency).getArtifact(), dependency.getScope(), this.myModifiableModelsProvider, this.myMavenProject);
                continue;
            }
            if (mavenImportDependency instanceof ModuleDependency) {
                MavenRootModelAdapter mavenRootModelAdapter = this.myRootModelAdapter;
                Intrinsics.checkNotNull((Object)mavenRootModelAdapter);
                mavenRootModelAdapter.addModuleDependency((String)((ModuleDependency)dependency).getArtifact(), dependency.getScope(), ((ModuleDependency)dependency).isTestJar());
                continue;
            }
            if (!(mavenImportDependency instanceof BaseDependency)) continue;
            Object t = ((BaseDependency)dependency).getArtifact();
            Intrinsics.checkNotNullExpressionValue(t, (String)"getArtifact(...)");
            MavenArtifact artifact = (MavenArtifact)t;
            MavenRootModelAdapter mavenRootModelAdapter = this.myRootModelAdapter;
            Intrinsics.checkNotNull((Object)mavenRootModelAdapter);
            LibraryOrderEntry libraryOrderEntry = mavenRootModelAdapter.addLibraryDependency(artifact, dependency.getScope(), this.myModifiableModelsProvider, this.myMavenProject);
            this.myModifiableModelsProvider.trySubstitute(this.myModule, libraryOrderEntry, (ProjectCoordinate)new ProjectId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
        }
    }

    private final void configSurefirePlugin() {
        MavenRootModelAdapter mavenRootModelAdapter = this.myRootModelAdapter;
        Intrinsics.checkNotNull((Object)mavenRootModelAdapter);
        LibraryTable libraryTable = mavenRootModelAdapter.getRootModel().getModuleLibraryTable();
        Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"getModuleLibraryTable(...)");
        LibraryTable moduleLibraryTable = libraryTable;
        Library library = moduleLibraryTable.getLibraryByName(SUREFIRE_PLUGIN_LIBRARY_NAME);
        if (library != null) {
            moduleLibraryTable.removeLibrary(library);
        }
    }

    private final void addAttachArtifactDependency(Element buildHelperCfg, DependencyScope scope, MavenProject mavenProject2, MavenArtifact artifact) {
        Library.ModifiableModel libraryModel = null;
        for (Element artifactsElement : buildHelperCfg.getChildren("artifacts")) {
            for (Element artifactElement : artifactsElement.getChildren("artifact")) {
                String filePath;
                String typeString = artifactElement.getChildTextTrim("type");
                if (typeString != null && !Intrinsics.areEqual((Object)typeString, (Object)"jar")) continue;
                OrderRootType rootType = OrderRootType.CLASSES;
                String classifier = artifactElement.getChildTextTrim("classifier");
                if (Intrinsics.areEqual((Object)"sources", (Object)classifier)) {
                    rootType = OrderRootType.SOURCES;
                } else if (Intrinsics.areEqual((Object)"javadoc", (Object)classifier)) {
                    rootType = JavadocOrderRootType.getInstance();
                }
                if (StringUtil.isEmpty((String)(filePath = artifactElement.getChildTextTrim("file")))) continue;
                VirtualFile virtualFile = VfsUtil.findRelativeFile((String)filePath, (VirtualFile)mavenProject2.getDirectoryFile());
                if (virtualFile == null) continue;
                VirtualFile file = virtualFile;
                file = JarFileSystem.getInstance().getJarRootForLocalFile(file);
                if (file == null) continue;
                if (libraryModel == null) {
                    LibraryOrderEntry entry;
                    String libraryName = Companion.getAttachedJarsLibName(artifact);
                    Library library = this.myModifiableModelsProvider.getLibraryByName(libraryName);
                    if (library == null) {
                        library = this.myModifiableModelsProvider.createLibrary(libraryName, MavenRootModelAdapter.getMavenExternalSource());
                    }
                    libraryModel = this.myModifiableModelsProvider.getModifiableLibraryModel(library);
                    MavenRootModelAdapter mavenRootModelAdapter = this.myRootModelAdapter;
                    Intrinsics.checkNotNull((Object)mavenRootModelAdapter);
                    ModifiableRootModel modifiableRootModel = mavenRootModelAdapter.getRootModel();
                    Library library2 = library;
                    Intrinsics.checkNotNull((Object)library2);
                    Intrinsics.checkNotNullExpressionValue((Object)modifiableRootModel.addLibraryEntry(library2), (String)"addLibraryEntry(...)");
                    entry.setScope(scope);
                }
                Library.ModifiableModel modifiableModel = libraryModel;
                if (modifiableModel == null) continue;
                OrderRootType orderRootType = rootType;
                Intrinsics.checkNotNull((Object)orderRootType);
                modifiableModel.addRoot(file, orderRootType);
            }
        }
    }

    private final void configLanguageLevel() {
        if (StringsKt.equals((String)"false", (String)System.getProperty("idea.maven.configure.language.level"), (boolean)true)) {
            return;
        }
        LanguageLevel level = Companion.getLanguageLevel(this.myMavenProject);
        MavenRootModelAdapter mavenRootModelAdapter = this.myRootModelAdapter;
        Intrinsics.checkNotNull((Object)mavenRootModelAdapter);
        mavenRootModelAdapter.setLanguageLevel(level);
    }

    private final void configLanguageLevel(LanguageLevel level) {
        if (StringsKt.equals((String)"false", (String)System.getProperty("idea.maven.configure.language.level"), (boolean)true)) {
            return;
        }
        MavenRootModelAdapter mavenRootModelAdapter = this.myRootModelAdapter;
        Intrinsics.checkNotNull((Object)mavenRootModelAdapter);
        mavenRootModelAdapter.setLanguageLevel(level);
    }

    private static final LanguageLevel config$lambda$0(MavenTreeModuleImportData $importData) {
        Intrinsics.checkNotNullParameter((Object)$importData, (String)"$importData");
        return $importData.getModuleData().getSourceLanguageLevel();
    }

    private static final Boolean configDependencies$lambda$1(MavenLegacyModuleImporter this$0, Set $dependencyTypesFromSettings) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$dependencyTypesFromSettings, (String)"$dependencyTypesFromSettings");
        Project project2 = this$0.myModule.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        if (project3.isDisposed()) {
            return false;
        }
        Set<String> set = MavenProjectsManager.getInstance(project3).getImportingSettings().getDependencyTypesAsSet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getDependencyTypesAsSet(...)");
        $dependencyTypesFromSettings.addAll((Collection)set);
        return true;
    }

    @JvmStatic
    @NotNull
    public static final MavenArtifact createCopyForLocalRepo(@NotNull MavenArtifact artifact, @NotNull MavenProject project2) {
        return Companion.createCopyForLocalRepo(artifact, project2);
    }

    @JvmStatic
    @NotNull
    public static final String getAttachedJarsLibName(@NotNull MavenArtifact artifact) {
        return Companion.getAttachedJarsLibName(artifact);
    }

    @JvmStatic
    @NotNull
    public static final DependencyScope selectScope(@Nullable String mavenScope) {
        return Companion.selectScope(mavenScope);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\bH\u0007J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0007J\u0012\u0010\u0010\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0007J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u0007R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenLegacyModuleImporter$Companion;", "", "()V", "IMPORTED_CLASSIFIERS", "", "", "SUREFIRE_PLUGIN_LIBRARY_NAME", "createCopyForLocalRepo", "Lorg/jetbrains/idea/maven/model/MavenArtifact;", "artifact", "project", "Lorg/jetbrains/idea/maven/project/MavenProject;", "getAttachedJarsLibName", "getDefaultLevel", "Lcom/intellij/pom/java/LanguageLevel;", "mavenProject", "getLanguageLevel", "selectScope", "Lcom/intellij/openapi/roots/DependencyScope;", "mavenScope", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final MavenArtifact createCopyForLocalRepo(@NotNull MavenArtifact artifact, @NotNull MavenProject project2) {
            Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return new MavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getBaseVersion(), artifact.getType(), artifact.getClassifier(), artifact.getScope(), artifact.isOptional(), artifact.getExtension(), null, project2.getLocalRepository(), false, false);
        }

        @JvmStatic
        @NotNull
        public final String getAttachedJarsLibName(@NotNull MavenArtifact artifact) {
            Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
            Object libraryName = artifact.getLibraryName();
            String string = libraryName;
            Intrinsics.checkNotNull((Object)string);
            boolean bl = StringsKt.startsWith$default((String)string, (String)"Maven: ", (boolean)false, (int)2, null);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            Object object = libraryName;
            Intrinsics.checkNotNull((Object)object);
            int n = 7;
            String string3 = ((String)object).substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            object = libraryName = "Maven: ATTACHED-JAR: " + string3;
            Intrinsics.checkNotNull((Object)object);
            return object;
        }

        @JvmStatic
        @NotNull
        public final DependencyScope selectScope(@Nullable String mavenScope) {
            if (Intrinsics.areEqual((Object)"runtime", (Object)mavenScope)) {
                return DependencyScope.RUNTIME;
            }
            if (Intrinsics.areEqual((Object)"test", (Object)mavenScope)) {
                return DependencyScope.TEST;
            }
            return Intrinsics.areEqual((Object)"provided", (Object)mavenScope) ? DependencyScope.PROVIDED : DependencyScope.COMPILE;
        }

        @Deprecated(message="use {@link MavenImportUtil#getSourceLanguageLevel(MavenProject)}")
        @NotNull
        public final LanguageLevel getLanguageLevel(@Nullable MavenProject mavenProject2) {
            MavenProject mavenProject3 = mavenProject2;
            Intrinsics.checkNotNull((Object)mavenProject3);
            LanguageLevel languageLevel = MavenImportUtil.getSourceLanguageLevel(mavenProject3);
            Intrinsics.checkNotNullExpressionValue((Object)languageLevel, (String)"getSourceLanguageLevel(...)");
            return languageLevel;
        }

        @Deprecated(message="use {@link MavenImportUtil#getDefaultLevel(MavenProject)}")
        @NotNull
        public final LanguageLevel getDefaultLevel(@Nullable MavenProject mavenProject2) {
            LanguageLevel languageLevel = MavenImportUtil.getDefaultLevel(mavenProject2);
            Intrinsics.checkNotNullExpressionValue((Object)languageLevel, (String)"getDefaultLevel(...)");
            return languageLevel;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 *2\u00020\u0001:\u0002*+BI\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010J0\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000e2\u001a\u0010\u001c\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u001e\u0012\u0004\u0012\u00020\u001f0\u001dJ2\u0010 \u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000e2\u001a\u0010\u001c\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u001e\u0012\u0004\u0012\u00020\u001f0\u001dH\u0002J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#H\u0002J$\u0010$\u001a\u00020\u00192\u001a\u0010\u001c\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u001e\u0012\u0004\u0012\u00020\u001f0\u001dH\u0002J$\u0010%\u001a\u00020\u00192\u001a\u0010\u001c\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u001e\u0012\u0004\u0012\u00020\u001f0\u001dH\u0002J\u000e\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u0015J\"\u0010(\u001a\u00020\u00192\u001a\u0010\u001c\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u001e\u0012\u0004\u0012\u00020\u001f0\u001dJ\"\u0010)\u001a\u00020\u00192\u001a\u0010\u001c\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u001e\u0012\u0004\u0012\u00020\u001f0\u001dR\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenLegacyModuleImporter$ExtensionImporter;", "", "myModule", "Lcom/intellij/openapi/module/Module;", "myMavenProjectsTree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "myMavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "myMavenProjectChanges", "Lorg/jetbrains/idea/maven/project/MavenProjectChanges;", "myMavenProjectToModuleName", "", "", "myImporters", "", "Lorg/jetbrains/idea/maven/importing/MavenImporter;", "(Lcom/intellij/openapi/module/Module;Lorg/jetbrains/idea/maven/project/MavenProjectsTree;Lorg/jetbrains/idea/maven/project/MavenProject;Lorg/jetbrains/idea/maven/project/MavenProjectChanges;Ljava/util/Map;Ljava/util/List;)V", "isModuleDisposed", "", "()Z", "myModifiableModelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "myRootModelAdapter", "Lorg/jetbrains/idea/maven/importing/MavenRootModelAdapter;", "config", "", "postTasks", "Lorg/jetbrains/idea/maven/project/MavenProjectsProcessorTask;", "counters", "", "Ljava/lang/Class;", "Lorg/jetbrains/idea/maven/importing/MavenLegacyModuleImporter$ExtensionImporter$CountAndTime;", "doConfig", "doConfigurationStep", "step", "Ljava/lang/Runnable;", "doPostConfig", "doPreConfig", "init", "ideModelsProvider", "postConfig", "preConfig", "Companion", "CountAndTime", "intellij.maven"})
    public static final class ExtensionImporter {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Module myModule;
        @NotNull
        private final MavenProjectsTree myMavenProjectsTree;
        @NotNull
        private final MavenProject myMavenProject;
        @NotNull
        private final MavenProjectChanges myMavenProjectChanges;
        @NotNull
        private final Map<MavenProject, String> myMavenProjectToModuleName;
        @NotNull
        private final List<MavenImporter> myImporters;
        @Nullable
        private MavenRootModelAdapter myRootModelAdapter;
        @Nullable
        private IdeModifiableModelsProvider myModifiableModelsProvider;

        private ExtensionImporter(Module myModule, MavenProjectsTree myMavenProjectsTree, MavenProject myMavenProject, MavenProjectChanges myMavenProjectChanges, Map<MavenProject, String> myMavenProjectToModuleName, List<? extends MavenImporter> myImporters) {
            this.myModule = myModule;
            this.myMavenProjectsTree = myMavenProjectsTree;
            this.myMavenProject = myMavenProject;
            this.myMavenProjectChanges = myMavenProjectChanges;
            this.myMavenProjectToModuleName = myMavenProjectToModuleName;
            this.myImporters = myImporters;
        }

        public final boolean isModuleDisposed() {
            return this.myModule.isDisposed();
        }

        public final void init(@NotNull IdeModifiableModelsProvider ideModelsProvider) {
            Intrinsics.checkNotNullParameter((Object)ideModelsProvider, (String)"ideModelsProvider");
            this.myModifiableModelsProvider = ideModelsProvider;
            this.myRootModelAdapter = new MavenRootModelAdapter(new MavenRootModelAdapterLegacyImpl(this.myMavenProject, this.myModule, this.myModifiableModelsProvider));
        }

        private final void doConfigurationStep(Runnable step) {
            MavenUtil.invokeAndWaitWriteAction(this.myModule.getProject(), step);
        }

        public final void preConfig(@NotNull Map<Class<? extends MavenImporter>, CountAndTime> counters) {
            Intrinsics.checkNotNullParameter(counters, (String)"counters");
            this.doConfigurationStep(() -> ExtensionImporter.preConfig$lambda$0(this, counters));
        }

        private final void doPreConfig(Map<Class<? extends MavenImporter>, CountAndTime> counters) {
            if (this.myModule.isDisposed()) {
                return;
            }
            ModuleType moduleType = ModuleType.get((Module)this.myModule);
            Intrinsics.checkNotNullExpressionValue((Object)moduleType, (String)"get(...)");
            ModuleType moduleType2 = moduleType;
            for (MavenImporter importer : this.myImporters) {
                try {
                    if (importer.getModuleType() != moduleType2) continue;
                    ExtensionImporter.Companion.measureImporterTime(importer, counters, true, () -> ExtensionImporter.doPreConfig$lambda$1(importer, this));
                }
                catch (Exception e) {
                    MavenLog.LOG.error("Exception in MavenImporter.preConfig, skipping it.", (Throwable)e);
                }
            }
        }

        public final void config(@NotNull List<? extends MavenProjectsProcessorTask> postTasks, @NotNull Map<Class<? extends MavenImporter>, CountAndTime> counters) {
            Intrinsics.checkNotNullParameter(postTasks, (String)"postTasks");
            Intrinsics.checkNotNullParameter(counters, (String)"counters");
            this.doConfigurationStep(() -> ExtensionImporter.config$lambda$2(this, postTasks, counters));
        }

        private final void doConfig(List<? extends MavenProjectsProcessorTask> postTasks, Map<Class<? extends MavenImporter>, CountAndTime> counters) {
            if (this.myModule.isDisposed()) {
                return;
            }
            ModuleType moduleType = ModuleType.get((Module)this.myModule);
            Intrinsics.checkNotNullExpressionValue((Object)moduleType, (String)"get(...)");
            ModuleType moduleType2 = moduleType;
            for (MavenImporter importer : this.myImporters) {
                if (importer.getModuleType() != moduleType2) continue;
                try {
                    ExtensionImporter.Companion.measureImporterTime(importer, counters, false, () -> ExtensionImporter.doConfig$lambda$3(importer, this, postTasks));
                }
                catch (Exception e) {
                    MavenLog.LOG.error("Exception in MavenImporter.config, skipping it.", (Throwable)e);
                }
            }
        }

        public final void postConfig(@NotNull Map<Class<? extends MavenImporter>, CountAndTime> counters) {
            Intrinsics.checkNotNullParameter(counters, (String)"counters");
            this.doConfigurationStep(() -> ExtensionImporter.postConfig$lambda$4(this, counters));
        }

        private final void doPostConfig(Map<Class<? extends MavenImporter>, CountAndTime> counters) {
            if (this.myModule.isDisposed()) {
                return;
            }
            ModuleType moduleType = ModuleType.get((Module)this.myModule);
            Intrinsics.checkNotNullExpressionValue((Object)moduleType, (String)"get(...)");
            ModuleType moduleType2 = moduleType;
            for (MavenImporter importer : this.myImporters) {
                try {
                    if (!Intrinsics.areEqual(importer.getModuleType(), (Object)moduleType2)) continue;
                    ExtensionImporter.Companion.measureImporterTime(importer, counters, false, () -> ExtensionImporter.doPostConfig$lambda$5(importer, this));
                }
                catch (Exception e) {
                    MavenLog.LOG.error("Exception in MavenImporter.postConfig, skipping it.", (Throwable)e);
                }
            }
        }

        private static final void preConfig$lambda$0(ExtensionImporter this$0, Map $counters) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$counters, (String)"$counters");
            this$0.doPreConfig($counters);
        }

        private static final void doPreConfig$lambda$1(MavenImporter $importer, ExtensionImporter this$0) {
            Intrinsics.checkNotNullParameter((Object)$importer, (String)"$importer");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            $importer.preProcess(this$0.myModule, this$0.myMavenProject, this$0.myMavenProjectChanges, this$0.myModifiableModelsProvider);
        }

        private static final void config$lambda$2(ExtensionImporter this$0, List $postTasks, Map $counters) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$postTasks, (String)"$postTasks");
            Intrinsics.checkNotNullParameter((Object)$counters, (String)"$counters");
            this$0.doConfig($postTasks, $counters);
        }

        private static final void doConfig$lambda$3(MavenImporter $importer, ExtensionImporter this$0, List $postTasks) {
            Intrinsics.checkNotNullParameter((Object)$importer, (String)"$importer");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$postTasks, (String)"$postTasks");
            IdeModifiableModelsProvider ideModifiableModelsProvider = this$0.myModifiableModelsProvider;
            Intrinsics.checkNotNull((Object)ideModifiableModelsProvider);
            Module module2 = this$0.myModule;
            MavenRootModelAdapter mavenRootModelAdapter = this$0.myRootModelAdapter;
            Intrinsics.checkNotNull((Object)mavenRootModelAdapter);
            $importer.process(ideModifiableModelsProvider, module2, mavenRootModelAdapter, this$0.myMavenProjectsTree, this$0.myMavenProject, this$0.myMavenProjectChanges, this$0.myMavenProjectToModuleName, $postTasks);
        }

        private static final void postConfig$lambda$4(ExtensionImporter this$0, Map $counters) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$counters, (String)"$counters");
            this$0.doPostConfig($counters);
        }

        private static final void doPostConfig$lambda$5(MavenImporter $importer, ExtensionImporter this$0) {
            Intrinsics.checkNotNullParameter((Object)$importer, (String)"$importer");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            $importer.postProcess(this$0.myModule, this$0.myMavenProject, this$0.myMavenProjectChanges, this$0.myModifiableModelsProvider);
        }

        @JvmStatic
        @Nullable
        public static final ExtensionImporter createIfApplicable(@NotNull MavenProject mavenProject2, @NotNull Module module2, @NotNull StandardMavenModuleType moduleType, @NotNull MavenProjectsTree mavenTree, @NotNull MavenProjectChanges changes, @NotNull Map<MavenProject, String> mavenProjectToModuleName, boolean isWorkspaceImport) {
            return Companion.createIfApplicable(mavenProject2, module2, moduleType, mavenTree, changes, mavenProjectToModuleName, isWorkspaceImport);
        }

        public /* synthetic */ ExtensionImporter(Module myModule, MavenProjectsTree myMavenProjectsTree, MavenProject myMavenProject, MavenProjectChanges myMavenProjectChanges, Map myMavenProjectToModuleName, List myImporters, DefaultConstructorMarker $constructor_marker) {
            this(myModule, myMavenProjectsTree, myMavenProject, myMavenProjectChanges, myMavenProjectToModuleName, myImporters);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JN\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J<\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u001a\u0010\u0018\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u001a\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenLegacyModuleImporter$ExtensionImporter$Companion;", "", "()V", "createIfApplicable", "Lorg/jetbrains/idea/maven/importing/MavenLegacyModuleImporter$ExtensionImporter;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "module", "Lcom/intellij/openapi/module/Module;", "moduleType", "Lorg/jetbrains/idea/maven/importing/StandardMavenModuleType;", "mavenTree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "changes", "Lorg/jetbrains/idea/maven/project/MavenProjectChanges;", "mavenProjectToModuleName", "", "", "isWorkspaceImport", "", "measureImporterTime", "", "importer", "Lorg/jetbrains/idea/maven/importing/MavenImporter;", "counters", "", "Ljava/lang/Class;", "Lorg/jetbrains/idea/maven/importing/MavenLegacyModuleImporter$ExtensionImporter$CountAndTime;", "increaseModuleCounter", "r", "Ljava/lang/Runnable;", "intellij.maven"})
        @SourceDebugExtension(value={"SMAP\nMavenLegacyModuleImporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenLegacyModuleImporter.kt\norg/jetbrains/idea/maven/importing/MavenLegacyModuleImporter$ExtensionImporter$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,399:1\n766#2:400\n857#2,2:401\n*S KotlinDebug\n*F\n+ 1 MavenLegacyModuleImporter.kt\norg/jetbrains/idea/maven/importing/MavenLegacyModuleImporter$ExtensionImporter$Companion\n*L\n171#1:400\n171#1:401,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @Nullable
            public final ExtensionImporter createIfApplicable(@NotNull MavenProject mavenProject2, @NotNull Module module2, @NotNull StandardMavenModuleType moduleType, @NotNull MavenProjectsTree mavenTree, @NotNull MavenProjectChanges changes, @NotNull Map<MavenProject, String> mavenProjectToModuleName, boolean isWorkspaceImport) {
                ExtensionImporter extensionImporter;
                List list;
                Intrinsics.checkNotNullParameter((Object)mavenProject2, (String)"mavenProject");
                Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
                Intrinsics.checkNotNullParameter((Object)moduleType, (String)"moduleType");
                Intrinsics.checkNotNullParameter((Object)mavenTree, (String)"mavenTree");
                Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
                Intrinsics.checkNotNullParameter(mavenProjectToModuleName, (String)"mavenProjectToModuleName");
                if (moduleType == StandardMavenModuleType.COMPOUND_MODULE) {
                    return null;
                }
                List suitableImporters = MavenImporter.getSuitableImporters(mavenProject2, isWorkspaceImport);
                if (!isWorkspaceImport && !changes.hasChanges()) {
                    void $this$filterTo$iv$iv;
                    list = suitableImporters;
                    Intrinsics.checkNotNull(list);
                    Iterable $this$filter$iv = list;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        MavenImporter it = (MavenImporter)element$iv$iv;
                        boolean bl = false;
                        if (!(!it.processChangedModulesOnly())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    suitableImporters = (List)destination$iv$iv;
                }
                if (suitableImporters.isEmpty()) {
                    extensionImporter = null;
                } else {
                    list = suitableImporters;
                    Intrinsics.checkNotNull(list);
                    ExtensionImporter extensionImporter2 = new ExtensionImporter(module2, mavenTree, mavenProject2, changes, mavenProjectToModuleName, list, null);
                    extensionImporter = extensionImporter2;
                }
                return extensionImporter;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void measureImporterTime(MavenImporter importer, Map<Class<? extends MavenImporter>, CountAndTime> counters, boolean increaseModuleCounter, Runnable r) {
                long before = System.nanoTime();
                try {
                    r.run();
                }
                finally {
                    CountAndTime countAndTime2 = counters.computeIfAbsent(importer.getClass(), arg_0 -> Companion.measureImporterTime$lambda$1(measureImporterTime.countAndTime.1.INSTANCE, arg_0));
                    Intrinsics.checkNotNullExpressionValue((Object)countAndTime2, (String)"computeIfAbsent(...)");
                    CountAndTime countAndTime3 = countAndTime2;
                    if (increaseModuleCounter) {
                        int n = countAndTime3.getCount();
                        countAndTime3.setCount(n + 1);
                    }
                    countAndTime3.setTimeNano(countAndTime3.getTimeNano() + (System.nanoTime() - before));
                }
            }

            private static final CountAndTime measureImporterTime$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (CountAndTime)$tmp0.invoke(p0);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenLegacyModuleImporter$ExtensionImporter$CountAndTime;", "", "()V", "count", "", "getCount", "()I", "setCount", "(I)V", "timeNano", "", "getTimeNano", "()J", "setTimeNano", "(J)V", "intellij.maven"})
        public static final class CountAndTime {
            private int count;
            private long timeNano;

            public final int getCount() {
                return this.count;
            }

            public final void setCount(int n) {
                this.count = n;
            }

            public final long getTimeNano() {
                return this.timeNano;
            }

            public final void setTimeNano(long l) {
                this.timeNano = l;
            }
        }
    }
}

