/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.compiler.options.CompileStepBeforeRunNoErrorCheck;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.DefaultJavaProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import icons.OpenapiIcons;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.execution.build.DelegateBuildRunner;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.utils.MavenUtil;

public final class MavenRunConfigurationType
implements ConfigurationType,
DumbAware {
    private static final Key<Boolean> IS_DELEGATE_BUILD = new Key("IS_DELEGATE_BUILD");
    private final ConfigurationFactory myFactory = new MavenRunConfigurationFactory(this);
    private static final int MAX_NAME_LENGTH = 40;

    public static MavenRunConfigurationType getInstance() {
        return (MavenRunConfigurationType)ConfigurationTypeUtil.findConfigurationType(MavenRunConfigurationType.class);
    }

    MavenRunConfigurationType() {
    }

    @NotNull
    public String getDisplayName() {
        String string = RunnerBundle.message("maven.run.configuration.name", new Object[0]);
        if (string == null) {
            MavenRunConfigurationType.$$$reportNull$$$0(0);
        }
        return string;
    }

    public String getConfigurationTypeDescription() {
        return RunnerBundle.message("maven.run.configuration.description", new Object[0]);
    }

    public Icon getIcon() {
        return OpenapiIcons.RepositoryLibraryLogo;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myFactory};
    }

    public String getHelpTopic() {
        return "reference.dialogs.rundebug.MavenRunConfiguration";
    }

    @NonNls
    @NotNull
    public String getId() {
        return "MavenRunConfiguration";
    }

    @NlsSafe
    public static String generateName(Project project2, MavenRunnerParameters runnerParameters) {
        List<String> goals;
        StringBuilder stringBuilder = new StringBuilder();
        String name = MavenRunConfigurationType.getMavenProjectName(project2, runnerParameters);
        if (!StringUtil.isEmptyOrSpaces((String)name)) {
            stringBuilder.append(name);
        }
        if (!(goals = runnerParameters.getGoals()).isEmpty()) {
            stringBuilder.append(" [");
            MavenRunConfigurationType.listGoals(stringBuilder, goals);
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    private static void listGoals(StringBuilder stringBuilder, List<String> goals) {
        int index = 0;
        for (String goal : goals) {
            if (index != 0) {
                if (stringBuilder.length() + goal.length() < 40) {
                    stringBuilder.append(",");
                } else {
                    stringBuilder.append("...");
                    break;
                }
            }
            stringBuilder.append(goal);
            ++index;
        }
    }

    @Nullable
    private static String getMavenProjectName(Project project2, MavenRunnerParameters runnerParameters) {
        MavenProject mavenProject2;
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(runnerParameters.getWorkingDirPath() + "/pom.xml");
        if (virtualFile != null && (mavenProject2 = MavenProjectsManager.getInstance(project2).findProject(virtualFile)) != null && !StringUtil.isEmptyOrSpaces((String)mavenProject2.getMavenId().getArtifactId())) {
            return mavenProject2.getMavenId().getArtifactId();
        }
        return null;
    }

    public static boolean isDelegate(ExecutionEnvironment environment) {
        Boolean res = (Boolean)IS_DELEGATE_BUILD.get((UserDataHolder)environment);
        return res != null && res != false;
    }

    public static void runConfiguration(Project project2, MavenRunnerParameters params, @Nullable ProgramRunner.Callback callback) {
        MavenRunConfigurationType.runConfiguration(project2, params, null, null, callback);
    }

    public static void runConfiguration(Project project2, @NotNull MavenRunnerParameters params, @Nullable MavenGeneralSettings settings, @Nullable MavenRunnerSettings runnerSettings, @Nullable ProgramRunner.Callback callback) {
        if (params == null) {
            MavenRunConfigurationType.$$$reportNull$$$0(1);
        }
        MavenRunConfigurationType.runConfiguration(project2, params, settings, runnerSettings, callback, false);
    }

    public static void runConfiguration(Project project2, @NotNull MavenRunnerParameters params, @Nullable MavenGeneralSettings settings, @Nullable MavenRunnerSettings runnerSettings, @Nullable ProgramRunner.Callback callback, boolean isDelegateBuild) {
        if (params == null) {
            MavenRunConfigurationType.$$$reportNull$$$0(2);
        }
        if (!ExternalSystemUtil.confirmLoadingUntrustedProject((Project)project2, (ProjectSystemId)MavenUtil.SYSTEM_ID)) {
            MavenUtil.showError(project2, RunnerBundle.message("notification.title.failed.to.execute.maven.goal", new Object[0]), RunnerBundle.message("notification.project.is.untrusted", new Object[0]));
            return;
        }
        RunnerAndConfigurationSettings configSettings = MavenRunConfigurationType.createRunnerAndConfigurationSettings(settings, runnerSettings, params, project2, MavenRunConfigurationType.generateName(project2, params), isDelegateBuild);
        ProgramRunner runner = isDelegateBuild ? DelegateBuildRunner.getDelegateRunner() : DefaultJavaProgramRunner.getInstance();
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        ExecutionEnvironment environment = new ExecutionEnvironment(executor, runner, configSettings, project2);
        environment.putUserData(IS_DELEGATE_BUILD, (Object)isDelegateBuild);
        environment.setCallback(callback);
        ApplicationManager.getApplication().invokeAndWait(() -> {
            try {
                runner.execute(environment);
            }
            catch (ExecutionException e) {
                MavenUtil.showError(project2, RunnerBundle.message("notification.title.failed.to.execute.maven.goal", new Object[0]), e);
            }
        });
    }

    @NotNull
    public static RunnerAndConfigurationSettings createRunnerAndConfigurationSettings(@Nullable MavenGeneralSettings generalSettings, @Nullable MavenRunnerSettings runnerSettings, @NotNull MavenRunnerParameters params, @NotNull Project project2) {
        if (params == null) {
            MavenRunConfigurationType.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            MavenRunConfigurationType.$$$reportNull$$$0(4);
        }
        return MavenRunConfigurationType.createRunnerAndConfigurationSettings(generalSettings, runnerSettings, params, project2, MavenRunConfigurationType.generateName(project2, params), false);
    }

    @NotNull
    public static RunnerAndConfigurationSettings createRunnerAndConfigurationSettings(@Nullable MavenGeneralSettings generalSettings, @Nullable MavenRunnerSettings runnerSettings, @NotNull MavenRunnerParameters params, @NotNull Project project2, @NotNull String name, boolean isDelegate) {
        if (params == null) {
            MavenRunConfigurationType.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            MavenRunConfigurationType.$$$reportNull$$$0(6);
        }
        if (name == null) {
            MavenRunConfigurationType.$$$reportNull$$$0(7);
        }
        MavenRunConfigurationType type2 = (MavenRunConfigurationType)ConfigurationTypeUtil.findConfigurationType(MavenRunConfigurationType.class);
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)project2).createConfiguration(name, type2.myFactory);
        MavenRunConfiguration runConfiguration = (MavenRunConfiguration)settings.getConfiguration();
        if (isDelegate) {
            runConfiguration.setBeforeRunTasks(Collections.emptyList());
        }
        MavenGeneralSettings generalSettingsToRun = generalSettings != null ? generalSettings : MavenWorkspaceSettingsComponent.getInstance(project2).getSettings().getGeneralSettings();
        MavenRunnerSettings runnerSettingsToRun = runnerSettings != null ? runnerSettings : MavenRunner.getInstance(project2).getState();
        runConfiguration.setRunnerParameters(params);
        runConfiguration.setGeneralSettings(generalSettingsToRun);
        runConfiguration.setRunnerSettings(runnerSettingsToRun);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = settings;
        if (runnerAndConfigurationSettings == null) {
            MavenRunConfigurationType.$$$reportNull$$$0(8);
        }
        return runnerAndConfigurationSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/execution/MavenRunConfigurationType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenRunConfigurationType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createRunnerAndConfigurationSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runConfiguration";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRunnerAndConfigurationSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    public static class MavenRunConfigurationFactory
    extends ConfigurationFactory {
        public MavenRunConfigurationFactory(ConfigurationType type2) {
            super(type2);
        }

        @NotNull
        public RunConfiguration createTemplateConfiguration(@NotNull Project project2) {
            if (project2 == null) {
                MavenRunConfigurationFactory.$$$reportNull$$$0(0);
            }
            return new MavenRunConfiguration(project2, this, "");
        }

        @NotNull
        public RunConfiguration createTemplateConfiguration(@NotNull Project project2, @NotNull RunManager runManager) {
            if (project2 == null) {
                MavenRunConfigurationFactory.$$$reportNull$$$0(1);
            }
            if (runManager == null) {
                MavenRunConfigurationFactory.$$$reportNull$$$0(2);
            }
            return new MavenRunConfiguration(project2, this, "");
        }

        @NotNull
        public String getId() {
            return "Maven";
        }

        @NotNull
        public RunConfiguration createConfiguration(@Nullable String name, @NotNull RunConfiguration template) {
            MavenRunConfiguration cfg;
            if (template == null) {
                MavenRunConfigurationFactory.$$$reportNull$$$0(3);
            }
            if (!StringUtil.isEmptyOrSpaces((String)(cfg = (MavenRunConfiguration)super.createConfiguration(name, template)).getRunnerParameters().getWorkingDirPath())) {
                MavenRunConfiguration mavenRunConfiguration = cfg;
                if (mavenRunConfiguration == null) {
                    MavenRunConfigurationFactory.$$$reportNull$$$0(4);
                }
                return mavenRunConfiguration;
            }
            Project project2 = cfg.getProject();
            MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(project2);
            List<MavenProject> projects = projectsManager.getProjects();
            if (projects.size() != 1) {
                MavenRunConfiguration mavenRunConfiguration = cfg;
                if (mavenRunConfiguration == null) {
                    MavenRunConfigurationFactory.$$$reportNull$$$0(5);
                }
                return mavenRunConfiguration;
            }
            VirtualFile directory = projects.get(0).getDirectoryFile();
            cfg.getRunnerParameters().setWorkingDirPath(directory.getPath());
            MavenRunConfiguration mavenRunConfiguration = cfg;
            if (mavenRunConfiguration == null) {
                MavenRunConfigurationFactory.$$$reportNull$$$0(6);
            }
            return mavenRunConfiguration;
        }

        public void configureBeforeRunTaskDefaults(Key<? extends BeforeRunTask> providerID, BeforeRunTask task) {
            if (providerID == CompileStepBeforeRun.ID || providerID == CompileStepBeforeRunNoErrorCheck.ID) {
                task.setEnabled(false);
            }
        }

        public boolean isEditableInDumbMode() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runManager";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/maven/execution/MavenRunConfigurationType$MavenRunConfigurationFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenRunConfigurationType$MavenRunConfigurationFactory";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createConfiguration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createTemplateConfiguration";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createConfiguration";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

