/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven;

import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildViewManager;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.OutputBuildEvent;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.CommandLineInspectionProjectAsyncConfigurator;
import com.intellij.ide.CommandLineInspectionProjectConfigurator;
import com.intellij.ide.environment.EnvironmentService;
import com.intellij.ide.impl.ProjectOpenKeyProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.externalSystem.autolink.ExternalSystemUnlinkedProjectAware;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfigurationViewManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.SdkLookup;
import com.intellij.openapi.roots.ui.configuration.SdkLookupBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.lang.JavaVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.MavenCommandLineInspectionProjectConfigurator;
import org.jetbrains.idea.maven.MavenCommandLineInspectionProjectConfiguratorKt;
import org.jetbrains.idea.maven.importing.MavenImportUtil;
import org.jetbrains.idea.maven.importing.tree.MavenJavaVersionHolder;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;
import org.jetbrains.idea.maven.utils.MavenArtifactUtilKt;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.wizards.MavenOpenProjectProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J!\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J&\u0010\u000e\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/idea/maven/MavenCommandLineInspectionProjectConfigurator;", "Lcom/intellij/ide/CommandLineInspectionProjectAsyncConfigurator;", "()V", "configureEnvironment", "", "context", "Lcom/intellij/ide/CommandLineInspectionProjectConfigurator$ConfiguratorContext;", "configureProjectAsync", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/CommandLineInspectionProjectConfigurator$ConfiguratorContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDescription", "", "getName", "setupDefaultJdk", "projects", "", "Lorg/jetbrains/idea/maven/project/MavenProject;", "setupJdkWithVersionAboveOrEqual", "maxLevel", "Lcom/intellij/pom/java/LanguageLevel;", "LogBuildProgressListener", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenCommandLineInspectionProjectConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenCommandLineInspectionProjectConfigurator.kt\norg/jetbrains/idea/maven/MavenCommandLineInspectionProjectConfigurator\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n43#2,3:211\n30#3,3:214\n30#3,3:217\n30#3,3:220\n819#4:223\n847#4,2:224\n819#4:226\n847#4,2:227\n819#4:229\n847#4,2:230\n1360#4:232\n1446#4,5:233\n*S KotlinDebug\n*F\n+ 1 MavenCommandLineInspectionProjectConfigurator.kt\norg/jetbrains/idea/maven/MavenCommandLineInspectionProjectConfigurator\n*L\n74#1:211,3\n89#1:214,3\n90#1:217,3\n91#1:220,3\n133#1:223\n133#1:224,2\n134#1:226\n134#1:227,2\n140#1:229\n140#1:230,2\n162#1:232\n162#1:233,5\n*E\n"})
public final class MavenCommandLineInspectionProjectConfigurator
implements CommandLineInspectionProjectAsyncConfigurator {
    @NotNull
    public String getName() {
        return "maven";
    }

    @NotNull
    public String getDescription() {
        String string = MavenProjectBundle.message("maven.commandline.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void configureEnvironment(@NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        CommandLineInspectionProjectConfigurator.ConfiguratorContext $this$configureEnvironment_u24lambda_u240 = context2;
        boolean bl = false;
        System.setProperty("maven.create.dummy.module.on.first.import", "false");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object configureProjectAsync(@NotNull Project var1_1, @NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof configureProjectAsync.1)) ** GOTO lbl-1000
        var34_4 = var3_3;
        if ((var34_4.label & -2147483648) != 0) {
            var34_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ MavenCommandLineInspectionProjectConfigurator this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.configureProjectAsync(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var35_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = context.getProjectPath();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getProjectPath(...)");
                basePath = v0.toString();
                pomXmlFile = basePath + "/pom.xml";
                var6_9 = new String[]{pomXmlFile};
                if (FileUtil.findFirstThatExist((String[])var6_9) == null) {
                    return Unit.INSTANCE;
                }
                $i$f$service = false;
                serviceClass$iv = EnvironmentService.class;
                var9_13 = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (var9_13 == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                }
                service = (EnvironmentService)var9_13;
                $continuation.L$0 = this;
                $continuation.L$1 = project;
                $continuation.L$2 = context;
                $continuation.L$3 = basePath;
                $continuation.label = 1;
                v1 = service.getEnvironmentValue(ProjectOpenKeyProvider.Keys.INSTANCE.getPROJECT_OPEN_PROCESSOR(), "Maven", (Continuation)$continuation);
                if (v1 == var35_6) {
                    return var35_6;
                }
                ** GOTO lbl41
            }
            case 1: {
                basePath = (String)$continuation.L$3;
                context = (CommandLineInspectionProjectConfigurator.ConfiguratorContext)$continuation.L$2;
                project = (Project)$continuation.L$1;
                this = (MavenCommandLineInspectionProjectConfigurator)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl41:
                // 2 sources

                if (!Intrinsics.areEqual((Object)(projectSelectionKey = (String)v1), (Object)"Maven")) {
                    return Unit.INSTANCE;
                }
                v2 = MavenUtil.SYSTEM_ID;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"SYSTEM_ID");
                v3 = ExternalSystemUnlinkedProjectAware.Companion.getInstance(v2);
                Intrinsics.checkNotNull((Object)v3);
                mavenProjectAware = v3;
                isMavenProjectLinked = mavenProjectAware.isLinkedProject(project, basePath);
                MavenCommandLineInspectionProjectConfiguratorKt.access$getLOG$p().info("maven project: " + project.getName() + " is linked: " + (isMavenProjectLinked != false));
                v4 = Disposer.newDisposable();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"newDisposable(...)");
                disposable = v4;
                progressListener = new LogBuildProgressListener();
                $this$service$iv = (ComponentManager)project;
                $i$f$service = false;
                serviceClass$iv = ExternalSystemRunConfigurationViewManager.class;
                var16_23 = $this$service$iv.getService(serviceClass$iv);
                if (var16_23 == null) {
                    throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
                }
                externalSystemRunConfigurationViewManager = (ExternalSystemRunConfigurationViewManager)var16_23;
                $this$service$iv = (ComponentManager)project;
                $i$f$service = false;
                serviceClass$iv = BuildViewManager.class;
                var17_27 = $this$service$iv.getService(serviceClass$iv);
                if (var17_27 == null) {
                    throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
                }
                buildViewManager = (BuildViewManager)var17_27;
                $this$service$iv = (ComponentManager)project;
                $i$f$service = false;
                serviceClass$iv = SyncViewManager.class;
                var18_30 = $this$service$iv.getService(serviceClass$iv);
                if (var18_30 == null) {
                    throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
                }
                syncViewManager = (SyncViewManager)var18_30;
                externalSystemRunConfigurationViewManager.addListener((BuildProgressListener)progressListener, disposable);
                buildViewManager.addListener((BuildProgressListener)progressListener, disposable);
                syncViewManager.addListener((BuildProgressListener)progressListener, disposable);
                if (isMavenProjectLinked) ** GOTO lbl114
                $continuation.L$0 = this;
                $continuation.L$1 = project;
                $continuation.L$2 = context;
                $continuation.L$3 = basePath;
                $continuation.L$4 = disposable;
                $continuation.label = 2;
                v5 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, null){
                    int label;
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                FileDocumentManager.getInstance().saveAllDocuments();
                                MavenUtil.setupProjectSdk(this.$project);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v5 == var35_6) {
                    return var35_6;
                }
                ** GOTO lbl97
            }
            case 2: {
                disposable = (Disposable)$continuation.L$4;
                basePath = (String)$continuation.L$3;
                context = (CommandLineInspectionProjectConfigurator.ConfiguratorContext)$continuation.L$2;
                project = (Project)$continuation.L$1;
                this = (MavenCommandLineInspectionProjectConfigurator)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl97:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = project;
                $continuation.L$2 = context;
                $continuation.L$3 = disposable;
                $continuation.L$4 = null;
                $continuation.label = 3;
                v6 = new MavenOpenProjectProvider().forceLinkToExistingProjectAsync(basePath, project, (Continuation<? super Unit>)$continuation);
                if (v6 == var35_6) {
                    return var35_6;
                }
                ** GOTO lbl114
            }
            case 3: {
                disposable = (Disposable)$continuation.L$3;
                context = (CommandLineInspectionProjectConfigurator.ConfiguratorContext)$continuation.L$2;
                project = (Project)$continuation.L$1;
                this = (MavenCommandLineInspectionProjectConfigurator)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl114:
                // 3 sources

                MavenLog.LOG.warn("linked finished for " + project.getName());
                mavenProjectsManager = MavenProjectsManager.getInstance(project);
                promise = mavenProjectsManager.waitForImportCompletion();
                while (true) {
                    try {
                        promise.blockingGet(10, TimeUnit.MILLISECONDS);
                        break;
                    }
                    catch (TimeoutException serviceClass$iv) {
                    }
                    catch (ExecutionException e) {
                        ExceptionUtil.rethrow((Throwable)e);
                    }
                    ProgressManager.checkCanceled();
                }
                Disposer.dispose((Disposable)disposable);
                for (MavenProject mavenProject : mavenProjectsManager.getProjects()) {
                    hasReadingProblems = mavenProject.hasReadingProblems();
                    if (hasReadingProblems) {
                        throw new IllegalStateException("Maven project " + mavenProject.getName() + " has import problems:" + mavenProject.getProblems());
                    }
                    hasUnresolvedArtifacts = mavenProject.hasUnresolvedArtifacts();
                    if (hasUnresolvedArtifacts) {
                        v7 = mavenProject.getDependencies();
                        Intrinsics.checkNotNullExpressionValue(v7, (String)"getDependencies(...)");
                        $this$filterNot$iv = v7;
                        $i$f$filterNot = false;
                        var24_39 = $this$filterNot$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterNotTo = false;
                        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                            it = (MavenArtifact)element$iv$iv;
                            $i$a$-filterNot-MavenCommandLineInspectionProjectConfigurator$configureProjectAsync$unresolvedArtifacts$1 = false;
                            Intrinsics.checkNotNull((Object)it);
                            if (MavenArtifactUtilKt.resolved(it)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        v8 = (List)destination$iv$iv;
                        v9 = mavenProject.getExternalAnnotationProcessors();
                        Intrinsics.checkNotNullExpressionValue(v9, (String)"getExternalAnnotationProcessors(...)");
                        $this$filterNot$iv = v9;
                        var32_50 = v8;
                        $i$f$filterNot = false;
                        $this$filterNotTo$iv$iv = $this$filterNot$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterNotTo = false;
                        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                            it = (MavenArtifact)element$iv$iv;
                            $i$a$-filterNot-MavenCommandLineInspectionProjectConfigurator$configureProjectAsync$unresolvedArtifacts$2 = false;
                            Intrinsics.checkNotNull((Object)it);
                            if (MavenArtifactUtilKt.resolved(it)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        unresolvedArtifacts = CollectionsKt.plus((Collection)var32_50, (Iterable)((List)destination$iv$iv));
                        throw new IllegalStateException("Maven project " + mavenProject.getName() + " has unresolved artifacts: " + unresolvedArtifacts);
                    }
                    hasUnresolvedPlugins = mavenProject.hasUnresolvedPlugins();
                    if (!hasUnresolvedPlugins) continue;
                    v10 = mavenProject.getDeclaredPlugins();
                    Intrinsics.checkNotNullExpressionValue(v10, (String)"getDeclaredPlugins(...)");
                    $this$filterNot$iv = v10;
                    $i$f$filterNot = false;
                    destination$iv$iv = $this$filterNot$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterNotTo = false;
                    for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                        plugin = (MavenPlugin)element$iv$iv;
                        $i$a$-filterNot-MavenCommandLineInspectionProjectConfigurator$configureProjectAsync$unresolvedPlugins$1 = false;
                        if (MavenArtifactUtil.hasArtifactFile(mavenProject.getLocalRepository(), plugin.getMavenId())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    unresolvedPlugins = (List)destination$iv$iv;
                    errorMessage = "maven project: " + mavenProject.getName() + " has unresolved plugins: " + unresolvedPlugins;
                    if (Boolean.parseBoolean(System.getProperty("maven.command.line.configurator.exit.on.unresolved.plugins", "false"))) {
                        throw new IllegalStateException(errorMessage);
                    }
                    MavenCommandLineInspectionProjectConfiguratorKt.access$getLOG$p().warn(errorMessage);
                }
                v11 = mavenProjectsManager.getProjects();
                Intrinsics.checkNotNullExpressionValue(v11, (String)"getProjects(...)");
                if (((Collection)v11).isEmpty() == false) {
                    var17_27 = mavenProjectsManager.getProjects();
                    Intrinsics.checkNotNullExpressionValue((Object)var17_27, (String)"getProjects(...)");
                    this.setupDefaultJdk((List<? extends MavenProject>)var17_27, context, project);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final void setupDefaultJdk(List<? extends MavenProject> projects, CommandLineInspectionProjectConfigurator.ConfiguratorContext context2, Project project2) {
        void $this$flatMapTo$iv$iv;
        List list = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)JavaSdk.getInstance());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSdksOfType(...)");
        if (!((Collection)list).isEmpty()) {
            return;
        }
        Iterable $this$flatMap$iv = projects;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            MavenJavaVersionHolder javaVersions;
            MavenProject it = (MavenProject)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)MavenImportUtil.getMavenJavaVersions(it), (String)"getMavenJavaVersions(...)");
            Object[] objectArray = new LanguageLevel[]{javaVersions.sourceLevel, javaVersions.testSourceLevel, javaVersions.targetLevel, javaVersions.testTargetLevel};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable iterable2 = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        Comparator comparator2 = Comparator.naturalOrder();
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"naturalOrder(...)");
        LanguageLevel languageLevel = (LanguageLevel)CollectionsKt.maxWithOrNull((Iterable)iterable2, comparator2);
        if (languageLevel == null) {
            languageLevel = LanguageLevel.HIGHEST;
        }
        LanguageLevel maxLevel = languageLevel;
        Intrinsics.checkNotNull((Object)maxLevel);
        this.setupJdkWithVersionAboveOrEqual(maxLevel, project2, context2);
    }

    private final void setupJdkWithVersionAboveOrEqual(LanguageLevel maxLevel, Project project2, CommandLineInspectionProjectConfigurator.ConfiguratorContext context2) {
        LanguageLevel currentLevel = maxLevel;
        while (currentLevel != null) {
            LanguageLevel level = currentLevel;
            CompletableFuture<Sdk> future = new CompletableFuture<Sdk>();
            SdkLookupBuilder sdkLookupBuilder = SdkLookup.Companion.newLookupBuilder();
            ProgressIndicator progressIndicator = context2.getProgressIndicator();
            Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"getProgressIndicator(...)");
            SdkLookupBuilder sdkLookupBuilder2 = sdkLookupBuilder.withProgressIndicator(progressIndicator).withVersionFilter((Function1)new Function1<String, Boolean>(level){
                final /* synthetic */ LanguageLevel $level;
                {
                    this.$level = $level;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    JavaVersion javaVersion = JavaVersion.tryParse((String)it);
                    return javaVersion != null ? javaVersion.feature == this.$level.toJavaVersion().feature : false;
                }
            });
            JavaSdk javaSdk = JavaSdk.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)javaSdk, (String)"getInstance(...)");
            sdkLookupBuilder2.withSdkType((SdkType)javaSdk).onSdkResolved((Function1)new Function1<Sdk, Unit>(future){
                final /* synthetic */ CompletableFuture<Sdk> $future;
                {
                    this.$future = $future;
                    super(1);
                }

                public final void invoke(@Nullable Sdk sdk) {
                    this.$future.complete(sdk);
                }
            }).executeLookup();
            Sdk sdk = future.get();
            if (sdk != null) {
                ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Unit>(project2, sdk){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Sdk $sdk;
                    {
                        this.$project = $project;
                        this.$sdk = $sdk;
                        super(0);
                    }

                    public final void invoke() {
                        ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this.$project, this.$sdk){
                            final /* synthetic */ Project $project;
                            final /* synthetic */ Sdk $sdk;
                            {
                                this.$project = $project;
                                this.$sdk = $sdk;
                                super(0);
                            }

                            public final void invoke() {
                                ProjectRootManager.getInstance((Project)this.$project).setProjectSdk(this.$sdk);
                            }
                        }));
                    }
                }), (int)1, null);
                return;
            }
            currentLevel = LanguageLevelUtil.getNextLanguageLevel((LanguageLevel)currentLevel);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/idea/maven/MavenCommandLineInspectionProjectConfigurator$LogBuildProgressListener;", "Lcom/intellij/build/BuildProgressListener;", "()V", "onEvent", "", "buildId", "", "event", "Lcom/intellij/build/events/BuildEvent;", "intellij.maven"})
    public static final class LogBuildProgressListener
    implements BuildProgressListener {
        public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
            Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            OutputBuildEvent outputBuildEvent = event instanceof OutputBuildEvent ? (OutputBuildEvent)event : null;
            if (outputBuildEvent == null) {
                return;
            }
            OutputBuildEvent outputBuildEvent2 = outputBuildEvent;
            String prefix = outputBuildEvent2.isStdOut() ? "" : "stderr: ";
            MavenCommandLineInspectionProjectConfiguratorKt.access$getMAVEN_OUTPUT_LOG$p().debug(prefix + outputBuildEvent2.getMessage());
        }
    }
}

